/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.collect.Lists;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.configuration.AuthorizationRequestCustomParameter;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.model.security.Identity;
import io.jans.util.Pair;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class RequestParameterService {
    private static final List<String> ALLOWED_PARAMETER = Collections.unmodifiableList(Arrays.asList("scope", "response_type", "client_id", "redirect_uri", "state", "response_mode", "nonce", "display", "prompt", "max_age", "ui_locales", "id_token_hint", "authorization_details", "login_hint", "acr_values", "request", "request_uri", "origin_headers", "code_challenge", "code_challenge_method", "dpop_jkt", "custom_response_headers", "claims", "auth_req_id", "sid", "logout_status_jwt", "user_code"));
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private AppConfiguration appConfiguration;

    private List<String> getAllAllowedParameters() {
        ArrayList allowedParameters = Lists.newArrayList(ALLOWED_PARAMETER);
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdRequestParameterEnabled())) {
            allowedParameters.add("session_id");
        }
        return allowedParameters;
    }

    public Map<String, String> getAllowedParameters(@Nonnull Map<String, String> requestParameterMap) {
        HashSet authorizationRequestCustomAllowedParameters = this.appConfiguration.getAuthorizationRequestCustomAllowedParameters();
        if (authorizationRequestCustomAllowedParameters == null) {
            authorizationRequestCustomAllowedParameters = new HashSet(0);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (requestParameterMap.isEmpty()) {
            return result;
        }
        List<String> allAllowed = this.getAllAllowedParameters();
        Set<Map.Entry<String, String>> set = requestParameterMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!allAllowed.contains(entry.getKey()) && !authorizationRequestCustomAllowedParameters.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getParamName()) && o.getParamName().equals(entry.getKey())).findFirst().isPresent()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, String> getCustomParameters(@Nonnull Map<String, String> requestParameterMap) {
        return this.getCustomParameters(requestParameterMap, false);
    }

    public Map<String, String> getCustomParameters(@Nonnull Map<String, String> requestParameterMap, boolean onlyReturnInResponseParams) {
        Set authorizationRequestCustomAllowedParameters = this.appConfiguration.getAuthorizationRequestCustomAllowedParameters();
        HashMap<String, String> result = new HashMap<String, String>();
        if (authorizationRequestCustomAllowedParameters == null) {
            return result;
        }
        if (!requestParameterMap.isEmpty()) {
            Set<Map.Entry<String, String>> set = requestParameterMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (onlyReturnInResponseParams && authorizationRequestCustomAllowedParameters.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getParamName()) && o.getParamName().equals(entry.getKey()) && o.getReturnInResponse() != false).findFirst().isPresent()) {
                    result.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (onlyReturnInResponseParams || !authorizationRequestCustomAllowedParameters.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getParamName()) && o.getParamName().equals(entry.getKey())).findFirst().isPresent()) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String parametersAsString(Map<String, String> parameterMap) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> set = parameterMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Map<String, String> getParametersMap(List<String> extraParameters, Map<String, String> parameterMap) {
        List<String> allowedParameters = this.getAllAllowedParameters();
        if (extraParameters != null) {
            for (String extraParameter : extraParameters) {
                this.putInMap(parameterMap, extraParameter);
            }
            allowedParameters.addAll(extraParameters);
        }
        parameterMap.entrySet().removeIf(entry -> !allowedParameters.contains(entry.getKey()));
        return parameterMap;
    }

    private void putInMap(Map<String, String> map, String name) {
        if (map == null) {
            return;
        }
        String value = this.getParameterValue(name);
        map.put(name, value);
    }

    public String getParameterValue(String name) {
        Pair<String, String> valueWithType = this.getParameterValueWithType(name);
        if (valueWithType == null) {
            return null;
        }
        return (String)valueWithType.getFirst();
    }

    public Pair<String, String> getParameterValueWithType(String name) {
        String value = null;
        String clazz = null;
        Object o = this.identity.getWorkingParameter(name);
        if (o instanceof String) {
            value = (String)o;
            clazz = String.class.getName();
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            value = i.toString();
            clazz = Integer.class.getName();
        } else if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            value = b.toString();
            clazz = Boolean.class.getName();
        }
        return new Pair((Object)value, (Object)clazz);
    }

    public Object getTypedValue(String stringValue, String type) {
        if (StringHelper.equals((String)Boolean.class.getName(), (String)type)) {
            return Boolean.valueOf(stringValue);
        }
        if (StringHelper.equals((String)Integer.class.getName(), (String)type)) {
            return Integer.valueOf(stringValue);
        }
        return stringValue;
    }

    public void getCustomParameters(JwtAuthorizationRequest jwtRequest, Map<String, String> customParameters) {
        Set authorizationRequestCustomAllowedParameters = this.appConfiguration.getAuthorizationRequestCustomAllowedParameters();
        if (authorizationRequestCustomAllowedParameters == null) {
            return;
        }
        JSONObject jsonPayload = jwtRequest.getJsonPayload();
        for (AuthorizationRequestCustomParameter customParam : authorizationRequestCustomAllowedParameters) {
            if (!jsonPayload.has(customParam.getParamName())) continue;
            customParameters.put(customParam.getParamName(), jsonPayload.getString(customParam.getParamName()));
        }
    }

    public Map<String, String> getCustomParameters(HttpServletRequest request) {
        HashMap<String, String> customParameters = new HashMap<String, String>();
        this.addCustomParameters(request, customParameters);
        return customParameters;
    }

    public void addCustomParameters(HttpServletRequest request, Map<String, String> customParameters) {
        Set authorizationRequestCustomAllowedParameters = this.appConfiguration.getAuthorizationRequestCustomAllowedParameters();
        if (authorizationRequestCustomAllowedParameters == null) {
            this.log.trace("Skipped custom parameters because 'authorizationRequestCustomAllowedParameters' AS configuration is not set.");
            return;
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!authorizationRequestCustomAllowedParameters.stream().map(AuthorizationRequestCustomParameter::getParamName).collect(Collectors.toList()).contains(parameterName)) {
                this.log.trace("Skipped '{}' as custom parameter (not defined in 'authorizationRequestCustomAllowedParameters')", (Object)parameterName);
                continue;
            }
            String parameterValue = request.getParameter(parameterName);
            if (!StringUtils.isNotBlank((CharSequence)parameterValue)) continue;
            customParameters.put(parameterName, parameterValue);
        }
        this.log.trace("Custom parameters: {}", customParameters);
    }

    public void putCustomParametersIntoSession(SessionId sessionId, HttpServletRequest httpRequest) {
        this.putCustomParametersIntoSession(sessionId, this.getCustomParameters(httpRequest));
    }

    public void putCustomParametersIntoSession(SessionId sessionId, Map<String, String> customParameters) {
        if (sessionId == null || customParameters == null) {
            return;
        }
        this.putCustomParametersIntoSession(sessionId.getSessionAttributes(), customParameters);
    }

    public void putCustomParametersIntoSession(Map<String, String> sessionAttributes, Map<String, String> customParameters) {
        if (sessionAttributes == null || customParameters == null) {
            return;
        }
        for (Map.Entry<String, String> entry : customParameters.entrySet()) {
            sessionAttributes.put("custom_" + entry.getKey(), entry.getValue());
        }
    }
}

