/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.collect.Lists;
import io.jans.as.common.model.common.User;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.exception.InvalidClaimException;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.persistence.model.Scope;
import io.jans.model.JansAttribute;
import io.jans.model.attribute.AttributeDataType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.BaseCacheService;
import io.jans.service.CacheService;
import io.jans.service.LocalCacheService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.slf4j.Logger;

@ApplicationScoped
public class ScopeService {
    private static final String CACHE_PREFIX = "scope_";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AttributeService attributeService;
    @Inject
    private PersistenceEntryManager entryManager;

    public List<Scope> getAllScopesList() {
        String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
        return this.entryManager.findEntries(scopesBaseDN, Scope.class, Filter.createPresenceFilter((String)"inum"));
    }

    public List<String> getDefaultScopesDn() {
        ArrayList<String> defaultScopes = new ArrayList<String>();
        for (Scope scope : this.getAllScopesList()) {
            if (!Boolean.TRUE.equals(scope.isDefaultScope())) continue;
            defaultScopes.add(scope.getDn());
        }
        return defaultScopes;
    }

    public List<String> getScopesDn(List<String> scopeNames) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scopeName : scopeNames) {
            Scope scope = this.getScopeById(scopeName);
            if (scope == null) continue;
            scopes.add(scope.getDn());
        }
        return scopes;
    }

    public List<String> getScopeIdsByDns(List<String> dns) {
        ArrayList names = Lists.newArrayList();
        if (dns == null || dns.isEmpty()) {
            return dns;
        }
        for (String dn : dns) {
            Scope scope = this.getScopeByDnSilently(dn);
            if (scope == null || !StringUtils.isNotBlank((CharSequence)scope.getId())) continue;
            names.add(scope.getId());
        }
        return names;
    }

    public Scope getScopeByDn(String dn) {
        BaseCacheService usedCacheService = this.getCacheService();
        Scope scope = (Scope)usedCacheService.getWithPut(dn, () -> (Scope)this.entryManager.find(Scope.class, (Object)dn), 60);
        if (scope != null && StringUtils.isNotBlank((CharSequence)scope.getId())) {
            usedCacheService.put(CACHE_PREFIX + scope.getId(), (Object)scope);
        }
        return scope;
    }

    public Scope getScopeByDnSilently(String dn) {
        try {
            return this.getScopeByDn(dn);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Scope getScopeById(String id) {
        BaseCacheService usedCacheService = this.getCacheService();
        Object cached = usedCacheService.get(CACHE_PREFIX + id);
        if (cached != null) {
            return (Scope)cached;
        }
        try {
            List scopes = this.entryManager.findEntries(this.staticConfiguration.getBaseDn().getScopes(), Scope.class, Filter.createEqualityFilter((String)"jansId", (Object)id));
            if (scopes != null && scopes.size() > 0) {
                Scope scope = (Scope)scopes.get(0);
                usedCacheService.put(CACHE_PREFIX + id, (Object)scope);
                usedCacheService.put(scope.getDn(), (Object)scope);
                return scope;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find scope with id: " + id, (Throwable)e);
        }
        return null;
    }

    public List<Scope> getScopeByClaim(String claimDn) {
        List scopes = this.fromCacheByClaimDn(claimDn);
        if (scopes == null) {
            Filter filter = Filter.createEqualityFilter((String)"jansClaim", (Object)claimDn);
            String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
            scopes = this.entryManager.findEntries(scopesBaseDN, Scope.class, filter);
            this.putInCache(claimDn, scopes);
        }
        return scopes;
    }

    public List<Scope> getScopesByClaim(List<Scope> scopes, String claimDn) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        for (Scope scope : scopes) {
            List claims = scope.getClaims();
            if (claims == null || !claims.contains(claimDn)) continue;
            result.add(scope);
        }
        return result;
    }

    private void putInCache(String claimDn, List<Scope> scopes) {
        if (scopes == null) {
            return;
        }
        BaseCacheService usedCacheService = this.getCacheService();
        try {
            String key = ScopeService.getClaimDnCacheKey(claimDn);
            usedCacheService.put(key, scopes);
        }
        catch (Exception ex) {
            this.log.error("Failed to put scopes in cache, claimDn: '{}'", (Object)claimDn, (Object)ex);
        }
    }

    private List<Scope> fromCacheByClaimDn(String claimDn) {
        BaseCacheService usedCacheService = this.getCacheService();
        try {
            String key = ScopeService.getClaimDnCacheKey(claimDn);
            return (List)usedCacheService.get(key);
        }
        catch (Exception ex) {
            this.log.error("Failed to get scopes from cache, claimDn: '{}'", (Object)claimDn, (Object)ex);
            return null;
        }
    }

    private static String getClaimDnCacheKey(String claimDn) {
        return "cdn_" + StringHelper.toLowerCase((String)claimDn);
    }

    public void persist(Scope scope) {
        this.entryManager.persist((Object)scope);
    }

    private BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }

    public Map<String, Object> getClaims(User user, Scope scope) throws InvalidClaimException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (scope == null) {
            this.log.trace("Scope is null.");
            return claims;
        }
        List scopeClaims = scope.getClaims();
        if (scopeClaims == null) {
            this.log.trace("No claims set for scope: {}", (Object)scope.getId());
            return claims;
        }
        this.fillClaims(claims, scopeClaims, user);
        return claims;
    }

    private void fillClaims(Map<String, Object> claims, List<String> scopeClaims, User user) throws InvalidClaimException {
        for (String claimDn : scopeClaims) {
            JansAttribute jansAttribute = this.attributeService.getAttributeByDn(claimDn);
            String claimName = jansAttribute.getClaimName();
            String ldapName = jansAttribute.getName();
            if (StringUtils.isBlank((CharSequence)claimName)) {
                this.log.error("Failed to get claim because claim name is not set for attribute, id: {}", (Object)jansAttribute.getDn());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)ldapName)) {
                this.log.error("Failed to get claim because name is not set for attribute, id: {}", (Object)jansAttribute.getDn());
                continue;
            }
            this.setClaimField(ldapName, claimName, user, jansAttribute, claims);
        }
    }

    private void setClaimField(String ldapName, String claimName, User user, JansAttribute jansAttribute, Map<String, Object> claims) throws InvalidClaimException {
        Object attribute = null;
        if (ldapName.equals("uid")) {
            attribute = user.getUserId();
        } else if (ldapName.equals("updatedAt")) {
            attribute = user.getUpdatedAt();
        } else if (ldapName.equals("createdAt")) {
            attribute = user.getCreatedAt();
        } else if (AttributeDataType.BOOLEAN.equals((Object)jansAttribute.getDataType())) {
            Object value = user.getAttribute(jansAttribute.getName(), true, jansAttribute.getOxMultiValuedAttribute().booleanValue());
            attribute = value instanceof String ? Boolean.valueOf(Boolean.parseBoolean(String.valueOf(value))) : value;
        } else if (AttributeDataType.DATE.equals((Object)jansAttribute.getDataType())) {
            Object value = user.getAttribute(jansAttribute.getName(), true, jansAttribute.getOxMultiValuedAttribute().booleanValue());
            if (value instanceof Date) {
                attribute = value;
            } else if (value != null) {
                attribute = this.entryManager.decodeTime(user.getDn(), value.toString());
            }
        } else {
            attribute = user.getAttribute(jansAttribute.getName(), true, jansAttribute.getOxMultiValuedAttribute().booleanValue());
        }
        if (attribute != null) {
            claims.put(claimName, attribute instanceof JSONArray ? JsonApplier.getStringList((JSONArray)((JSONArray)attribute)) : attribute);
        }
    }
}

