/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.unboundid.ldap.sdk.LDAPException;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.model.util.Pair;
import io.jans.as.model.util.Util;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.exception.AcrChangedException;
import io.jans.as.server.model.exception.InvalidSessionStateException;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.AcrService;
import io.jans.as.server.service.AttributeService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.exception.FailedComputeSessionStateException;
import io.jans.as.server.service.external.ExternalApplicationSessionService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.session.SessionEvent;
import io.jans.as.server.service.external.session.SessionEventType;
import io.jans.as.server.service.stat.StatService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.JansAttribute;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.search.filter.Filter;
import io.jans.service.CacheService;
import io.jans.service.LocalCacheService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.slf4j.Logger;

@RequestScoped
@Named
public class SessionIdService {
    private static final int MAX_MERGE_ATTEMPTS = 3;
    private static final int DEFAULT_LOCAL_CACHE_EXPIRATION = 2;
    @Inject
    private Logger log;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private UserService userService;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private CookieService cookieService;
    @Inject
    private Identity identity;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private CacheService cacheService;
    @Inject
    private StatService statService;
    @Inject
    private AttributeService attributeService;

    private String buildDn(String sessionId) {
        return String.format("jansId=%s,%s", sessionId, this.staticConfiguration.getBaseDn().getSessions());
    }

    public Set<SessionId> getCurrentSessions() {
        Set<String> ids = this.cookieService.getCurrentSessions();
        this.log.trace("current_sessions: {}", ids);
        HashSet sessions = Sets.newHashSet();
        for (String sessionId : ids) {
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                this.log.error("Invalid sessionId in current_sessions: {}", (Object)sessionId);
                continue;
            }
            SessionId sessionIdObj = this.getSessionId(sessionId);
            if (sessionIdObj == null) {
                this.log.trace("Unable to find session object by id: {} (expired?)", (Object)sessionId);
                continue;
            }
            if (sessionIdObj.getState() != SessionIdState.AUTHENTICATED) {
                this.log.error("Session is not authenticated, id: {}", (Object)sessionId);
                continue;
            }
            sessions.add(sessionIdObj);
        }
        return sessions;
    }

    public String getAcr(SessionId session) {
        if (session == null) {
            return null;
        }
        String acr = (String)session.getSessionAttributes().get("acr");
        if (StringUtils.isBlank((CharSequence)acr)) {
            acr = (String)session.getSessionAttributes().get("acr_values");
        }
        return acr;
    }

    public static boolean isAgamaInSessionAndRequest(String sessionAcr, List<String> acrValuesList) {
        return AcrService.isAgama(sessionAcr) && !acrValuesList.isEmpty() && AcrService.isAgama(acrValuesList.iterator().next());
    }

    public SessionId assertAuthenticatedSessionCorrespondsToNewRequest(SessionId session, String acrValuesStr) throws AcrChangedException {
        if (session != null && !session.getSessionAttributes().isEmpty() && session.getState() == SessionIdState.AUTHENTICATED) {
            List<String> acrValuesList;
            boolean isAcrChanged;
            Map sessionAttributes = session.getSessionAttributes();
            String sessionAcr = this.getAcr(session);
            if (StringUtils.isBlank((CharSequence)sessionAcr)) {
                boolean isDeviceAuthorization = sessionAttributes.containsKey("device_authorization");
                this.log.trace("Failed to fetch acr from session, attributes: {}", (Object)sessionAttributes);
                if (!isDeviceAuthorization) {
                    return session;
                }
            }
            boolean bl = isAcrChanged = !(acrValuesList = this.acrValuesList(acrValuesStr)).isEmpty() && !acrValuesList.contains(sessionAcr) && !SessionIdService.isAgamaInSessionAndRequest(sessionAcr, acrValuesList);
            if (isAcrChanged) {
                Map<String, Integer> acrToLevel = this.externalAuthenticationService.acrToLevelMapping();
                Integer sessionAcrLevel = Util.asInt((Integer)acrToLevel.get(this.externalAuthenticationService.scriptName(sessionAcr)), (int)-1);
                this.log.trace("acrChanged, acrToLevel: {}, sessionAcrLevel: {}", acrToLevel, (Object)sessionAcrLevel);
                for (String acrValue : acrValuesList) {
                    Integer currentAcrLevel = acrToLevel.get(this.externalAuthenticationService.scriptName(acrValue));
                    this.log.info("Acr is changed. Session acr: {} (level: {}), current acr: {} (level: {})", new Object[]{sessionAcr, sessionAcrLevel, acrValue, currentAcrLevel});
                    if (currentAcrLevel == null) {
                        if (Util.isBuiltInPasswordAuthn((String)acrValue)) {
                            return session;
                        }
                        throw new AcrChangedException(false);
                    }
                    if (sessionAcrLevel >= currentAcrLevel) continue;
                    throw new AcrChangedException();
                }
                return session;
            }
            this.reinitLogin(session, false);
        }
        return session;
    }

    private static boolean shouldReinitSession(Map<String, String> sessionAttributes, Map<String, String> currentSessionAttributes) {
        HashMap<String, String> copySessionAttributes = new HashMap<String, String>(sessionAttributes);
        HashMap<String, String> copyCurrentSessionAttributes = new HashMap<String, String>(currentSessionAttributes);
        copySessionAttributes.remove("state");
        copyCurrentSessionAttributes.remove("state");
        return !copyCurrentSessionAttributes.equals(copySessionAttributes);
    }

    public boolean reinitLogin(SessionId session, boolean force) {
        Map sessionAttributes = session.getSessionAttributes();
        Map<String, String> currentSessionAttributes = this.getCurrentSessionAttributes(sessionAttributes);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sessionAttributes: {}", (Object)sessionAttributes);
            this.log.trace("currentSessionAttributes: {}", currentSessionAttributes);
            this.log.trace("shouldReinitSession: {}, force: {}", (Object)SessionIdService.shouldReinitSession(sessionAttributes, currentSessionAttributes), (Object)force);
        }
        if (force || SessionIdService.shouldReinitSession(sessionAttributes, currentSessionAttributes)) {
            boolean updateResult;
            sessionAttributes.putAll(currentSessionAttributes);
            sessionAttributes.put("c", "1");
            Iterator<Map.Entry<String, String>> it = currentSessionAttributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> currentSessionAttributesEntry = it.next();
                String name = currentSessionAttributesEntry.getKey();
                if (!name.startsWith("auth_step_passed_")) continue;
                it.remove();
            }
            session.setSessionAttributes(currentSessionAttributes);
            if (force) {
                session.setState(SessionIdState.UNAUTHENTICATED);
                this.externalEvent(new SessionEvent(SessionEventType.UNAUTHENTICATED, session));
            }
            if (!(updateResult = this.updateSessionId(session, true, true, true))) {
                this.log.debug("Failed to update session entry: '{}'", (Object)session.getId());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sessionAttributes after update: {}, ", (Object)session.getSessionAttributes());
            }
            return updateResult;
        }
        return false;
    }

    public SessionId resetToStep(SessionId session, int resetToStep) {
        int i;
        Map sessionAttributes = session.getSessionAttributes();
        int currentStep = 1;
        if (sessionAttributes.containsKey("auth_step")) {
            currentStep = StringHelper.toInteger((String)((String)sessionAttributes.get("auth_step")), (int)currentStep);
        }
        if (resetToStep <= currentStep) {
            for (i = resetToStep; i <= currentStep; ++i) {
                String key = String.format("auth_step_passed_%d", i);
                sessionAttributes.remove(key);
            }
        } else {
            for (i = currentStep + 1; i < resetToStep; ++i) {
                sessionAttributes.put(String.format("auth_step_passed_%d", i), Boolean.TRUE.toString());
            }
        }
        sessionAttributes.put("auth_step", String.valueOf(resetToStep));
        boolean updateResult = this.updateSessionId(session, true, true, true);
        if (!updateResult) {
            this.log.debug("Failed to update session entry: '{}'", (Object)session.getId());
            return null;
        }
        return session;
    }

    private Map<String, String> getCurrentSessionAttributes(Map<String, String> sessionAttributes) {
        if (this.facesContext == null) {
            return sessionAttributes;
        }
        HashMap<String, String> currentSessionAttributes = new HashMap<String, String>(sessionAttributes);
        Map requestParameters = this.externalContext.getRequestParameterMap();
        Map<String, String> newRequestParameterMap = this.requestParameterService.getAllowedParameters(requestParameters);
        for (Map.Entry<String, String> newRequestParameterMapEntry : newRequestParameterMap.entrySet()) {
            String name = newRequestParameterMapEntry.getKey();
            if (StringHelper.equalsIgnoreCase((String)name, (String)"auth_step")) continue;
            currentSessionAttributes.put(name, newRequestParameterMapEntry.getValue());
        }
        if (!requestParameters.containsKey("code_challenge") || !requestParameters.containsKey("code_challenge_method")) {
            currentSessionAttributes.remove("code_challenge");
            currentSessionAttributes.remove("code_challenge_method");
        }
        return currentSessionAttributes;
    }

    public SessionId getSessionId() {
        String sessionId = this.cookieService.getSessionIdFromCookie();
        if (StringHelper.isEmpty((String)sessionId) && this.identity.getSessionId() != null) {
            sessionId = this.identity.getSessionId().getId();
        }
        SessionId result = null;
        if (StringHelper.isNotEmpty((String)sessionId)) {
            result = this.getSessionId(sessionId);
            if (result == null && this.identity.getSessionId() != null) {
                sessionId = this.identity.getSessionId().getId();
                result = this.getSessionId(sessionId);
            }
        } else {
            this.log.trace("Session cookie not exists");
        }
        return result;
    }

    public Map<String, String> getSessionAttributes(SessionId sessionId) {
        if (sessionId != null) {
            return sessionId.getSessionAttributes();
        }
        return null;
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn) throws InvalidSessionStateException {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", "");
        return this.generateAuthenticatedSessionId(httpRequest, userDn, sessionIdAttributes);
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn, String prompt) throws InvalidSessionStateException {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", prompt);
        return this.generateAuthenticatedSessionId(httpRequest, userDn, sessionIdAttributes);
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn, Map<String, String> sessionIdAttributes) throws InvalidSessionStateException {
        User user = this.userService.getUserByDnSilently(userDn, new String[0]);
        this.updateAttributesWithUserClaims(sessionIdAttributes, user);
        SessionId sessionId = this.generateSessionId(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
        if (sessionId == null) {
            throw new InvalidSessionStateException("Failed to generate authenticated session.");
        }
        this.reportActiveUser(user);
        if (this.externalApplicationSessionService.isEnabled()) {
            String userName = (String)sessionId.getSessionAttributes().get("auth_user");
            boolean externalResult = this.externalApplicationSessionService.executeExternalStartSessionMethods(httpRequest, sessionId);
            this.log.info("Start session result for '{}': '{}'", (Object)userName, (Object)externalResult);
            if (!externalResult) {
                this.reinitLogin(sessionId, true);
                throw new InvalidSessionStateException("Session creation is prohibited by external session script!");
            }
            this.externalEvent(new SessionEvent(SessionEventType.AUTHENTICATED, sessionId).setHttpRequest(httpRequest));
        }
        return sessionId;
    }

    private void reportActiveUser(User user) {
        try {
            if (user != null) {
                this.statService.reportActiveUser(user.getUserId());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public SessionId generateUnauthenticatedSessionId(String userDn) {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        return this.generateSessionId(userDn, new Date(), SessionIdState.UNAUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionId generateUnauthenticatedSessionId(String userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        return this.generateSessionId(userDn, authenticationDate, state, sessionIdAttributes, persist);
    }

    public String computeSessionState(SessionId sessionId, String clientId, String redirectUri) {
        boolean isSameClient;
        boolean bl = isSameClient = clientId.equals(sessionId.getSessionAttributes().get("client_id")) && redirectUri.equals(sessionId.getSessionAttributes().get("redirect_uri"));
        if (isSameClient) {
            return sessionId.getSessionState();
        }
        String salt = UUID.randomUUID().toString();
        String opbs = sessionId.getOPBrowserState();
        return this.computeSessionState(clientId, redirectUri, opbs, salt);
    }

    private String computeSessionState(String clientId, String redirectUri, String opbs, String salt) {
        try {
            String clientOrigin = this.getClientOrigin(redirectUri);
            return JwtUtil.bytesToHex((byte[])JwtUtil.getMessageDigestSHA256((String)(clientId + " " + clientOrigin + " " + opbs + " " + salt))) + "." + salt;
        }
        catch (URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed generating session state! " + e.getMessage(), (Throwable)e);
            }
            throw new FailedComputeSessionStateException(e.getMessage(), e);
        }
    }

    private String getClientOrigin(String redirectUri) throws URISyntaxException {
        if (StringHelper.isNotEmpty((String)redirectUri)) {
            URI uri = new URI(redirectUri);
            String result = uri.getScheme() + "://" + uri.getHost();
            if (uri.getPort() > 0) {
                result = result + ":" + uri.getPort();
            }
            return result;
        }
        return this.appConfiguration.getIssuer();
    }

    private SessionId generateSessionId(String userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        String internalSid = UUID.randomUUID().toString();
        String outsideSid = UUID.randomUUID().toString();
        String salt = UUID.randomUUID().toString();
        String clientId = sessionIdAttributes.get("client_id");
        String opbs = UUID.randomUUID().toString();
        String redirectUri = sessionIdAttributes.get("redirect_uri");
        String sessionState = this.computeSessionState(clientId, redirectUri, opbs, salt);
        String dn = this.buildDn(internalSid);
        sessionIdAttributes.put("opbs", opbs);
        Preconditions.checkNotNull((Object)dn);
        if (SessionIdState.AUTHENTICATED == state && StringUtils.isBlank((CharSequence)userDn) && !sessionIdAttributes.containsKey("uma")) {
            return null;
        }
        SessionId sessionId = new SessionId();
        sessionId.setId(internalSid);
        sessionId.setOutsideSid(outsideSid);
        sessionId.setDn(dn);
        sessionId.setUserDn(userDn);
        sessionId.setSessionState(sessionState);
        Pair<Date, Integer> expiration = this.expirationDate(sessionId.getCreationDate(), state);
        sessionId.setExpirationDate((Date)expiration.getFirst());
        sessionId.setTtl(((Integer)expiration.getSecond()).intValue());
        sessionId.setAuthenticationTime(authenticationDate != null ? authenticationDate : new Date());
        if (state != null) {
            sessionId.setState(state);
        }
        sessionId.setSessionAttributes(sessionIdAttributes);
        sessionId.setLastUsedAt(new Date());
        boolean persisted = false;
        if (persist) {
            persisted = this.persistSessionId(sessionId);
        }
        this.auditLogging(sessionId);
        this.log.trace("Generated new session, id = '{}', state = '{}', persisted = '{}'", new Object[]{sessionId.getId(), sessionId.getState(), persisted});
        return sessionId;
    }

    public SessionId setSessionIdStateAuthenticated(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SessionId sessionId, String userDn) {
        boolean persisted;
        sessionId.setUserDn(userDn);
        sessionId.setAuthenticationTime(new Date());
        sessionId.setState(SessionIdState.AUTHENTICATED);
        User user = this.getUser(sessionId);
        if (user != null) {
            this.statService.reportActiveUser(user.getUserId());
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getChangeSessionIdOnAuthentication()) && httpResponse != null) {
            String oldSessionId = sessionId.getId();
            String newSessionId = UUID.randomUUID().toString();
            this.log.debug("Changing session id from {} to {} ...", (Object)oldSessionId, (Object)newSessionId);
            this.remove(sessionId);
            sessionId.setId(newSessionId);
            sessionId.setDn(this.buildDn(newSessionId));
            sessionId.getSessionAttributes().put("old_session_id", oldSessionId);
            persisted = this.persistSessionId(sessionId, true);
            this.cookieService.createSessionIdCookie(sessionId, httpRequest, httpResponse, false);
            this.log.debug("Session identifier changed from {} to {} .", (Object)oldSessionId, (Object)newSessionId);
        } else {
            persisted = this.updateSessionId(sessionId, true, true, true);
        }
        this.auditLogging(sessionId);
        this.log.trace("Authenticated session, id = '{}', state = '{}', persisted = '{}'", new Object[]{sessionId.getId(), sessionId.getState(), persisted});
        if (this.externalApplicationSessionService.isEnabled()) {
            String userName = (String)sessionId.getSessionAttributes().get("auth_user");
            boolean externalResult = this.externalApplicationSessionService.executeExternalStartSessionMethods(httpRequest, sessionId);
            this.log.info("Start session result for '{}': '{}'", (Object)userName, (Object)externalResult);
            if (!externalResult) {
                this.reinitLogin(sessionId, true);
                throw new InvalidSessionStateException("Session creation is prohibited by external session script!");
            }
            this.externalEvent(new SessionEvent(SessionEventType.AUTHENTICATED, sessionId).setHttpRequest(httpRequest).setHttpResponse(httpResponse));
        }
        return sessionId;
    }

    public boolean persistSessionId(SessionId sessionId) {
        return this.persistSessionId(sessionId, false);
    }

    public boolean persistSessionId(SessionId sessionId, boolean forcePersistence) {
        return this.persistSessionId(sessionId, forcePersistence, false);
    }

    public boolean persistSessionId(SessionId sessionId, boolean forcePersistence, boolean silent) {
        block5: {
            List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
            try {
                int unusedLifetime = this.appConfiguration.getSessionIdUnusedLifetime();
                if (unusedLifetime > 0 && this.isPersisted(prompts) || forcePersistence) {
                    sessionId.setLastUsedAt(new Date());
                    Pair<Date, Integer> expiration = this.expirationDate(sessionId.getCreationDate(), sessionId.getState());
                    sessionId.setPersisted(true);
                    sessionId.setExpirationDate((Date)expiration.getFirst());
                    sessionId.setTtl(((Integer)expiration.getSecond()).intValue());
                    this.log.trace("sessionIdAttributes: {}", (Object)sessionId.getPermissionGrantedMap());
                    if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdPersistInCache())) {
                        this.cacheService.put(((Integer)expiration.getSecond()).intValue(), sessionId.getDn(), (Object)sessionId);
                    } else {
                        this.persistenceEntryManager.persist((Object)sessionId);
                    }
                    this.localCacheService.put(2, sessionId.getDn(), (Object)sessionId);
                    return true;
                }
            }
            catch (Exception e) {
                if (silent) break block5;
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean updateSessionId(SessionId sessionId) {
        return this.updateSessionId(sessionId, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt) {
        return this.updateSessionId(sessionId, updateLastUsedAt, false, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt, boolean forceUpdate, boolean modified) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = this.appConfiguration.getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && this.isPersisted(prompts) || forceUpdate) {
                boolean update = modified;
                if (updateLastUsedAt) {
                    Date lastUsedAt = new Date();
                    if (sessionId.getLastUsedAt() != null) {
                        long diff = lastUsedAt.getTime() - sessionId.getLastUsedAt().getTime();
                        int unusedDiffInSeconds = (int)(diff / 1000L);
                        if (unusedDiffInSeconds > unusedLifetime) {
                            this.log.debug("Session id expired: {} by sessionIdUnusedLifetime, remove it.", (Object)sessionId.getId());
                            this.remove(sessionId);
                            return false;
                        }
                        if (diff > 500L) {
                            update = true;
                            sessionId.setLastUsedAt(lastUsedAt);
                        }
                    } else {
                        update = true;
                        sessionId.setLastUsedAt(lastUsedAt);
                    }
                }
                if (!sessionId.isPersisted()) {
                    update = true;
                    sessionId.setPersisted(true);
                }
                if (this.isExpired(sessionId)) {
                    this.log.debug("Session id expired: {} by lifetime property, remove it.", (Object)sessionId.getId());
                    this.remove(sessionId);
                    update = false;
                }
                if (update) {
                    this.mergeWithRetry(sessionId);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isExpired(SessionId sessionId) {
        if (sessionId.getAuthenticationTime() == null) {
            return false;
        }
        long currentLifetimeInSeconds = (System.currentTimeMillis() - sessionId.getAuthenticationTime().getTime()) / 1000L;
        return currentLifetimeInSeconds > (long)this.getServerSessionIdLifetimeInSeconds();
    }

    public int getServerSessionIdLifetimeInSeconds() {
        if (this.appConfiguration.getSessionIdLifetime() != null) {
            if (this.appConfiguration.getSessionIdLifetime() > 0) {
                return this.appConfiguration.getSessionIdLifetime();
            }
            return Integer.MAX_VALUE;
        }
        if (this.appConfiguration.getSessionIdCookieLifetime() != null && this.appConfiguration.getSessionIdCookieLifetime() > 0) {
            return this.appConfiguration.getSessionIdCookieLifetime();
        }
        this.log.debug("Session id lifetime configuration is null. (Both 'sessionIdLifetime' and 'sessionIdCookieLifetime' are null. Fallback to 86400 value.");
        return 86400;
    }

    private Pair<Date, Integer> expirationDate(Date creationDate, SessionIdState state) {
        int expirationInSeconds = state == SessionIdState.UNAUTHENTICATED ? this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime() : this.getServerSessionIdLifetimeInSeconds();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(creationDate);
        calendar.add(13, expirationInSeconds);
        return new Pair((Object)calendar.getTime(), (Object)expirationInSeconds);
    }

    private void mergeWithRetry(SessionId sessionId) {
        Pair<Date, Integer> expiration = this.expirationDate(sessionId.getCreationDate(), sessionId.getState());
        sessionId.setExpirationDate((Date)expiration.getFirst());
        sessionId.setTtl(((Integer)expiration.getSecond()).intValue());
        EntryPersistenceException lastException = null;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdPersistInCache())) {
                    this.cacheService.put(((Integer)expiration.getSecond()).intValue(), sessionId.getDn(), (Object)sessionId);
                } else {
                    this.persistenceEntryManager.merge((Object)sessionId);
                }
                this.localCacheService.put(2, sessionId.getDn(), (Object)sessionId);
                this.externalEvent(new SessionEvent(SessionEventType.UPDATED, sessionId));
                return;
            }
            catch (EntryPersistenceException ex) {
                block9: {
                    block8: {
                        lastException = ex;
                        if (!(ex.getCause() instanceof LDAPException)) break block8;
                        LDAPException parentEx = (LDAPException)ex.getCause();
                        this.log.debug("LDAP exception resultCode: '{}'", (Object)parentEx.getResultCode().intValue());
                        if (parentEx.getResultCode().intValue() == 16 || parentEx.getResultCode().intValue() == 20) break block9;
                    }
                    throw ex;
                }
                this.log.warn("Session entry update attempt '{}' was unsuccessfull", (Object)i);
                continue;
            }
        }
        this.log.error("Session entry update attempt was unsuccessfull after '{}' attempts", (Object)3);
        throw lastException;
    }

    public void updateSessionIdIfNeeded(SessionId sessionId, boolean modified) {
        this.updateSessionId(sessionId, true, false, modified);
    }

    private boolean isPersisted(List<Prompt> prompts) {
        if (prompts != null && prompts.contains(Prompt.NONE)) {
            Boolean persistOnPromptNone = this.appConfiguration.getSessionIdPersistOnPromptNone();
            return persistOnPromptNone != null && persistOnPromptNone != false;
        }
        return true;
    }

    @Nullable
    public SessionId getSessionById(@Nullable String sessionId, boolean silently) {
        return this.getSessionByDn(this.buildDn(sessionId), silently);
    }

    @Nullable
    public SessionId getSessionByDn(@Nullable String dn) {
        return this.getSessionByDn(dn, false);
    }

    @Nullable
    public SessionId getSessionBySid(@Nullable String sid) {
        if (StringUtils.isBlank((CharSequence)sid)) {
            return null;
        }
        List entries = this.persistenceEntryManager.findEntries(this.staticConfiguration.getBaseDn().getSessions(), SessionId.class, Filter.createEqualityFilter((String)"sid", (Object)sid));
        if (entries == null || entries.size() != 1) {
            return null;
        }
        return (SessionId)entries.get(0);
    }

    @Nullable
    public SessionId getSessionByDeviceSecret(@Nullable String deviceSecret) {
        if (StringUtils.isBlank((CharSequence)deviceSecret)) {
            return null;
        }
        List entries = this.persistenceEntryManager.findEntries(this.staticConfiguration.getBaseDn().getSessions(), SessionId.class, Filter.createEqualityFilter((String)"deviceSecret", (Object)deviceSecret));
        if (entries == null || entries.size() != 1) {
            return null;
        }
        return (SessionId)entries.get(0);
    }

    @Nullable
    public SessionId getSessionByDn(@Nullable String dn, boolean silently) {
        if (StringUtils.isBlank((CharSequence)dn)) {
            return null;
        }
        Object localCopy = this.localCacheService.get(dn);
        if (localCopy instanceof SessionId) {
            if (this.isSessionValid((SessionId)localCopy)) {
                return (SessionId)localCopy;
            }
            this.localCacheService.remove(dn);
        }
        try {
            SessionId sessionId = BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdPersistInCache()) ? (SessionId)this.cacheService.get(dn) : (SessionId)this.persistenceEntryManager.find(SessionId.class, (Object)dn);
            this.localCacheService.put(2, sessionId.getDn(), (Object)sessionId);
            return sessionId;
        }
        catch (Exception e) {
            if (!silently) {
                if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getLogNotFoundEntityAsError())) {
                    this.log.error("Failed to get session by dn: {}. {}", (Object)dn, (Object)e.getMessage());
                } else {
                    this.log.trace("Failed to get session by dn: {}. {}", (Object)dn, (Object)e.getMessage());
                }
            }
            return null;
        }
    }

    @Nullable
    public SessionId loadSessionById(@Nullable String sessionId) {
        return this.loadSessionByDn(this.buildDn(sessionId), false);
    }

    @Nullable
    public SessionId loadSessionById(@Nullable String sessionId, boolean silently) {
        return this.loadSessionByDn(this.buildDn(sessionId), silently);
    }

    @Nullable
    public SessionId loadSessionByDn(@Nullable String dn, boolean silently) {
        if (StringUtils.isBlank((CharSequence)dn)) {
            return null;
        }
        try {
            SessionId sessionId = BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdPersistInCache()) ? (SessionId)this.cacheService.get(dn) : (SessionId)this.persistenceEntryManager.find(SessionId.class, (Object)dn);
            return sessionId;
        }
        catch (Exception e) {
            if (!silently) {
                if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getLogNotFoundEntityAsError())) {
                    this.log.error("Failed to get session by dn: {}. {}", (Object)dn, (Object)e.getMessage());
                } else {
                    this.log.trace("Failed to get session by dn: {}. {}", (Object)dn, (Object)e.getMessage());
                }
            }
            return null;
        }
    }

    public SessionId getSessionId(HttpServletRequest request) {
        String sessionIdFromCookie = this.cookieService.getSessionIdFromCookie(request);
        this.log.trace("SessionId from cookie: {}", (Object)sessionIdFromCookie);
        return this.getSessionId(sessionIdFromCookie);
    }

    public SessionId getSessionId(String sessionId) {
        return this.getSessionId(sessionId, false);
    }

    public SessionId getSessionId(String sessionId, boolean silently) {
        block5: {
            if (StringHelper.isEmpty((String)sessionId)) {
                return null;
            }
            try {
                SessionId entity = this.getSessionById(sessionId, silently);
                this.log.trace("Try to get session by id: {} ...", (Object)sessionId);
                if (entity != null) {
                    this.log.trace("Session dn: {}", (Object)entity.getDn());
                    if (this.isSessionValid(entity)) {
                        return entity;
                    }
                }
            }
            catch (Exception ex) {
                if (silently) break block5;
                this.log.trace(ex.getMessage(), (Throwable)ex);
            }
        }
        this.log.trace("Failed to get session by id: {}", (Object)sessionId);
        return null;
    }

    public boolean remove(SessionId sessionId) {
        try {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdPersistInCache())) {
                this.cacheService.remove(sessionId.getDn());
            } else {
                this.persistenceEntryManager.remove(sessionId.getDn(), SessionId.class);
            }
            this.localCacheService.remove(sessionId.getDn());
            this.externalEvent(new SessionEvent(SessionEventType.GONE, sessionId));
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void remove(List<SessionId> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SessionId id : list) {
            try {
                this.remove(id);
            }
            catch (Exception e) {
                this.log.error("Failed to remove entry", (Throwable)e);
            }
        }
    }

    public boolean isSessionValid(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        long sessionInterval = TimeUnit.SECONDS.toMillis(this.appConfiguration.getSessionIdUnusedLifetime());
        long sessionUnauthenticatedInterval = TimeUnit.SECONDS.toMillis(this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime());
        long timeSinceLastAccess = System.currentTimeMillis() - sessionId.getLastUsedAt().getTime();
        if (timeSinceLastAccess > sessionInterval && this.appConfiguration.getSessionIdUnusedLifetime() != -1) {
            return false;
        }
        return sessionId.getState() != SessionIdState.UNAUTHENTICATED || timeSinceLastAccess <= sessionUnauthenticatedInterval || this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime() == -1;
    }

    private List<Prompt> getPromptsFromSessionId(SessionId sessionId) {
        String promptParam = (String)sessionId.getSessionAttributes().get("prompt");
        return Prompt.fromString((String)promptParam, (String)" ");
    }

    public boolean isSessionIdAuthenticated(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        return SessionIdState.AUTHENTICATED.equals((Object)sessionId.getState());
    }

    public List<String> acrValuesList(String acrValues) {
        List acrs;
        try {
            acrs = Util.jsonArrayStringAsList((String)acrValues);
        }
        catch (JSONException ex) {
            acrs = Util.splittedStringAsList((String)acrValues, (String)" ");
        }
        HashSet<String> resultAcrs = new HashSet<String>();
        for (String acr : acrs) {
            String scriptName = this.externalAuthenticationService.scriptName(acr);
            if (!StringUtils.isNotBlank((CharSequence)scriptName)) continue;
            resultAcrs.add(acr);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("acrValuesList {}", resultAcrs);
        }
        return new ArrayList<String>(resultAcrs);
    }

    private void auditLogging(SessionId sessionId) {
        HttpServletRequest httpServletRequest = ServerUtil.getRequestOrNull();
        if (httpServletRequest != null) {
            Action action;
            switch (sessionId.getState()) {
                case AUTHENTICATED: {
                    action = Action.SESSION_AUTHENTICATED;
                    break;
                }
                case UNAUTHENTICATED: {
                    action = Action.SESSION_UNAUTHENTICATED;
                    break;
                }
                default: {
                    action = Action.SESSION_UNAUTHENTICATED;
                }
            }
            OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpServletRequest), action);
            oAuth2AuditLog.setSuccess(true);
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        }
    }

    public User getUser(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        if (sessionId.getUser() != null) {
            return sessionId.getUser();
        }
        if (StringUtils.isBlank((CharSequence)sessionId.getUserDn())) {
            return null;
        }
        User user = this.userService.getUserByDn(sessionId.getUserDn(), new String[0]);
        if (user != null) {
            sessionId.setUser(user);
            return user;
        }
        return null;
    }

    public List<SessionId> findByUser(String userDn) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdPersistInCache())) {
            throw new UnsupportedOperationException("Operation is not supported with sessionIdPersistInCache=true. Set it to false to avoid this exception.");
        }
        Filter filter = Filter.createEqualityFilter((String)"jansUsrDN", (Object)userDn);
        return this.persistenceEntryManager.findEntries(this.staticConfiguration.getBaseDn().getSessions(), SessionId.class, filter);
    }

    public boolean hasAllScopes(SessionId sessionId, Set<String> scopes) {
        if (sessionId == null || sessionId.getSessionAttributes().isEmpty() || scopes == null || scopes.isEmpty()) {
            return false;
        }
        String scopesAsString = (String)sessionId.getSessionAttributes().get("scope");
        return SessionIdService.hasAllScopes(scopesAsString, scopes);
    }

    public boolean hasClientAllScopes(SessionId sessionId, String clientId, Set<String> scopes) {
        if (sessionId == null || sessionId.getSessionAttributes().isEmpty() || StringUtils.isBlank((CharSequence)clientId) || scopes == null || scopes.isEmpty()) {
            return false;
        }
        String key = clientId + "_authz_scopes";
        String clientScopes = (String)sessionId.getSessionAttributes().get(key);
        return SessionIdService.hasAllScopes(clientScopes, scopes);
    }

    public static boolean hasAllScopes(String existingScopes, Set<String> scopes) {
        if (StringUtils.isBlank((CharSequence)existingScopes)) {
            return false;
        }
        for (String scope : scopes) {
            if (existingScopes.contains(scope)) continue;
            return false;
        }
        return true;
    }

    public void externalEvent(SessionEvent event) {
        this.externalApplicationSessionService.externalEvent(event);
    }

    public void updateAttributesWithUserClaims(Map<String, String> sessionAttributes, User user) {
        List userClaims = this.appConfiguration.getSessionIdUserClaimsInAttributes();
        if (userClaims == null || userClaims.isEmpty() || user == null || sessionAttributes == null) {
            return;
        }
        for (String claim : userClaims) {
            try {
                String dbName;
                Object value;
                JansAttribute jansAttribute;
                if (sessionAttributes.containsKey(claim) || (jansAttribute = this.attributeService.getByClaimName(claim)) == null || (value = user.getAttribute(dbName = jansAttribute.getName(), true, jansAttribute.getOxMultiValuedAttribute().booleanValue())) == null) continue;
                sessionAttributes.put(claim, String.valueOf(value));
            }
            catch (Exception e) {
                this.log.error("Failed to get user's claim by name " + claim, (Throwable)e);
            }
        }
    }
}

