/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.orm.ldap.impl.LdapEntryManagerFactory;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.model.fido2.Fido2RegistrationEntry;
import io.jans.orm.search.filter.Filter;
import io.jans.service.net.NetworkService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;

@ApplicationScoped
public class UserService
extends io.jans.as.common.service.common.UserService {
    public static final String[] USER_OBJECT_CLASSES = new String[]{"jansPerson"};
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private NetworkService networkService;

    public List<String> getPersonCustomObjectClassList() {
        if (LdapEntryManagerFactory.PERSISTENCE_TYPE.equals(this.persistenceEntryManager.getPersistenceType(this.getPeopleBaseDn()))) {
            return this.appConfiguration.getPersonCustomObjectClassList();
        }
        return null;
    }

    public String getPeopleBaseDn() {
        return this.staticConfiguration.getBaseDn().getPeople();
    }

    public long countFido2RegisteredDevices(String username, String domain) {
        String userInum = this.getUserInum(username);
        if (userInum == null) {
            return 0L;
        }
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.persistenceEntryManager.contains(baseDn, SimpleBranch.class)) {
            return 0L;
        }
        Filter userInumFilter = Filter.createEqualityFilter((String)"personInum", (Object)userInum);
        Filter registeredFilter = Filter.createEqualityFilter((String)"jansStatus", (Object)"registered");
        Filter domainFilter = Filter.createEqualityFilter((String)"jansApp", (Object)domain);
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{userInumFilter, registeredFilter, domainFilter});
        return this.persistenceEntryManager.countEntries(baseDn, Fido2RegistrationEntry.class, filter);
    }

    public String getBaseDnForFido2RegistrationEntries(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        return String.format("ou=fido2_register,%s", userBaseDn);
    }

    public String getBaseDnForFidoDevices(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        return String.format("ou=fido,%s", userBaseDn);
    }
}

