/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.cluster;

import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.cluster.AbstractStatusIndexPoolService;
import io.jans.as.server.service.token.StatusListIndexService;
import io.jans.model.token.StatusIndexPool;
import io.jans.model.tokenstatus.TokenStatus;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;

@ApplicationScoped
public class StatusIndexPoolService
extends AbstractStatusIndexPoolService<StatusIndexPool> {
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    @Override
    public int getStatusListBitSize() {
        return this.appConfiguration.getStatusListBitSize();
    }

    @Override
    public Class<StatusIndexPool> getEntityClass() {
        return StatusIndexPool.class;
    }

    @Override
    public void markAllIndexesAsValid(List<Integer> enumerateAllIndexes) {
        StatusListIndexService indexService = (StatusListIndexService)CdiUtil.bean(StatusListIndexService.class);
        indexService.updateStatusAtIndexes(enumerateAllIndexes, TokenStatus.VALID);
    }

    @Override
    public String logPrefix() {
        return "[TokenIndex] - ";
    }

    @Override
    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getStatusIndexPool();
    }
}

