/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.session.SessionEvent;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.session.ApplicationSessionType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.json.JSONArray;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalApplicationSessionService
extends ExternalScriptService {
    private static final long serialVersionUID = 2316361273036208685L;

    public ExternalApplicationSessionService() {
        super(CustomScriptType.APPLICATION_SESSION);
    }

    public boolean executeExternalStartSessionMethod(CustomScriptConfiguration customScriptConfiguration, HttpServletRequest httpRequest, SessionId sessionId) {
        try {
            this.log.trace("Executing python 'startSession' method");
            ApplicationSessionType applicationSessionType = (ApplicationSessionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return applicationSessionType.startSession((Object)httpRequest, (Object)sessionId, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalStartSessionMethods(HttpServletRequest httpRequest, SessionId sessionId) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (customScriptConfiguration.getExternalType().getApiVersion() <= 1 || (result &= this.executeExternalStartSessionMethod(customScriptConfiguration, httpRequest, sessionId))) continue;
            return result;
        }
        return result;
    }

    public boolean executeExternalEndSessionMethod(CustomScriptConfiguration customScriptConfiguration, HttpServletRequest httpRequest, SessionId sessionId) {
        try {
            this.log.trace("Executing python 'endSession' method");
            ApplicationSessionType applicationSessionType = (ApplicationSessionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return applicationSessionType.endSession((Object)httpRequest, (Object)sessionId, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalEndSessionMethods(HttpServletRequest httpRequest, SessionId sessionId) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalEndSessionMethod(customScriptConfiguration, httpRequest, sessionId)) continue;
            return result;
        }
        return result;
    }

    public void externalEvent(SessionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        for (CustomScriptConfiguration scriptConfiguration : this.customScriptConfigurations) {
            this.externalEvent(scriptConfiguration, event);
        }
    }

    private void externalEvent(CustomScriptConfiguration scriptConfiguration, SessionEvent event) {
        try {
            this.log.trace("Executing python 'onEvent' method of script: {}, event: {}", (Object)scriptConfiguration.getName(), (Object)event);
            event.setScriptConfiguration(scriptConfiguration);
            ApplicationSessionType applicationSessionType = (ApplicationSessionType)scriptConfiguration.getExternalType();
            applicationSessionType.onEvent((Object)event);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
        }
    }

    public boolean modifyActiveSessionsResponse(JSONArray jsonArray, ExecutionContext executionContext) {
        if (!this.isEnabled()) {
            return false;
        }
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (this.modifyActiveSessionsResponse(script, jsonArray, executionContext)) continue;
            return false;
        }
        return true;
    }

    private boolean modifyActiveSessionsResponse(CustomScriptConfiguration script, JSONArray jsonArray, ExecutionContext context) {
        try {
            this.log.trace("Executing python 'modifyActiveSessionsResponse' method, context: {}, jsonArray: {}", (Object)context, (Object)jsonArray);
            context.setScript(script);
            ApplicationSessionType sessionType = (ApplicationSessionType)script.getExternalType();
            boolean result = sessionType.modifyActiveSessionsResponse((Object)jsonArray, (Object)context);
            this.log.trace("Finished 'modifyActiveSessionsResponse' method, result: {}, context: {}, jsonArray: {}", new Object[]{result, context, jsonArray});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }
}

