/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Sets;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.createuser.CreateUserType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalCreateUserService
extends ExternalScriptService {
    public ExternalCreateUserService() {
        super(CustomScriptType.CREATE_USER);
    }

    public boolean externalCreate(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Found {} create-user scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            boolean result = this.externalCreate(script, context);
            if (result) continue;
            this.log.debug("'createUser' returned false, script: {}", (Object)script.getName());
            return false;
        }
        return true;
    }

    public boolean externalCreate(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'createUser' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            CreateUserType script = (CreateUserType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            boolean result = script.createUser((Object)scriptContext);
            this.log.trace("Finished external 'createUser' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public String externalGetCreateUserPage(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return "";
        }
        this.log.trace("Found {} create-user scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            String page = this.externalGetCreateUserPage(script, context);
            if (!StringUtils.isNotBlank((CharSequence)page)) continue;
            this.log.debug("CreateUser page {} provided by external script: {}", (Object)page, (Object)script.getName());
            return page;
        }
        return "";
    }

    public String externalGetCreateUserPage(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'externalGetCreateUserPage' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            CreateUserType script = (CreateUserType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            String result = script.getCreateUserPage((Object)scriptContext);
            this.log.trace("Finished external 'externalGetCreateUserPage' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return "";
        }
    }

    public boolean externalPrepare(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Found {} 'createuser' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            boolean result = this.externalPrepare(script, context);
            if (result) continue;
            this.log.debug("'prepare' return false, script: {}", (Object)script.getName());
            return false;
        }
        return true;
    }

    public boolean externalPrepare(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'externalPrepare' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            CreateUserType script = (CreateUserType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            boolean result = script.prepare((Object)scriptContext);
            this.log.trace("Finished external 'externalPrepare' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public String externalBuildPostAuthorizeUrl(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return "";
        }
        this.log.trace("Found {} 'createuser' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            String result = this.externalBuildPostAuthorizeUrl(script, context);
            if (!StringUtils.isNotBlank((CharSequence)result)) continue;
            this.log.debug("'buildPostAuthorizeUrl' return {}, script: {}", (Object)result, (Object)script.getName());
            return result;
        }
        return "";
    }

    public String externalBuildPostAuthorizeUrl(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'buildPostAuthorizeUrl' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            CreateUserType script = (CreateUserType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            String result = script.buildPostAuthorizeUrl((Object)scriptContext);
            this.log.trace("Finished external 'buildPostAuthorizeUrl' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return "";
        }
    }

    private Set<CustomScriptConfiguration> getScriptsToExecute() {
        HashSet result = Sets.newHashSet();
        if (this.customScriptConfigurations == null) {
            return result;
        }
        result.addAll(this.customScriptConfigurations);
        return result;
    }
}

