/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.client.RegisterRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.util.CertUtils;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.DynamicClientRegistrationContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.client.ClientRegistrationType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalDynamicClientRegistrationService
extends ExternalScriptService {
    private static final long serialVersionUID = 1416361273036208688L;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public ExternalDynamicClientRegistrationService() {
        super(CustomScriptType.CLIENT_REGISTRATION);
    }

    public boolean executeExternalCreateClientMethod(CustomScriptConfiguration customScriptConfiguration, RegisterRequest registerRequest, Client client, HttpServletRequest httpRequest) {
        try {
            this.log.trace("Executing python 'createClient' method");
            ClientRegistrationType externalClientRegistrationType = (ClientRegistrationType)customScriptConfiguration.getExternalType();
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, null, customScriptConfiguration, client);
            context.setRegisterRequest(registerRequest);
            context.setErrorResponseFactory(this.errorResponseFactory);
            context.setSoftwareStatement(Jwt.parseSilently((String)registerRequest.getSoftwareStatement()));
            context.setEvidence(Jwt.parseSilently((String)registerRequest.getEvidence()));
            String clientCertAsPem = httpRequest.getHeader("X-ClientCert");
            if (StringUtils.isNotBlank((CharSequence)clientCertAsPem)) {
                context.setCertificate(CertUtils.x509CertificateFromPem((String)clientCertAsPem));
            } else {
                this.log.trace("Cert is not set for client registration. X-ClientCert header has no value.");
            }
            boolean result = externalClientRegistrationType.createClient((Object)context);
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalCreateClientMethods(RegisterRequest registerRequest, Client client, HttpServletRequest httpRequest) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (customScriptConfiguration.getExternalType().getApiVersion() <= 1 || (result &= this.executeExternalCreateClientMethod(customScriptConfiguration, registerRequest, client, httpRequest))) continue;
            return result;
        }
        return result;
    }

    public boolean executeExternalUpdateClientMethod(HttpServletRequest httpRequest, CustomScriptConfiguration script, RegisterRequest registerRequest, Client client) {
        try {
            this.log.trace("Executing python 'updateClient' method");
            ClientRegistrationType externalClientRegistrationType = (ClientRegistrationType)script.getExternalType();
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, null, script, client);
            context.setRegisterRequest(registerRequest);
            context.setSoftwareStatement(Jwt.parseSilently((String)registerRequest.getSoftwareStatement()));
            context.setEvidence(Jwt.parseSilently((String)registerRequest.getEvidence()));
            context.setErrorResponseFactory(this.errorResponseFactory);
            boolean result = externalClientRegistrationType.updateClient((Object)context);
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalUpdateClientMethods(HttpServletRequest httpRequest, RegisterRequest registerRequest, Client client) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalUpdateClientMethod(httpRequest, customScriptConfiguration, registerRequest, client)) continue;
            return result;
        }
        return result;
    }

    public JSONObject getSoftwareStatementJwks(HttpServletRequest httpRequest, JSONObject registerRequest, Jwt softwareStatement) {
        if (this.defaultExternalCustomScript == null) {
            return null;
        }
        try {
            this.log.info("Executing python 'getSoftwareStatementJwks' method, script name: {}", (Object)this.defaultExternalCustomScript.getName());
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, registerRequest, this.defaultExternalCustomScript);
            context.setSoftwareStatement(softwareStatement);
            context.setErrorResponseFactory(this.errorResponseFactory);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            String result = externalType.getSoftwareStatementJwks((Object)context);
            context.throwWebApplicationExceptionIfSet();
            this.log.info("Result of python 'getSoftwareStatementJwks' method: {}", (Object)result);
            return new JSONObject(result);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return null;
        }
    }

    public String getSoftwareStatementHmacSecret(HttpServletRequest httpRequest, JSONObject registerRequest, Jwt softwareStatement) {
        if (this.defaultExternalCustomScript == null) {
            return "";
        }
        try {
            this.log.trace("Executing python 'getSoftwareStatementHmacSecret' method");
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, registerRequest, this.defaultExternalCustomScript);
            context.setSoftwareStatement(softwareStatement);
            context.setErrorResponseFactory(this.errorResponseFactory);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            String result = externalType.getSoftwareStatementHmacSecret((Object)context);
            context.throwWebApplicationExceptionIfSet();
            this.log.trace("Result of python 'getSoftwareStatementHmacSecret' method: {}", (Object)result);
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return "";
        }
    }

    public JSONObject getDcrJwks(HttpServletRequest httpRequest, Jwt dcr) {
        if (this.defaultExternalCustomScript == null) {
            return null;
        }
        try {
            this.log.trace("Executing python 'getDcrJwks' method");
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, null, this.defaultExternalCustomScript);
            context.setDcr(dcr);
            context.setErrorResponseFactory(this.errorResponseFactory);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            String result = externalType.getDcrJwks((Object)context);
            context.throwWebApplicationExceptionIfSet();
            this.log.trace("Result of python 'getDcrJwks' method: {}", (Object)result);
            return new JSONObject(result);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return null;
        }
    }

    public String getDcrHmacSecret(HttpServletRequest httpRequest, Jwt dcr) {
        if (this.defaultExternalCustomScript == null) {
            return "";
        }
        try {
            this.log.trace("Executing python 'getDcrHmacSecret' method");
            DynamicClientRegistrationContext context = new DynamicClientRegistrationContext(httpRequest, null, this.defaultExternalCustomScript);
            context.setDcr(dcr);
            context.setErrorResponseFactory(this.errorResponseFactory);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            String result = externalType.getDcrHmacSecret((Object)context);
            context.throwWebApplicationExceptionIfSet();
            this.log.trace("Result of python 'getDcrHmacSecret' method: {}", (Object)result);
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return "";
        }
    }

    public boolean isCertValidForClient(X509Certificate cert, DynamicClientRegistrationContext context) {
        if (this.defaultExternalCustomScript == null) {
            return true;
        }
        try {
            this.log.trace("Executing python 'isCertValidForClient' method");
            context.setScript(this.defaultExternalCustomScript);
            context.setErrorResponseFactory(this.errorResponseFactory);
            ClientRegistrationType externalType = (ClientRegistrationType)this.defaultExternalCustomScript.getExternalType();
            boolean result = externalType.isCertValidForClient((Object)cert, (Object)context);
            context.throwWebApplicationExceptionIfSet();
            this.log.trace("Result of python 'isCertValidForClient' method: {}", (Object)result);
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(this.defaultExternalCustomScript.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyPostResponse(JSONObject responseAsJsonObject, ExecutionContext context) {
        if (this.defaultExternalCustomScript == null) {
            return false;
        }
        CustomScriptConfiguration script = this.defaultExternalCustomScript;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Executing python 'modifyPostResponse' method, script name: {}, context: {}, response: {}", new Object[]{script.getName(), context, responseAsJsonObject.toString()});
            }
            context.setScript(script);
            ClientRegistrationType type = (ClientRegistrationType)script.getExternalType();
            boolean result = type.modifyPostResponse((Object)responseAsJsonObject, (Object)context);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Finished 'modifyPostResponse' method, script name: {}, context: {}, result: {}, response: {}", new Object[]{script.getName(), context, result, responseAsJsonObject.toString()});
            }
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyPutResponse(JSONObject responseAsJsonObject, ExecutionContext context) {
        if (this.defaultExternalCustomScript == null) {
            return false;
        }
        CustomScriptConfiguration script = this.defaultExternalCustomScript;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Executing python 'modifyPutResponse' method, script name: {}, context: {}, response: {}", new Object[]{script.getName(), context, responseAsJsonObject.toString()});
            }
            context.setScript(script);
            ClientRegistrationType type = (ClientRegistrationType)script.getExternalType();
            boolean result = type.modifyPutResponse((Object)responseAsJsonObject, (Object)context);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Finished 'modifyPutResponse' method, script name: {}, context: {}, result: {}, response: {}", new Object[]{script.getName(), context, result, responseAsJsonObject.toString()});
            }
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyReadResponse(JSONObject responseAsJsonObject, ExecutionContext context) {
        if (this.defaultExternalCustomScript == null) {
            return false;
        }
        CustomScriptConfiguration script = this.defaultExternalCustomScript;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Executing python 'modifyReadResponse' method, script name: {}, context: {}, response: {}", new Object[]{script.getName(), context, responseAsJsonObject.toString()});
            }
            context.setScript(script);
            ClientRegistrationType type = (ClientRegistrationType)script.getExternalType();
            boolean result = type.modifyReadResponse((Object)responseAsJsonObject, (Object)context);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Finished 'modifyReadResponse' method, script name: {}, context: {}, result: {}, response: {}", new Object[]{script.getName(), context, result, responseAsJsonObject.toString()});
            }
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }
}

