/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Sets;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.service.external.context.DynamicScopeExternalContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.scope.DynamicScopeType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalDynamicScopeService
extends ExternalScriptService {
    private static final long serialVersionUID = 1416361273036208685L;

    public ExternalDynamicScopeService() {
        super(CustomScriptType.DYNAMIC_SCOPE);
    }

    public boolean executeExternalUpdateMethod(CustomScriptConfiguration customScriptConfiguration, DynamicScopeExternalContext dynamicScopeContext) {
        try {
            this.log.trace("Executing python 'update' method");
            DynamicScopeType dynamicScopeType = (DynamicScopeType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return dynamicScopeType.update((Object)dynamicScopeContext, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public List<String> executeExternalGetSupportedClaimsMethod(CustomScriptConfiguration customScriptConfiguration) {
        int apiVersion = this.executeExternalGetApiVersion(customScriptConfiguration);
        if (apiVersion > 1) {
            try {
                this.log.trace("Executing python 'get supported claims' method");
                DynamicScopeType dynamicScopeType = (DynamicScopeType)customScriptConfiguration.getExternalType();
                Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
                return dynamicScopeType.getSupportedClaims(configurationAttributes);
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
                this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            }
        }
        return null;
    }

    private Set<CustomScriptConfiguration> getScriptsToExecute(DynamicScopeExternalContext context) {
        HashSet allowedScripts = Sets.newHashSet();
        for (Scope scope : context.getScopes()) {
            List scopeScripts = scope.getDynamicScopeScripts();
            if (scopeScripts == null) continue;
            allowedScripts.addAll(scopeScripts);
        }
        HashSet result = Sets.newHashSet();
        if (this.customScriptConfigurations != null) {
            for (CustomScriptConfiguration script : this.customScriptConfigurations) {
                if (!allowedScripts.contains(script.getCustomScript().getDn())) continue;
                result.add(script);
            }
        }
        return result;
    }

    public boolean executeExternalUpdateMethods(DynamicScopeExternalContext dynamicScopeContext) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.getScriptsToExecute(dynamicScopeContext)) {
            if (result &= this.executeExternalUpdateMethod(customScriptConfiguration, dynamicScopeContext)) continue;
            return result;
        }
        return result;
    }

    public List<String> executeExternalGetSupportedClaimsMethods(List<Scope> dynamicScope) {
        DynamicScopeExternalContext context = new DynamicScopeExternalContext(dynamicScope, null, null);
        HashSet<String> result = new HashSet<String>();
        for (CustomScriptConfiguration customScriptConfiguration : this.getScriptsToExecute(context)) {
            List<String> scriptResult = this.executeExternalGetSupportedClaimsMethod(customScriptConfiguration);
            if (scriptResult == null) continue;
            result.addAll(scriptResult);
        }
        return new ArrayList<String>(result);
    }
}

