/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Sets;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.health.HealthCheckType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalHealthCheckService
extends ExternalScriptService {
    public ExternalHealthCheckService() {
        super(CustomScriptType.HEALTH_CHECK);
    }

    public String externalHealthCheck(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return null;
        }
        this.log.trace("Found {} health-check scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            String result = this.externalHealthCheck(script, context);
            if (!StringUtils.isNotBlank((CharSequence)result)) continue;
            this.log.debug("'healthCheck' returned result {}, script: {}", (Object)result, (Object)script.getName());
            return result;
        }
        return null;
    }

    private String externalHealthCheck(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'healthCheck' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            HealthCheckType script = (HealthCheckType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            ExternalScriptContext scriptContext = new ExternalScriptContext(context);
            String result = script.healthCheck((Object)scriptContext);
            this.log.trace("Finished external 'healthCheck' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    private Set<CustomScriptConfiguration> getScriptsToExecute() {
        HashSet result = Sets.newHashSet();
        if (this.customScriptConfigurations == null) {
            return result;
        }
        result.addAll(this.customScriptConfigurations);
        return result;
    }
}

