/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.registration.Client;
import io.jans.as.server.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.owner.ResourceOwnerPasswordCredentialsType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.List;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalResourceOwnerPasswordCredentialsService
extends ExternalScriptService {
    private static final long serialVersionUID = -1070021905117551202L;

    public ExternalResourceOwnerPasswordCredentialsService() {
        super(CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
    }

    public boolean executeExternalAuthenticate(ExternalResourceOwnerPasswordCredentialsContext context) {
        Client client = context.getExecutionContext().getClient();
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getRopcScripts());
        if (scripts == null || scripts.isEmpty()) {
            this.log.debug("There is no any external ROPC scripts assigned to client {}.", (Object)client.getClientId());
            return false;
        }
        for (CustomScriptConfiguration script : scripts) {
            if (this.executeExternalAuthenticate(script, context)) continue;
            this.log.debug("Stopped running external ROPC scripts because script {} returns false.", (Object)script.getName());
            return false;
        }
        return true;
    }

    private boolean executeExternalAuthenticate(CustomScriptConfiguration customScriptConfiguration, ExternalResourceOwnerPasswordCredentialsContext context) {
        try {
            this.log.debug("Executing external 'executeExternalAuthenticate' method, script name: {}, context: {}", (Object)customScriptConfiguration.getName(), (Object)context);
            ResourceOwnerPasswordCredentialsType script = (ResourceOwnerPasswordCredentialsType)customScriptConfiguration.getExternalType();
            context.setScript(customScriptConfiguration);
            if (script == null) {
                this.log.error("Failed to load script, name: {}", (Object)customScriptConfiguration.getName());
                return false;
            }
            boolean result = script.authenticate((Object)context);
            this.log.debug("Finished external 'executeExternalAuthenticate' method, script name: {}, context: {}, result: {}", new Object[]{customScriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

