/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Sets;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.selectaccount.SelectAccountType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalSelectAccountService
extends ExternalScriptService {
    public ExternalSelectAccountService() {
        super(CustomScriptType.SELECT_ACCOUNT);
    }

    public String externalGetAccountDisplayName(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return "";
        }
        this.log.trace("Found {} 'select-account' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            String name = this.externalGetAccountDisplayName(script, context);
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            this.log.debug("DisplayName '{}' provided by external script: {}", (Object)name, (Object)script.getName());
            return name;
        }
        return "";
    }

    public String externalGetAccountDisplayName(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'externalGetAccountDisplayName' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            SelectAccountType script = (SelectAccountType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            String result = script.getAccountDisplayName((Object)context);
            this.log.trace("Finished external 'externalGetAccountDisplayName' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return "";
        }
    }

    public boolean externalPrepare(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Found {} 'selectaccount' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            boolean result = this.externalPrepare(script, context);
            if (result) continue;
            this.log.debug("'prepare' return false, script: {}", (Object)script.getName());
            return false;
        }
        return true;
    }

    public boolean externalPrepare(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'externalPrepare' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            SelectAccountType script = (SelectAccountType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            boolean result = script.prepare((Object)context);
            this.log.trace("Finished external 'externalPrepare' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean externalOnSelect(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Found {} select-account scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            boolean result = this.externalOnSelect(script, context);
            if (result) continue;
            this.log.debug("onSelect return false, script: {}", (Object)script.getName());
            return false;
        }
        return true;
    }

    public boolean externalOnSelect(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'externalOnSelect' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            SelectAccountType script = (SelectAccountType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            boolean result = script.onSelect((Object)context);
            this.log.trace("Finished external 'externalOnSelect' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public String externalGetSelectAccountPage(ExecutionContext context) {
        Set<CustomScriptConfiguration> scripts = this.getScriptsToExecute();
        if (scripts.isEmpty()) {
            return "";
        }
        this.log.trace("Found {} select-account scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            String page = this.externalGetSelectAccountPage(script, context);
            if (!StringUtils.isNotBlank((CharSequence)page)) continue;
            this.log.debug("SelectAccount page {} provided by external script: {}", (Object)page, (Object)script.getName());
            return page;
        }
        return "";
    }

    public String externalGetSelectAccountPage(CustomScriptConfiguration scriptConfiguration, ExecutionContext context) {
        try {
            this.log.trace("Executing external 'externalGetSelectAccountPage' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            SelectAccountType script = (SelectAccountType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            String result = script.getSelectAccountPage((Object)context);
            this.log.trace("Finished external 'externalGetSelectAccountPage' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return "";
        }
    }

    private Set<CustomScriptConfiguration> getScriptsToExecute() {
        HashSet result = Sets.newHashSet();
        if (this.customScriptConfigurations == null) {
            return result;
        }
        result.addAll(this.customScriptConfigurations);
        return result;
    }
}

