/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.service.external.context.ExternalUmaRptClaimsContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.uma.UmaRptClaimsType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.List;
import org.json.JSONObject;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalUmaRptClaimsService
extends ExternalScriptService {
    public ExternalUmaRptClaimsService() {
        super(CustomScriptType.UMA_RPT_CLAIMS);
    }

    public boolean externalModify(JSONObject rptAsJson, ExternalUmaRptClaimsContext context) {
        List scripts = this.getCustomScriptConfigurationsByDns(context.getClient().getAttributes().getRptClaimsScripts());
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Found {} RPT Claims scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.externalModify(rptAsJson, script, context)) continue;
            return false;
        }
        this.log.debug("ExternalModify returned 'true'.");
        return true;
    }

    public boolean externalModify(JSONObject rptAsJson, CustomScriptConfiguration scriptConfiguration, ExternalUmaRptClaimsContext context) {
        try {
            this.log.trace("Executing external 'externalModify' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            UmaRptClaimsType script = (UmaRptClaimsType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            boolean result = script.modify((Object)rptAsJson, (Object)context);
            this.log.trace("Finished external 'externalModify' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

