/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external.context;

import io.jans.as.common.model.common.User;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.model.common.IAuthorizationGrant;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

public class DynamicScopeExternalContext
extends ExternalScriptContext {
    private final List<Scope> dynamicScopes;
    private final JsonWebResponse jsonWebResponse;
    private final IAuthorizationGrant authorizationGrant;

    public DynamicScopeExternalContext(List<Scope> dynamicScopes, JsonWebResponse jsonWebResponse, IAuthorizationGrant authorizationGrant) {
        super((HttpServletRequest)null);
        this.dynamicScopes = dynamicScopes;
        this.jsonWebResponse = jsonWebResponse;
        this.authorizationGrant = authorizationGrant;
    }

    public List<String> getDynamicScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        if (this.dynamicScopes != null) {
            for (Scope scope : this.dynamicScopes) {
                scopes.add(scope.getId());
            }
        }
        return scopes;
    }

    public List<Scope> getScopes() {
        return this.dynamicScopes;
    }

    public JsonWebResponse getJsonWebResponse() {
        return this.jsonWebResponse;
    }

    public IAuthorizationGrant getAuthorizationGrant() {
        return this.authorizationGrant;
    }

    public User getUser() {
        return this.authorizationGrant.getUser();
    }
}

