/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external.context;

import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalClientAuthnContext
extends ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(ExternalClientAuthnContext.class);
    private String realm = "jans-auth";

    public ExternalClientAuthnContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        super(httpRequest, httpResponse);
    }

    public void sendUnauthorizedError() {
        ErrorResponseFactory errorResponseFactory = (ErrorResponseFactory)CdiUtil.bean(ErrorResponseFactory.class);
        try (PrintWriter out = this.httpResponse.getWriter();){
            this.httpResponse.setStatus(401);
            this.httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            this.httpResponse.setContentType("application/json;charset=UTF-8");
            out.write(errorResponseFactory.errorAsJson((IErrorType)TokenErrorResponseType.INVALID_CLIENT, "Unable to authenticate client."));
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void sendResponse(HttpServletResponse httpResponse, WebApplicationException e) {
        try (PrintWriter out = httpResponse.getWriter();){
            httpResponse.setStatus(e.getResponse().getStatus());
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            httpResponse.setContentType("application/json;charset=UTF-8");
            out.write(e.getResponse().getEntity().toString());
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

