/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.stat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import io.jans.as.common.model.stat.StatEntry;
import io.jans.as.model.util.Util;
import io.jans.as.server.service.stat.StatService;
import io.jans.as.server.ws.rs.stat.StatResponse;
import io.jans.as.server.ws.rs.stat.StatResponseItem;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.agkn.hll.HLL;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class StatResponseService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private StatService statService;
    private final Cache<String, StatResponse> responseCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public StatResponse buildResponse(Set<String> months) {
        String cacheKey = months.toString();
        StatResponse cachedResponse = (StatResponse)this.responseCache.getIfPresent((Object)cacheKey);
        if (cachedResponse != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Get stat response from cache for: {}", (Object)Util.escapeLog((Object)cacheKey));
            }
            return cachedResponse;
        }
        StatResponse response = new StatResponse();
        for (String month : months) {
            StatResponseItem responseItem = this.buildItem(month);
            if (responseItem == null) continue;
            response.getResponse().put(month, responseItem);
        }
        this.responseCache.put((Object)cacheKey, (Object)response);
        return response;
    }

    private StatResponseItem buildItem(String month) {
        try {
            String escapedMonth = Util.escapeLog((Object)month);
            this.log.trace("Trying to fetch stat for month: {}", (Object)escapedMonth);
            List entries = this.entryManager.findEntries(this.statService.getBaseDn(), StatEntry.class, Filter.createEqualityFilter((String)"jansData", (Object)month));
            if (entries == null || entries.isEmpty()) {
                this.log.trace("Can't find stat entries for month: {}", (Object)escapedMonth);
                return null;
            }
            this.log.trace("Fetched stat entries for month {} successfully", (Object)escapedMonth);
            this.checkNotMatchedEntries(month, entries);
            if (entries.isEmpty()) {
                this.log.trace("No stat entries for month: {}", (Object)escapedMonth);
                return null;
            }
            StatResponseItem responseItem = new StatResponseItem();
            responseItem.setMonthlyActiveUsers(this.userCardinality(entries));
            responseItem.setMonth(month);
            this.unionTokenMapIntoResponseItem(entries, responseItem);
            return responseItem;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void checkNotMatchedEntries(String month, List<StatEntry> entries) {
        ArrayList notMatched = Lists.newArrayList();
        for (StatEntry entry : entries) {
            if (Objects.equals(month, entry.getMonth())) continue;
            this.log.error("Not matched entry: {}", (Object)entry.getDn());
            notMatched.add(entry);
        }
        entries.removeAll(notMatched);
    }

    private long userCardinality(List<StatEntry> entries) {
        HLL hll = this.decodeHll(entries.get(0));
        if (entries.size() > 1) {
            for (int i = 1; i < entries.size(); ++i) {
                hll.union(this.decodeHll(entries.get(i)));
            }
        }
        return hll.cardinality();
    }

    private HLL decodeHll(StatEntry entry) {
        try {
            return HLL.fromBytes((byte[])Base64.getDecoder().decode(entry.getUserHllData()));
        }
        catch (Exception e) {
            this.log.error("Failed to decode HLL data, entry dn: {}, data: {}", (Object)entry.getDn(), (Object)entry.getUserHllData());
            return this.statService.newHll();
        }
    }

    private void unionTokenMapIntoResponseItem(List<StatEntry> entries, StatResponseItem responseItem) {
        for (StatEntry entry : entries) {
            entry.getStat().getTokenCountPerGrantType().entrySet().stream().filter(en -> en.getValue() != null).forEach(en -> {
                Map<String, Long> tokenMap = responseItem.getTokenCountPerGrantType().get(en.getKey());
                if (tokenMap == null) {
                    responseItem.getTokenCountPerGrantType().put((String)en.getKey(), (Map)en.getValue());
                    return;
                }
                for (Map.Entry tokenEntry : ((Map)en.getValue()).entrySet()) {
                    Long counter = tokenMap.get(tokenEntry.getKey());
                    if (counter == null) {
                        tokenMap.put((String)tokenEntry.getKey(), (Long)tokenEntry.getValue());
                        continue;
                    }
                    tokenMap.put((String)tokenEntry.getKey(), counter + (Long)tokenEntry.getValue());
                }
            });
        }
    }
}

