/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.status.ldap;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.ldap.operation.LdapOperationService;
import io.jans.orm.ldap.operation.impl.LdapConnectionProvider;
import io.jans.orm.operation.PersistenceOperationService;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.LdapStatusEvent;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class LdapStatusTimer {
    private static final int DEFAULT_INTERVAL = 60;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    @Named(value="persistenceAuthEntryManager")
    private List<PersistenceEntryManager> ldapAuthEntryManagers;
    private AtomicBoolean isActive;

    public void initTimer() {
        this.log.info("Initializing Persistance Layer Status Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 60), (Object)new LdapStatusEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void process(@Observes @Scheduled LdapStatusEvent ldapStatusEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processInt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processInt() {
        this.logConnectionProviderStatistic(this.ldapEntryManager, "connectionProvider", "bindConnectionProvider");
        for (int i = 0; i < this.ldapAuthEntryManagers.size(); ++i) {
            PersistenceEntryManager ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i);
            this.logConnectionProviderStatistic(ldapAuthEntryManager, "authConnectionProvider#" + i, "bindAuthConnectionProvider#" + i);
        }
    }

    public void logConnectionProviderStatistic(PersistenceEntryManager ldapEntryManager, String connectionProviderName, String bindConnectionProviderName) {
        PersistenceOperationService persistenceOperationService = ldapEntryManager.getOperationService();
        if (!(persistenceOperationService instanceof LdapOperationService)) {
            return;
        }
        LdapConnectionProvider ldapConnectionProvider = ((LdapOperationService)persistenceOperationService).getConnectionProvider();
        LdapConnectionProvider bindLdapConnectionProvider = ((LdapOperationService)persistenceOperationService).getBindConnectionProvider();
        if (ldapConnectionProvider == null) {
            this.log.error("{} is empty", (Object)connectionProviderName);
        } else if (ldapConnectionProvider.getConnectionPool() == null) {
            this.log.error("{} is empty", (Object)connectionProviderName);
        } else {
            this.log.info("{} statistics: {}", (Object)connectionProviderName, (Object)ldapConnectionProvider.getConnectionPool().getConnectionPoolStatistics());
        }
        if (bindLdapConnectionProvider == null) {
            this.log.error("{} is empty", (Object)bindConnectionProviderName);
        } else if (bindLdapConnectionProvider.getConnectionPool() == null) {
            this.log.error("{} is empty", (Object)bindConnectionProviderName);
        } else {
            this.log.info("{} statistics: {}", (Object)bindConnectionProviderName, (Object)bindLdapConnectionProvider.getConnectionPool().getConnectionPoolStatistics());
        }
    }
}

