/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.revoke.GlobalTokenRevocationRequest;
import io.jans.as.model.session.EndSessionErrorResponseType;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.UserService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.token.TokenEntity;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class GlobalTokenRevocationService {
    @Inject
    private Logger log;
    @Inject
    private UserService userService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private Identity identity;
    @Inject
    private ScopeService scopeService;
    @Inject
    private GrantService grantService;

    public void requestGlobalTokenRevocation(String requestAsString) {
        this.log.debug("Attempt for global token revocation: request = {}, ", (Object)requestAsString);
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.GLOBAL_TOKEN_REVOCATION);
        this.validateAccess();
        GlobalTokenRevocationRequest parsedRequest = this.parseRequest(requestAsString);
        String key = parsedRequest.getSubId().getFormat();
        String value = parsedRequest.getSubId().getId();
        User user = this.userService.getUserByAttribute(key, value);
        if (user == null) {
            this.log.trace("Unable to find user by {}={}", (Object)key, (Object)value);
            return;
        }
        List<SessionId> sessionIdList = this.sessionIdService.findByUser(user.getDn());
        this.sessionIdService.remove(sessionIdList);
        this.log.debug("Revoked {} user's sessions (user: {})", (Object)(sessionIdList != null ? sessionIdList.size() : 0), (Object)user.getUserId());
        List<TokenEntity> grants = this.grantService.getGrantsByUserDn(user.getDn());
        this.grantService.removeSilently(grants);
        this.log.debug("Revoked {} tokens (user: {})", (Object)(grants != null ? grants.size() : 0), (Object)user.getUserId());
    }

    public void validateAccess() {
        SessionClient sessionClient = this.identity.getSessionClient();
        if (sessionClient == null || sessionClient.getClient() == null || ArrayUtils.isEmpty((Object[])sessionClient.getClient().getScopes())) {
            this.log.debug("Client failed to authenticate.");
            throw new WebApplicationException(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST)).build());
        }
        List<String> scopesAllowedIds = this.scopeService.getScopeIdsByDns(Arrays.asList(sessionClient.getClient().getScopes()));
        if (!scopesAllowedIds.contains("global_token_revocation")) {
            this.log.debug("Client does not have required global_token_revocation scope.");
            throw new WebApplicationException(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST)).build());
        }
    }

    public GlobalTokenRevocationRequest parseRequest(String requestAsString) {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        try {
            return (GlobalTokenRevocationRequest)mapper.readValue(requestAsString, GlobalTokenRevocationRequest.class);
        }
        catch (IOException e) {
            this.log.error("Failed to parse " + requestAsString, (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "Failed to parse GlobalTokenRevocationRequest.");
        }
    }
}

