/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.util.CertUtils;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.as.persistence.model.ScopeAttributes;
import io.jans.as.server.ciba.CIBAConfigurationService;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.ExternalAuthzDetailTypeService;
import io.jans.as.server.service.external.ExternalDynamicScopeService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.JansAttribute;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/fapi-rs/.well-known/openid-configuration"}, loadOnStartup=9)
public class FapiOpenIdConfiguration
extends HttpServlet {
    private static final long serialVersionUID = -8224898157373678903L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AttributeService attributeService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private transient ExternalAuthzDetailTypeService externalAuthzDetailTypeService;
    @Inject
    private CIBAConfigurationService cibaConfigurationService;
    @Inject
    private TokenService tokenService;
    @Inject
    private ClientService clientService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;

    public void init() throws ServletException {
        this.log.info("Inside init method of FapiOpenIdConfiguration***********************************************************************");
    }

    protected void processRequest(HttpServletRequest servletRequest, HttpServletResponse httpResponse) {
        String authFromReq = null;
        String xfapiinteractionid = null;
        String tempaccess_token = null;
        httpResponse.setContentType("application/json");
        try (PrintWriter out = httpResponse.getWriter();){
            String clientCertAsPem;
            xfapiinteractionid = servletRequest.getHeader("x-fapi-interaction-id");
            tempaccess_token = servletRequest.getParameter("access_token");
            if (tempaccess_token != null && xfapiinteractionid != null) {
                if (tempaccess_token.startsWith("Bearer")) {
                    this.log.info("FAPI: Authorization Bearer Token from qeury ********************************************* {}", (Object)tempaccess_token);
                    this.log.info("FAPI: Bearler Token is not allowed.**********************************************************************.");
                    httpResponse.sendError(400, "Bearer token in query is disallowed");
                } else {
                    httpResponse.sendError(400, "token in query is disallowed");
                }
                this.log.info("FAPI: Authorization token is non-Bearer is not allowed in query*********************************************");
            }
            if ((clientCertAsPem = servletRequest.getHeader("X-ClientCert")) != null) {
                this.log.info("FAPI: clientCertAsPem found*****************************************");
                this.log.info("FAPI: clientCertAsPem found*****************************************" + clientCertAsPem);
            } else {
                this.log.info("FAPI: No clientCertAsPem *****************************************");
            }
            authFromReq = servletRequest.getHeader("Authorization");
            String clientDn = null;
            Client cl = null;
            clientDn = this.tokenService.getClientDn(authFromReq);
            String bearerToken = this.tokenService.getBearerToken(authFromReq);
            X509Certificate cert = CertUtils.x509CertificateFromPem((String)clientCertAsPem);
            AuthorizationGrant authorizationGrant = this.tokenService.getBearerAuthorizationGrant(authFromReq);
            if (authorizationGrant == null) {
                this.log.error("FAPI: Authorization grant is null.*********************************************");
                httpResponse.sendError(401, "Authorization grant is null.");
            }
            if (cert == null) {
                this.log.debug("Failed to parse client certificate, client_dn: {}.", (Object)clientDn);
                return;
            }
            PublicKey publicKey = cert.getPublicKey();
            byte[] encodedKey = publicKey.getEncoded();
            if (clientDn != null) {
                this.log.info("FAPI: ClientDn from Authoirization(tokenService) *********************************************" + clientDn);
                cl = this.clientService.getClientByDn(clientDn);
                String tempjwks = cl.getJwks();
                if (tempjwks == null) {
                    this.log.debug("********************FAPIRS JWKS not defined for the client");
                } else {
                    JSONObject jsonWebKeys = new JSONObject(tempjwks);
                    int matchctr = 0;
                    JSONWebKeySet keySet = JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys);
                    try {
                        for (JSONWebKey key : keySet.getKeys()) {
                            if (!ArrayUtils.isEquals((Object)encodedKey, (Object)this.cryptoProvider.getPublicKey(key.getKid(), jsonWebKeys, null).getEncoded())) continue;
                            ++matchctr;
                            this.log.debug("********************************Client {} authenticated via `self_signed_tls_client_auth`, matched kid: {}.", (Object)cl.getClientId(), (Object)key.getKid());
                        }
                        if (matchctr == 0) {
                            this.log.error("Client certificate does not match clientId. clientId: " + cl.getClientId() + "*********************************************");
                            httpResponse.setStatus(401, "The resource owner or authorization server denied the request");
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.log.info("Exception while keymatching****************************************************************");
                    }
                }
            } else {
                this.log.info("FAPI: ClientDn from Authoirization(tokenService) is NULL*********************************************");
            }
            JSONObject jsonObj = new JSONObject();
            if (xfapiinteractionid != null) {
                httpResponse.addHeader("x-fapi-interaction-id", xfapiinteractionid);
                this.log.info("x-fapi-interaction-id*************************=" + xfapiinteractionid);
            } else {
                xfapiinteractionid = "c770aef3-6784-41f7-8e0e-ff5f97bddb3a";
                httpResponse.addHeader("x-fapi-interaction-id", xfapiinteractionid);
                this.log.info("x-fapi-interaction-id***********************=" + xfapiinteractionid);
            }
            jsonObj.put("issuer", (Object)this.appConfiguration.getIssuer());
            jsonObj.put("authorization_endpoint", (Object)this.appConfiguration.getAuthorizationEndpoint());
            jsonObj.put("authorization_challenge_endpoint", (Object)this.appConfiguration.getAuthorizationChallengeEndpoint());
            jsonObj.put("token_endpoint", (Object)this.appConfiguration.getTokenEndpoint());
            jsonObj.put("revocation_endpoint", (Object)this.appConfiguration.getTokenRevocationEndpoint());
            jsonObj.put("global_token_revocation_endpoint", (Object)this.endpointUrl("/global-token-revocation"));
            jsonObj.put("userinfo_endpoint", (Object)this.appConfiguration.getUserInfoEndpoint());
            jsonObj.put("clientinfo_endpoint", (Object)this.appConfiguration.getClientInfoEndpoint());
            jsonObj.put("check_session_iframe", (Object)this.appConfiguration.getCheckSessionIFrame());
            jsonObj.put("end_session_endpoint", (Object)this.appConfiguration.getEndSessionEndpoint());
            jsonObj.put("jwks_uri", (Object)this.appConfiguration.getJwksUri());
            jsonObj.put("archived_jwks_uri", (Object)this.appConfiguration.getArchivedJwksUri());
            jsonObj.put("registration_endpoint", (Object)this.appConfiguration.getRegistrationEndpoint());
            jsonObj.put("id_generation_endpoint", (Object)this.appConfiguration.getIdGenerationEndpoint());
            jsonObj.put("introspection_endpoint", (Object)this.appConfiguration.getIntrospectionEndpoint());
            jsonObj.put("pushed_authorization_request_endpoint", (Object)this.appConfiguration.getParEndpoint());
            jsonObj.put("require_pushed_authorization_requests", (Object)this.appConfiguration.getRequirePar());
            JSONArray responseTypesSupported = new JSONArray();
            for (Object responseTypes : this.appConfiguration.getResponseTypesSupported()) {
                responseTypesSupported.put((Object)StringUtils.implode((Collection)responseTypes, (String)" "));
            }
            if (responseTypesSupported.length() > 0) {
                jsonObj.put("response_types_supported", (Object)responseTypesSupported);
            }
            JSONArray responseModesSupported = new JSONArray();
            if (this.appConfiguration.getResponseModesSupported() != null) {
                for (Object responseMode : this.appConfiguration.getResponseModesSupported()) {
                    responseModesSupported.put(responseMode);
                }
            }
            if (responseModesSupported.length() > 0) {
                jsonObj.put("response_modes_supported", (Object)responseModesSupported);
            }
            JSONArray grantTypesSupported = new JSONArray();
            for (Object grantType : this.appConfiguration.getGrantTypesSupported()) {
                grantTypesSupported.put(grantType);
            }
            if (grantTypesSupported.length() > 0) {
                jsonObj.put("grant_types_supported", (Object)grantTypesSupported);
            }
            JSONArray acrValuesSupported = new JSONArray();
            for (String string : this.externalAuthenticationService.getAcrValuesList()) {
                acrValuesSupported.put((Object)string);
            }
            jsonObj.put("acr_values_supported", (Object)acrValuesSupported);
            jsonObj.put("auth_level_mapping", (Object)this.createAuthLevelMapping());
            Util.putArray((JSONObject)jsonObj, (List)Lists.newArrayList(this.externalAuthzDetailTypeService.getSupportedAuthzDetailsTypes()), (String)"authorization_details_types_supported");
            JSONArray subjectTypesSupported = new JSONArray();
            for (Object subjectType : this.appConfiguration.getSubjectTypesSupported()) {
                subjectTypesSupported.put(subjectType);
            }
            if (subjectTypesSupported.length() > 0) {
                jsonObj.put("subject_types_supported", (Object)subjectTypesSupported);
            }
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIntrospectionSigningAlgValuesSupported(), (String)"introspection_signing_alg_values_supported");
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIntrospectionEncryptionAlgValuesSupported(), (String)"introspection_encryption_alg_values_supported");
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getIntrospectionEncryptionEncValuesSupported(), (String)"introspection_encryption_enc_values_supported");
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTxTokenSigningAlgValuesSupported(), (String)"tx_token_signing_alg_values_supported");
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTxTokenEncryptionAlgValuesSupported(), (String)"tx_token_encryption_alg_values_supported");
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getTxTokenEncryptionEncValuesSupported(), (String)"tx_token_encryption_enc_values_supported");
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getLogoutStatusJwtSigningAlgValuesSupported(), (String)"logout_status_jwt_signing_alg_values_supported");
            JSONArray jSONArray = new JSONArray();
            for (Object userInfoSigningAlg : this.appConfiguration.getUserInfoSigningAlgValuesSupported()) {
                jSONArray.put(userInfoSigningAlg);
            }
            if (jSONArray.length() > 0) {
                jsonObj.put("userinfo_signing_alg_values_supported", (Object)jSONArray);
            }
            JSONArray userInfoEncryptionAlgValuesSupported = new JSONArray();
            for (Object userInfoEncryptionAlg : this.appConfiguration.getUserInfoEncryptionAlgValuesSupported()) {
                userInfoEncryptionAlgValuesSupported.put(userInfoEncryptionAlg);
            }
            if (userInfoEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_encryption_alg_values_supported", (Object)userInfoEncryptionAlgValuesSupported);
            }
            JSONArray userInfoEncryptionEncValuesSupported = new JSONArray();
            for (Object userInfoEncryptionEnc : this.appConfiguration.getUserInfoEncryptionEncValuesSupported()) {
                userInfoEncryptionEncValuesSupported.put(userInfoEncryptionEnc);
            }
            if (userInfoEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_encryption_enc_values_supported", (Object)userInfoEncryptionAlgValuesSupported);
            }
            JSONArray idTokenSigningAlgValuesSupported = new JSONArray();
            for (Object idTokenSigningAlg : this.appConfiguration.getIdTokenSigningAlgValuesSupported()) {
                idTokenSigningAlgValuesSupported.put(idTokenSigningAlg);
            }
            if (idTokenSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("id_token_signing_alg_values_supported", (Object)idTokenSigningAlgValuesSupported);
            }
            JSONArray idTokenEncryptionAlgValuesSupported = new JSONArray();
            for (Object idTokenEncryptionAlg : this.appConfiguration.getIdTokenEncryptionAlgValuesSupported()) {
                idTokenEncryptionAlgValuesSupported.put(idTokenEncryptionAlg);
            }
            if (idTokenEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("id_token_encryption_alg_values_supported", (Object)idTokenEncryptionAlgValuesSupported);
            }
            JSONArray idTokenEncryptionEncValuesSupported = new JSONArray();
            for (Object idTokenEncryptionEnc : this.appConfiguration.getIdTokenEncryptionEncValuesSupported()) {
                idTokenEncryptionEncValuesSupported.put(idTokenEncryptionEnc);
            }
            if (idTokenEncryptionEncValuesSupported.length() > 0) {
                jsonObj.put("id_token_encryption_enc_values_supported", (Object)idTokenEncryptionEncValuesSupported);
            }
            Util.putArray((JSONObject)jsonObj, (List)this.appConfiguration.getAccessTokenSigningAlgValuesSupported(), (String)"access_token_signing_alg_values_supported");
            JSONArray requestObjectSigningAlgValuesSupported = new JSONArray();
            for (Object requestObjectSigningAlg : this.appConfiguration.getRequestObjectSigningAlgValuesSupported()) {
                requestObjectSigningAlgValuesSupported.put(requestObjectSigningAlg);
            }
            if (requestObjectSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("request_object_signing_alg_values_supported", (Object)requestObjectSigningAlgValuesSupported);
            }
            JSONArray requestObjectEncryptionAlgValuesSupported = new JSONArray();
            for (Object requestObjectEncryptionAlg : this.appConfiguration.getRequestObjectEncryptionAlgValuesSupported()) {
                requestObjectEncryptionAlgValuesSupported.put(requestObjectEncryptionAlg);
            }
            if (requestObjectEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("request_object_encryption_alg_values_supported", (Object)requestObjectEncryptionAlgValuesSupported);
            }
            JSONArray requestObjectEncryptionEncValuesSupported = new JSONArray();
            for (Object requestObjectEncryptionEnc : this.appConfiguration.getRequestObjectEncryptionEncValuesSupported()) {
                requestObjectEncryptionEncValuesSupported.put(requestObjectEncryptionEnc);
            }
            if (requestObjectEncryptionEncValuesSupported.length() > 0) {
                jsonObj.put("request_object_encryption_enc_values_supported", (Object)requestObjectEncryptionEncValuesSupported);
            }
            JSONArray tokenEndpointAuthMethodsSupported = new JSONArray();
            for (Object tokenEndpointAuthMethod : this.appConfiguration.getTokenEndpointAuthMethodsSupported()) {
                tokenEndpointAuthMethodsSupported.put(tokenEndpointAuthMethod);
            }
            if (tokenEndpointAuthMethodsSupported.length() > 0) {
                jsonObj.put("token_endpoint_auth_methods_supported", (Object)tokenEndpointAuthMethodsSupported);
            }
            JSONArray tokenEndpointAuthSigningAlgValuesSupported = new JSONArray();
            for (Object tokenEndpointAuthSigningAlg : this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported()) {
                tokenEndpointAuthSigningAlgValuesSupported.put(tokenEndpointAuthSigningAlg);
            }
            if (tokenEndpointAuthSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("token_endpoint_auth_signing_alg_values_supported", (Object)tokenEndpointAuthSigningAlgValuesSupported);
            }
            JSONArray displayValuesSupported = new JSONArray();
            for (Object display : this.appConfiguration.getDisplayValuesSupported()) {
                displayValuesSupported.put(display);
            }
            if (displayValuesSupported.length() > 0) {
                jsonObj.put("display_values_supported", (Object)displayValuesSupported);
            }
            JSONArray claimTypesSupported = new JSONArray();
            for (Object claimType : this.appConfiguration.getClaimTypesSupported()) {
                claimTypesSupported.put(claimType);
            }
            if (claimTypesSupported.length() > 0) {
                jsonObj.put("claim_types_supported", (Object)claimTypesSupported);
            }
            jsonObj.put("service_documentation", (Object)this.appConfiguration.getServiceDocumentation());
            JSONArray idTokenTokenBindingCnfValuesSupported = new JSONArray();
            for (Object value : this.appConfiguration.getIdTokenTokenBindingCnfValuesSupported()) {
                idTokenTokenBindingCnfValuesSupported.put(value);
            }
            jsonObj.put("id_token_token_binding_cnf_values_supported", (Object)idTokenTokenBindingCnfValuesSupported);
            JSONArray claimsLocalesSupported = new JSONArray();
            for (Object claimLocale : this.appConfiguration.getClaimsLocalesSupported()) {
                claimsLocalesSupported.put(claimLocale);
            }
            if (claimsLocalesSupported.length() > 0) {
                jsonObj.put("claims_locales_supported", (Object)claimsLocalesSupported);
            }
            JSONArray uiLocalesSupported = new JSONArray();
            for (String uiLocale : this.appConfiguration.getUiLocalesSupported()) {
                uiLocalesSupported.put((Object)uiLocale);
            }
            if (uiLocalesSupported.length() > 0) {
                jsonObj.put("ui_locales_supported", (Object)uiLocalesSupported);
            }
            JSONArray scopesSupported = new JSONArray();
            JSONArray claimsSupported = new JSONArray();
            JSONArray scopeToClaimsMapping = this.createScopeToClaimsMapping(scopesSupported, claimsSupported);
            if (scopesSupported.length() > 0) {
                jsonObj.put("scopes_supported", (Object)scopesSupported);
            }
            if (claimsSupported.length() > 0) {
                jsonObj.put("claims_supported", (Object)claimsSupported);
            }
            jsonObj.put("scope_to_claims_mapping", (Object)scopeToClaimsMapping);
            jsonObj.put("claims_parameter_supported", (Object)this.appConfiguration.getClaimsParameterSupported());
            jsonObj.put("request_parameter_supported", (Object)this.appConfiguration.getRequestParameterSupported());
            jsonObj.put("request_uri_parameter_supported", (Object)this.appConfiguration.getRequestUriParameterSupported());
            jsonObj.put("require_request_uri_registration", (Object)this.appConfiguration.getRequireRequestUriRegistration());
            jsonObj.put("op_policy_uri", (Object)this.appConfiguration.getOpPolicyUri());
            jsonObj.put("op_tos_uri", (Object)this.appConfiguration.getOpTosUri());
            jsonObj.put("tls_client_certificate_bound_access_tokens", (Object)Boolean.TRUE);
            jsonObj.put("backchannel_logout_supported", (Object)Boolean.TRUE);
            jsonObj.put("backchannel_logout_session_supported", (Object)Boolean.TRUE);
            jsonObj.put("frontchannel_logout_supported", (Object)Boolean.TRUE);
            jsonObj.put("frontchannel_logout_session_supported", (Object)Boolean.TRUE);
            jsonObj.put("frontchannel_logout_session_supported", (Object)this.appConfiguration.getFrontChannelLogoutSessionSupported());
            this.cibaConfigurationService.processConfiguration(jsonObj);
            out.println(ServerUtil.toPrettyJson(jsonObj).replace("\\/", "/"));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String endpointUrl(String path) {
        return org.apache.commons.lang3.StringUtils.replace((String)this.appConfiguration.getEndSessionEndpoint(), (String)"/end_session", (String)path);
    }

    @Deprecated
    private JSONArray createScopeToClaimsMapping(JSONArray scopesSupported, JSONArray claimsSupported) {
        JSONArray scopeToClaimMapping = new JSONArray();
        HashSet<String> scopes = new HashSet<String>();
        HashSet<String> claims = new HashSet<String>();
        try {
            for (Scope scope : this.scopeService.getAllScopesList()) {
                if (scope.getScopeType() == ScopeType.SPONTANEOUS && scope.isDeletable().booleanValue() || !this.canShowInConfigEndpoint(scope.getAttributes())) continue;
                JSONArray claimsList = new JSONArray();
                JSONObject mapping = new JSONObject();
                mapping.put(scope.getId(), (Object)claimsList);
                scopes.add(scope.getId());
                scopeToClaimMapping.put((Object)mapping);
                if (ScopeType.DYNAMIC.equals((Object)scope.getScopeType())) {
                    List<String> claimNames = this.externalDynamicScopeService.executeExternalGetSupportedClaimsMethods(Arrays.asList(scope));
                    for (String claimName : claimNames) {
                        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)claimName)) continue;
                        claimsList.put((Object)claimName);
                        claims.add(claimName);
                    }
                    continue;
                }
                List claimIdList = scope.getClaims();
                if (claimIdList == null || claimIdList.isEmpty()) continue;
                for (String claimDn : claimIdList) {
                    JansAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = attribute.getClaimName();
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)claimName)) continue;
                    claimsList.put((Object)claimName);
                    claims.add(claimName);
                }
            }
            for (String string : scopes) {
                scopesSupported.put((Object)string);
            }
            for (String string : claims) {
                claimsSupported.put((Object)string);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return scopeToClaimMapping;
    }

    private boolean canShowInConfigEndpoint(ScopeAttributes scopeAttributes) {
        return scopeAttributes.isShowInConfigurationEndpoint();
    }

    @Deprecated
    private JSONObject createAuthLevelMapping() {
        JSONObject mappings = new JSONObject();
        try {
            Map<Integer, Set<String>> map = this.externalAuthenticationService.levelToAcrMapping();
            for (Integer level : map.keySet()) {
                mappings.put(level.toString(), (Collection)map.get(level));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return mappings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Provider Configuration Information";
    }
}

