/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.discovery.OpenIdConnectDiscoveryParamsValidator;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/.well-known/webfinger"})
public class WebFinger
extends HttpServlet {
    private static final long serialVersionUID = -4708834950205359151L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/jrd+json");
        String resource = request.getParameter("resource");
        String rel = request.getParameter("rel");
        this.log.debug("Attempting to request OpenID Connect Discovery: {}, {}", (Object)Util.escapeLog((Object)resource), (Object)Util.escapeLog((Object)rel));
        try (PrintWriter out = response.getWriter();){
            if (!OpenIdConnectDiscoveryParamsValidator.validateParams(resource, rel)) {
                return;
            }
            if (rel == null || rel.equals("http://openid.net/specs/connect/1.0/issuer")) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("subject", (Object)resource);
                JSONArray linksJsonArray = new JSONArray();
                JSONObject linkJsonObject = new JSONObject();
                linkJsonObject.put("rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
                linkJsonObject.put("href", (Object)this.appConfiguration.getIssuer());
                linksJsonArray.put((Object)linkJsonObject);
                jsonObj.put("links", (Object)linksJsonArray);
                out.println(jsonObj.toString(4).replace("\\/", "/"));
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Connect Discovery";
    }
}

