/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.session.ws.rs;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.error.ErrorHandlingMethod;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.gluu.GluuErrorResponseType;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.session.EndSessionErrorResponseType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.util.Util;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.RedirectionUriService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalApplicationSessionService;
import io.jans.as.server.service.external.ExternalEndSessionService;
import io.jans.as.server.service.external.context.EndSessionContext;
import io.jans.as.server.session.ws.rs.EndSessionRestWebService;
import io.jans.as.server.session.ws.rs.EndSessionService;
import io.jans.as.server.session.ws.rs.EndSessionUtils;
import io.jans.as.server.session.ws.rs.LogoutTokenFactory;
import io.jans.as.server.util.ServerUtil;
import io.jans.as.server.util.TokenHashUtil;
import io.jans.model.security.Identity;
import io.jans.util.Pair;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/")
public class EndSessionRestWebServiceImpl
implements EndSessionRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    @Inject
    private ExternalEndSessionService externalEndSessionService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientService clientService;
    @Inject
    private GrantService grantService;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private LogoutTokenFactory logoutTokenFactory;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private EndSessionService endSessionService;

    @Override
    public Response requestEndSession(String idTokenHint, String postLogoutRedirectUri, String state, String sid, String clientId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext sec) {
        try {
            this.log.debug("Attempting to end session, idTokenHint: {}, postLogoutRedirectUri: {}, sid: {}, Is Secure = {}, clientId = {}", new Object[]{idTokenHint, postLogoutRedirectUri, sid, sec.isSecure(), clientId});
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.END_SESSION);
            SessionId sidSession = this.validateSidRequestParameter(sid, postLogoutRedirectUri, state, clientId);
            Jwt validatedIdToken = this.validateIdTokenHint(idTokenHint, sidSession, postLogoutRedirectUri, state, clientId);
            Pair<SessionId, AuthorizationGrant> pair = this.getPair(idTokenHint, validatedIdToken, sid, httpRequest);
            if (pair.getFirst() == null) {
                String reason = "Failed to identify session by session_id query parameter or by session_id cookie.";
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "Failed to identify session by session_id query parameter or by session_id cookie.", state, clientId));
            }
            postLogoutRedirectUri = this.validatePostLogoutRedirectUri(postLogoutRedirectUri, pair, state, clientId);
            this.validateSid(postLogoutRedirectUri, validatedIdToken, (SessionId)pair.getFirst(), state, clientId);
            this.endSession(pair, httpRequest, httpResponse);
            this.auditLogging(httpRequest, pair);
            Set<Client> clients = this.getSsoClients(pair);
            HashSet frontchannelUris = Sets.newHashSet();
            HashMap backchannelUris = Maps.newHashMap();
            this.collectFrontAndBackChannelsUris(pair, clients, frontchannelUris, backchannelUris);
            this.backChannel(backchannelUris, (AuthorizationGrant)pair.getSecond(), (SessionId)pair.getFirst());
            postLogoutRedirectUri = this.addStateInPostLogoutRedirectUri(postLogoutRedirectUri, state);
            if (frontchannelUris.isEmpty() && StringUtils.isNotBlank((CharSequence)postLogoutRedirectUri)) {
                return this.noFrontChannelRedirectUrisResponse(postLogoutRedirectUri);
            }
            return this.httpBased(frontchannelUris, postLogoutRedirectUri, state, pair, httpRequest);
        }
        catch (WebApplicationException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)GluuErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private void collectFrontAndBackChannelsUris(Pair<SessionId, AuthorizationGrant> pair, Set<Client> clients, Set<String> frontchannelUris, Map<String, Client> backchannelUris) {
        for (Client client : clients) {
            boolean hasBackchannel = false;
            for (String logoutUri : client.getAttributes().getBackchannelLogoutUri()) {
                if (Util.isNullOrEmpty((String)logoutUri)) continue;
                backchannelUris.put(logoutUri, client);
                hasBackchannel = true;
            }
            if (hasBackchannel || !StringUtils.isNotBlank((CharSequence)client.getFrontChannelLogoutUri())) continue;
            String logoutUri = client.getFrontChannelLogoutUri();
            if (BooleanUtils.isTrue((Boolean)client.getFrontChannelLogoutSessionRequired())) {
                logoutUri = EndSessionUtils.appendSid(logoutUri, ((SessionId)pair.getFirst()).getOutsideSid(), this.appConfiguration.getIssuer());
            }
            frontchannelUris.add(logoutUri);
        }
    }

    private Response noFrontChannelRedirectUrisResponse(String postLogoutRedirectUri) {
        this.log.trace("No frontchannel_redirect_uri's found in clients involved in SSO.");
        try {
            this.log.trace("Redirect to postlogout_redirect_uri: {}", (Object)postLogoutRedirectUri);
            return Response.status((Response.Status)Response.Status.FOUND).location(new URI(postLogoutRedirectUri)).build();
        }
        catch (URISyntaxException e) {
            String message = "Failed to create URI for " + postLogoutRedirectUri + " postlogout_redirect_uri.";
            this.log.error(message);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST, message)).build();
        }
    }

    private String addStateInPostLogoutRedirectUri(String postLogoutRedirectUri, String state) {
        if (StringUtils.isBlank((CharSequence)postLogoutRedirectUri) || StringUtils.isBlank((CharSequence)state)) {
            return postLogoutRedirectUri;
        }
        return UriBuilder.fromUri((String)postLogoutRedirectUri).queryParam("state", new Object[]{state}).build(new Object[0]).toString();
    }

    private void validateSid(String postLogoutRedirectUri, Jwt idToken, SessionId session, String state, String clientId) {
        if (idToken == null) {
            return;
        }
        String sid = idToken.getClaims().getClaimAsString("sid");
        if (StringUtils.isNotBlank((CharSequence)sid) && !sid.equals(session.getOutsideSid())) {
            this.log.error("sid in id_token_hint does not match sid of the session. id_token_hint sid: {}, session sid: {}", (Object)sid, (Object)session.getOutsideSid());
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_REQUEST, "sid in id_token_hint does not match sid of the session", state, clientId));
        }
    }

    private void backChannel(Map<String, Client> backchannelUris, AuthorizationGrant grant, SessionId session) {
        User user;
        if (backchannelUris.isEmpty()) {
            return;
        }
        this.log.trace("backchannel_redirect_uri's: {}", backchannelUris);
        User user2 = user = grant != null ? grant.getUser() : null;
        if (user == null) {
            user = this.sessionIdService.getUser(session);
        }
        ExecutorService executorService = EndSessionUtils.getExecutorService();
        for (Map.Entry<String, Client> entry : backchannelUris.entrySet()) {
            JsonWebResponse logoutToken = this.logoutTokenFactory.createLogoutToken(entry.getValue(), session.getOutsideSid(), user);
            if (logoutToken == null) {
                this.log.error("Failed to create logout_token for client: {}", (Object)entry.getValue().getClientId());
                return;
            }
            executorService.execute(() -> EndSessionUtils.callRpWithBackchannelUri((String)entry.getKey(), logoutToken.toString()));
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
            this.log.trace("Finished backchannel calls.");
        }
        catch (InterruptedException e) {
            this.log.error("Thread is interrupted.");
            Thread.currentThread().interrupt();
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)GluuErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private Response createErrorResponse(String postLogoutRedirectUri, EndSessionErrorResponseType error, String reason, String state, String clientId) {
        this.log.debug("Creating error response, reason: {}, error: {}", (Object)reason, (Object)error);
        try {
            if (this.allowPostLogoutRedirect((String)postLogoutRedirectUri, clientId)) {
                if (ErrorHandlingMethod.REMOTE == this.appConfiguration.getErrorHandlingMethod()) {
                    String separator = ((String)postLogoutRedirectUri).contains("?") ? "&" : "?";
                    postLogoutRedirectUri = (String)postLogoutRedirectUri + separator + this.errorResponseFactory.getErrorAsQueryString((IErrorType)error, "", reason);
                }
                String redirectTo = EndSessionUtils.appendState((String)postLogoutRedirectUri, state);
                this.log.trace("Redirect error to {}", (Object)redirectTo);
                return Response.status((Response.Status)Response.Status.FOUND).location(new URI(redirectTo)).build();
            }
        }
        catch (URISyntaxException e) {
            this.log.error("Can't perform redirect", (Throwable)e);
        }
        this.log.trace("Return 400 - error {}, reason {}", (Object)error, (Object)reason);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)error, reason)).build();
    }

    private boolean allowPostLogoutRedirect(String postLogoutRedirectUri, String clientId) {
        boolean isOk;
        if (StringUtils.isBlank((CharSequence)postLogoutRedirectUri)) {
            this.log.trace("Post logout redirect is blank.");
            return false;
        }
        Boolean allowPostLogoutRedirectWithoutValidation = this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation();
        boolean bl = isOk = allowPostLogoutRedirectWithoutValidation != null && allowPostLogoutRedirectWithoutValidation != false && this.endSessionService.isUrlWhiteListed(postLogoutRedirectUri);
        if (isOk) {
            this.log.trace("Post logout redirect allowed by 'clientWhiteList' {}", (Object)this.appConfiguration.getClientWhiteList());
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)this.redirectionUriService.validatePostLogoutRedirectUri(clientId, postLogoutRedirectUri))) {
            this.log.trace("Post logout redirect allowed by client_id {}", (Object)clientId);
            return true;
        }
        this.log.trace("Post logout redirect is denied.");
        return false;
    }

    private SessionId validateSidRequestParameter(String sid, String postLogoutRedirectUri, String state, String clientId) {
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            SessionId sessionIdObject = this.sessionIdService.getSessionBySid(sid);
            if (sessionIdObject == null) {
                String reason = "sid parameter in request is not valid. Logout is rejected. sid parameter in request can be skipped or otherwise valid value must be provided.";
                this.log.error("sid parameter in request is not valid. Logout is rejected. sid parameter in request can be skipped or otherwise valid value must be provided.");
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "sid parameter in request is not valid. Logout is rejected. sid parameter in request can be skipped or otherwise valid value must be provided.", state, clientId));
            }
            return sessionIdObject;
        }
        return null;
    }

    public Jwt validateIdTokenHint(String idTokenHint, SessionId sidSession, String postLogoutRedirectUri, String state, String clientId) {
        boolean isIdTokenHintRequired = BooleanUtils.isTrue((Boolean)this.appConfiguration.getForceIdTokenHintPresence());
        if (isIdTokenHintRequired && StringUtils.isBlank((CharSequence)idTokenHint)) {
            String reason = "id_token_hint is not set";
            this.log.trace("id_token_hint is not set");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_REQUEST, "id_token_hint is not set", state, clientId));
        }
        if (StringUtils.isBlank((CharSequence)idTokenHint) && !isIdTokenHintRequired) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)idTokenHint) || isIdTokenHintRequired) {
            boolean isRejectEndSessionIfIdTokenExpired = this.appConfiguration.getRejectEndSessionIfIdTokenExpired();
            AuthorizationGrant tokenHintGrant = this.getTokenHintGrant(idTokenHint);
            if (tokenHintGrant == null && isRejectEndSessionIfIdTokenExpired) {
                String reason = "id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided.";
                this.log.trace("id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided.");
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided.", state, clientId));
            }
            return this.validateIdTokenJwt(tokenHintGrant, idTokenHint, sidSession, postLogoutRedirectUri, state, clientId);
        }
        return null;
    }

    private Jwt validateIdTokenJwt(AuthorizationGrant tokenHintGrant, String idTokenHint, SessionId sidSession, String postLogoutRedirectUri, String state, String clientId) {
        try {
            Jwt jwt = Jwt.parse((String)idTokenHint);
            if (tokenHintGrant != null) {
                this.log.debug("Found id_token in db.");
                return jwt;
            }
            this.validateIdTokenSignature(sidSession, jwt, postLogoutRedirectUri, state, clientId);
            this.log.debug("id_token is validated successfully.");
            return jwt;
        }
        catch (InvalidJwtException e) {
            this.log.error("Unable to parse id_token_hint as JWT.", (Throwable)e);
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "Unable to parse id_token_hint as JWT.", state, clientId));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Unable to validate id_token_hint as JWT.", (Throwable)e);
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "Unable to validate id_token_hint as JWT.", state, clientId));
        }
    }

    private void validateIdTokenSignature(SessionId sidSession, Jwt jwt, String postLogoutRedirectUri, String state, String clientId) throws InvalidJwtException, CryptoProviderException {
        if (!this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), null, null, jwt.getHeader().getSignatureAlgorithm())) {
            this.log.error("id_token signature verification failed.");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "id_token signature verification failed.", state, clientId));
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getAllowEndSessionWithUnmatchedSid())) {
            return;
        }
        String sidClaim = jwt.getClaims().getClaimAsString("sid");
        if (sidSession != null && StringUtils.equals((CharSequence)sidSession.getOutsideSid(), (CharSequence)sidClaim)) {
            return;
        }
        this.log.error("sid claim from id_token does not match to any valid session on AS.");
        throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "sid claim from id_token does not match to any valid session on AS.", state, clientId));
    }

    protected AuthorizationGrant getTokenHintGrant(String idTokenHint) {
        if (StringUtils.isBlank((CharSequence)idTokenHint)) {
            return null;
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(TokenHashUtil.hash(idTokenHint));
        if (authorizationGrant != null) {
            return authorizationGrant;
        }
        authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant != null) {
            return authorizationGrant;
        }
        Boolean endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken();
        if (endSessionWithAccessToken != null && endSessionWithAccessToken.booleanValue()) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(idTokenHint);
        }
        return null;
    }

    protected String validatePostLogoutRedirectUri(String postLogoutRedirectUri, Pair<SessionId, AuthorizationGrant> pair, String state, String clientId) {
        try {
            String result;
            if (StringUtils.isBlank((CharSequence)postLogoutRedirectUri)) {
                return "";
            }
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation()) && this.endSessionService.isUrlWhiteListed(postLogoutRedirectUri)) {
                this.log.trace("Skipped post_logout_redirect_uri validation (because allowPostLogoutRedirectWithoutValidation=true and it's white listed)");
                return postLogoutRedirectUri;
            }
            if (pair.getSecond() == null) {
                result = this.redirectionUriService.validatePostLogoutRedirectUri((SessionId)pair.getFirst(), postLogoutRedirectUri);
                this.log.trace("Validated post_logout_redirect_uri: {} against session: {}, result: {}", new Object[]{postLogoutRedirectUri, pair.getFirst(), result});
            } else {
                result = this.redirectionUriService.validatePostLogoutRedirectUri(((AuthorizationGrant)pair.getSecond()).getClient().getClientId(), postLogoutRedirectUri);
                this.log.trace("Validated post_logout_redirect_uri: {} against (pair) client: {}, result: {}", new Object[]{postLogoutRedirectUri, ((AuthorizationGrant)pair.getSecond()).getClient().getClientId(), result});
            }
            if (StringUtils.isBlank((CharSequence)result) && StringUtils.isNotBlank((CharSequence)clientId)) {
                result = this.redirectionUriService.validatePostLogoutRedirectUri(clientId, postLogoutRedirectUri);
                this.log.trace("Validated post_logout_redirect_uri: {} against client_id: {}, result: {}", new Object[]{postLogoutRedirectUri, clientId, result});
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                this.log.trace("Failed to validate post_logout_redirect_uri.");
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "", state, clientId));
            }
            if (StringUtils.isNotBlank((CharSequence)result)) {
                return result;
            }
            this.log.trace("Unable to validate post_logout_redirect_uri.");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "", state, clientId));
        }
        catch (WebApplicationException e) {
            if (pair.getFirst() != null) {
                this.log.debug(e.getMessage(), (Throwable)e);
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "", state, clientId));
            }
            throw e;
        }
    }

    private Response httpBased(Set<String> frontchannelUris, String postLogoutRedirectUri, String state, Pair<SessionId, AuthorizationGrant> pair, HttpServletRequest httpRequest) {
        try {
            EndSessionContext context = new EndSessionContext(httpRequest, frontchannelUris, postLogoutRedirectUri, (SessionId)pair.getFirst());
            String htmlFromScript = this.externalEndSessionService.getFrontchannelHtml(context);
            if (StringUtils.isNotBlank((CharSequence)htmlFromScript)) {
                this.log.debug("HTML from `getFrontchannelHtml` external script: {}", (Object)htmlFromScript);
                return this.okResponse(htmlFromScript);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        String html = EndSessionUtils.createFronthannelHtml(frontchannelUris, postLogoutRedirectUri, state);
        this.log.debug("Constructed html logout page: {}", (Object)html);
        return this.okResponse(html);
    }

    private Response okResponse(String html) {
        return Response.ok().cacheControl(ServerUtil.cacheControl(true, true)).header("Pragma", (Object)"no-cache").type(MediaType.TEXT_HTML_TYPE).entity((Object)html).build();
    }

    private Pair<SessionId, AuthorizationGrant> getPair(String idTokenHint, Jwt validatedIdToken, String sid, HttpServletRequest httpRequest) {
        Boolean endSessionWithAccessToken;
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant == null && (endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken()) != null && endSessionWithAccessToken.booleanValue()) {
            authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(idTokenHint);
        }
        SessionId sessionId = null;
        try {
            String sidClaim;
            String cookieSessionId = this.cookieService.getSessionIdFromCookie(httpRequest);
            if (StringHelper.isNotEmpty((String)cookieSessionId)) {
                sessionId = this.sessionIdService.getSessionId(cookieSessionId);
            }
            if (sessionId == null && StringUtils.isNotBlank((CharSequence)sid)) {
                sessionId = this.sessionIdService.getSessionBySid(sid);
            }
            if (sessionId == null && validatedIdToken != null && StringUtils.isNotBlank((CharSequence)(sidClaim = validatedIdToken.getClaims().getClaimAsString("sid")))) {
                sessionId = this.sessionIdService.getSessionBySid(sidClaim);
            }
            if (sessionId == null) {
                this.log.trace("Unable to find session for ending.");
            } else {
                this.log.trace("Found session for ending successfully.");
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find current session id.", (Throwable)e);
        }
        return new Pair(sessionId, (Object)authorizationGrant);
    }

    private void endSession(Pair<SessionId, AuthorizationGrant> pair, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        boolean isGrantAndExternalLogoutSuccessful;
        this.removeConsentSessionId(httpRequest, httpResponse);
        this.removeSessionId(pair, httpResponse);
        boolean externalLogoutResult = false;
        boolean isExternalLogoutPresent = this.externalApplicationSessionService.isEnabled();
        if (isExternalLogoutPresent) {
            String userName = (String)((SessionId)pair.getFirst()).getSessionAttributes().get("auth_user");
            externalLogoutResult = this.externalApplicationSessionService.executeExternalEndSessionMethods(httpRequest, (SessionId)pair.getFirst());
            this.log.info("End session result for '{}': '{}'", (Object)userName, (Object)externalLogoutResult);
        }
        boolean bl = isGrantAndExternalLogoutSuccessful = isExternalLogoutPresent && externalLogoutResult;
        if (isExternalLogoutPresent && !isGrantAndExternalLogoutSuccessful) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)EndSessionErrorResponseType.INVALID_GRANT, "External logout is present but executed external logout script returned failed result.");
        }
        this.grantService.logout(((SessionId)pair.getFirst()).getDn());
        if (this.identity != null) {
            this.identity.logout();
        }
    }

    private Set<Client> getSsoClients(Pair<SessionId, AuthorizationGrant> pair) {
        HashSet clients;
        SessionId sessionId = (SessionId)pair.getFirst();
        AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getSecond();
        if (sessionId == null) {
            this.log.error("session_id is not passed to endpoint (as cookie or manually). Therefore unable to match clients for session_id.");
            return Sets.newHashSet();
        }
        Set<Object> set = clients = sessionId.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionId.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        if (authorizationGrant != null) {
            clients.add(authorizationGrant.getClient());
        }
        return clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionId(Pair<SessionId, AuthorizationGrant> pair, HttpServletResponse httpResponse) {
        try {
            boolean result = this.sessionIdService.remove((SessionId)pair.getFirst());
            if (!result) {
                this.log.error("Failed to remove session_id '{}'", (Object)((SessionId)pair.getFirst()).getId());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cookieService.removeSessionIdCookie(httpResponse);
            this.cookieService.removeOPBrowserStateCookie(httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsentSessionId(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String id = this.cookieService.getConsentSessionIdFromCookie(httpRequest);
            if (StringHelper.isNotEmpty((String)id)) {
                SessionId dbSessionId = this.sessionIdService.getSessionId(id);
                if (dbSessionId != null) {
                    boolean result = this.sessionIdService.remove(dbSessionId);
                    if (!result) {
                        this.log.error("Failed to remove consent_session_id '{}'", (Object)id);
                    }
                } else {
                    this.log.error("Failed to load session by consent_session_id: '{}'", (Object)id);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cookieService.removeConsentSessionIdCookie(httpResponse);
        }
    }

    private void auditLogging(HttpServletRequest request, Pair<SessionId, AuthorizationGrant> pair) {
        SessionId sessionId = (SessionId)pair.getFirst();
        AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getSecond();
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.SESSION_DESTROYED);
        oAuth2AuditLog.setSuccess(true);
        if (authorizationGrant != null) {
            oAuth2AuditLog.setClientId(authorizationGrant.getClientId());
            oAuth2AuditLog.setScope(StringUtils.join(authorizationGrant.getScopes(), (String)" "));
            oAuth2AuditLog.setUsername(authorizationGrant.getUserId());
        } else if (sessionId != null) {
            oAuth2AuditLog.setClientId(sessionId.getPermissionGrantedMap().getClientIds(true).toString());
            oAuth2AuditLog.setScope((String)sessionId.getSessionAttributes().get("scope"));
            oAuth2AuditLog.setUsername(sessionId.getUserDn());
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
    }
}

