/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.session.ws.rs;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.userinfo.UserInfoErrorResponseType;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.DefaultScope;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalApplicationSessionService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/session")
public class SessionRestWebService {
    @Inject
    private Logger log;
    @Inject
    private TokenService tokenService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;

    @POST
    @Path(value="/active")
    @Produces(value={"application/json"})
    public Response requestActiveSessions(@HeaderParam(value="Authorization") String authorization, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context SecurityContext securityContext) {
        try {
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.ACTIVE_SESSION);
            AuthorizationGrant grant = this.validateToken(this.getToken(authorization));
            ExecutionContext executionContext = new ExecutionContext(request, response);
            executionContext.setGrant(grant);
            List<SessionId> sessionIdList = this.getUserSessions(grant);
            executionContext.setUserSessions(sessionIdList);
            JSONArray jsonArray = this.createJsonArray(executionContext);
            if (!this.externalApplicationSessionService.modifyActiveSessionsResponse(jsonArray, executionContext)) {
                this.log.trace("Successfully run external modifyActiveSessionsResponse scripts.");
            } else {
                jsonArray = this.createJsonArray(executionContext);
                this.log.trace("Canceled changes made by external modifyActiveSessionsResponse script since method returned `false`.");
            }
            return Response.ok().cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate()).header("Pragma", (Object)"no-cache").type(MediaType.APPLICATION_JSON_TYPE).entity((Object)jsonArray.toString()).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<SessionId> getUserSessions(AuthorizationGrant grant) {
        String userDn = grant.getUserDn();
        if (StringUtils.isBlank((CharSequence)userDn)) {
            this.log.warn("User DN is not set in grant object, grant id: {}", (Object)grant.getGrantId());
            return new ArrayList<SessionId>();
        }
        return this.sessionIdService.findByUser(grant.getUserDn());
    }

    private JSONArray createJsonArray(ExecutionContext executionContext) {
        JSONArray result = new JSONArray();
        for (SessionId sessionId : executionContext.getUserSessions()) {
            result.put((Object)this.createJsonObject(sessionId));
        }
        return result;
    }

    private JSONObject createJsonObject(SessionId sessionId) {
        Date exp = sessionId.getExpirationDate();
        Date iat = sessionId.getCreationDate();
        Date lastUsedAt = sessionId.getLastUsedAt();
        String sid = sessionId.getOutsideSid();
        Date authnTime = sessionId.getAuthenticationTime();
        JSONObject result = new JSONObject();
        if (lastUsedAt != null) {
            result.put("last_used_at", SessionRestWebService.dateAsSeconds(lastUsedAt));
        }
        if (iat != null) {
            result.put("iat", SessionRestWebService.dateAsSeconds(iat));
        }
        if (exp != null) {
            result.put("exp", SessionRestWebService.dateAsSeconds(exp));
        }
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            result.put("sid", (Object)sid);
        }
        if (authnTime != null) {
            result.put("authn_time", (Object)sid);
        }
        return result;
    }

    private static int dateAsSeconds(Date date) {
        if (date == null) {
            return -1;
        }
        return (int)(date.getTime() / 1000L);
    }

    private AuthorizationGrant validateToken(String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new WebApplicationException(this.response(Response.Status.BAD_REQUEST, UserInfoErrorResponseType.INVALID_TOKEN));
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
        if (authorizationGrant == null) {
            this.log.trace("Failed to find authorization grant by access_token: {}", (Object)accessToken);
            throw new WebApplicationException(this.response(Response.Status.UNAUTHORIZED, UserInfoErrorResponseType.INVALID_TOKEN));
        }
        AbstractToken accessTokenObject = authorizationGrant.getAccessToken(accessToken);
        if (accessTokenObject == null || !accessTokenObject.isValid()) {
            this.log.trace("Invalid access token object, access_token: {}, isNull: {}, isValid: {}", new Object[]{accessToken, accessTokenObject == null, false});
            throw new WebApplicationException(this.response(Response.Status.UNAUTHORIZED, UserInfoErrorResponseType.INVALID_TOKEN));
        }
        Set<String> scopes = authorizationGrant.getScopes();
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getOpenidScopeBackwardCompatibility()) && !scopes.contains(DefaultScope.OPEN_ID.toString())) {
            throw new WebApplicationException(this.response(Response.Status.FORBIDDEN, UserInfoErrorResponseType.INSUFFICIENT_SCOPE));
        }
        String requiredScope = this.appConfiguration.getActiveSessionAuthorizationScope();
        if (StringUtils.isNotBlank((CharSequence)requiredScope) && !scopes.contains(requiredScope)) {
            this.log.trace("Required scope {} is not present.", (Object)requiredScope);
            throw new WebApplicationException(this.response(Response.Status.FORBIDDEN, UserInfoErrorResponseType.INSUFFICIENT_SCOPE));
        }
        return authorizationGrant;
    }

    private Response response(Response.Status status, UserInfoErrorResponseType errorResponseType) {
        return Response.status((Response.Status)status).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)errorResponseType, null)).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate()).build();
    }

    private String getToken(String authorization) {
        if (this.tokenService.isBearerAuthToken(authorization)) {
            return this.tokenService.getBearerToken(authorization);
        }
        return null;
    }
}

