/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs;

import io.jans.as.server.ssa.ws.rs.SsaRestWebService;
import io.jans.as.server.ssa.ws.rs.action.SsaCreateAction;
import io.jans.as.server.ssa.ws.rs.action.SsaGetAction;
import io.jans.as.server.ssa.ws.rs.action.SsaGetJwtAction;
import io.jans.as.server.ssa.ws.rs.action.SsaRevokeAction;
import io.jans.as.server.ssa.ws.rs.action.SsaValidateAction;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/")
public class SsaRestWebServiceImpl
implements SsaRestWebService {
    @Inject
    private SsaCreateAction ssaCreateAction;
    @Inject
    private SsaGetAction ssaGetAction;
    @Inject
    private SsaValidateAction ssaValidateAction;
    @Inject
    private SsaRevokeAction ssaRevokeAction;
    @Inject
    private SsaGetJwtAction ssaGetJwtAction;
    @Inject
    private Logger log;

    @Override
    public Response create(String requestParams, HttpServletRequest httpRequest) {
        return this.ssaCreateAction.create(requestParams, httpRequest);
    }

    @Override
    public Response get(String jti, String orgId, HttpServletRequest httpRequest) {
        return this.ssaGetAction.get(jti, orgId, httpRequest);
    }

    @Override
    public Response validate(String jti) {
        Response r = this.ssaValidateAction.validate(jti);
        this.log.debug("{}", r.getEntity());
        return r;
    }

    @Override
    public Response revoke(String jti, String orgId, HttpServletRequest httpRequest) {
        return this.ssaRevokeAction.revoke(jti, orgId, httpRequest);
    }

    @Override
    public Response getSsaJwtByJti(String jti) {
        return this.ssaGetJwtAction.getJwtSsa(jti);
    }
}

