/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs;

import io.jans.as.client.ssa.create.SsaCreateRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.common.model.ssa.SsaState;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.ssa.ws.rs.SsaService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Named
@Stateless
public class SsaRestWebServiceValidator {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private Identity identity;
    @Inject
    private ScopeService scopeService;
    @Inject
    private SsaService ssaService;

    public Client getClientFromSession() throws WebApplicationException {
        SessionClient sessionClient = this.identity.getSessionClient();
        if (sessionClient != null) {
            this.log.debug("Client: {}, obtained from session", (Object)sessionClient.getClient().getClientId());
            return sessionClient.getClient();
        }
        throw this.errorResponseFactory.createBadRequestException((IErrorType)SsaErrorResponseType.INVALID_CLIENT, "Invalid client");
    }

    public void checkScopesPolicy(Client client, String scope) throws WebApplicationException {
        List<String> scopes = this.scopeService.getScopeIdsByDns(Arrays.stream(client.getScopes()).collect(Collectors.toList()));
        if (!scopes.contains(scope)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)SsaErrorResponseType.UNAUTHORIZED_CLIENT, "Unauthorized client");
        }
    }

    public void checkScopesPolicy(Client client, List<String> scopeList) throws WebApplicationException {
        if (client == null || scopeList == null || scopeList.isEmpty()) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)SsaErrorResponseType.UNAUTHORIZED_CLIENT, "Unauthorized client");
        }
        List<String> scopes = this.scopeService.getScopeIdsByDns(Arrays.stream(client.getScopes()).collect(Collectors.toList()));
        if (scopeList.stream().noneMatch(scopes::contains)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)SsaErrorResponseType.UNAUTHORIZED_CLIENT, "Unauthorized client");
        }
    }

    public Ssa getValidSsaByJti(String jti) {
        Ssa ssa = this.ssaService.findSsaByJti(jti);
        if (ssa == null || Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime().after(ssa.getExpirationDate()) || !ssa.getState().equals((Object)SsaState.ACTIVE)) {
            this.log.warn("Ssa jti: '{}' is null or status (expired, used or revoked)", (Object)jti);
            throw this.errorResponseFactory.createBadRequestException((IErrorType)SsaErrorResponseType.INVALID_JTI, "Invalid JTI or not exists");
        }
        return ssa;
    }

    public void validateSsaCreateRequest(SsaCreateRequest createRequest) {
        if (createRequest.getLifetime() != null && createRequest.getLifetime() < 1) {
            this.log.warn("SSA Metadata validation: 'lifetime' cannot be 0 or negative");
            throw this.errorResponseFactory.createBadRequestException((IErrorType)SsaErrorResponseType.INVALID_SSA_METADATA, "Invalid SSA Metadata");
        }
    }
}

