/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs;

import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.common.model.ssa.SsaState;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.ssa.SsaRequestParam;
import io.jans.as.model.ssa.SsaScopeType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.util.StringUtils;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class SsaService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public void persist(Ssa ssa) {
        this.persistenceEntryManager.persist((Object)ssa);
    }

    public void merge(Ssa ssa) {
        this.persistenceEntryManager.merge((Object)ssa);
    }

    public Ssa findSsaByJti(String jti) {
        try {
            return (Ssa)this.persistenceEntryManager.find(Ssa.class, (Object)this.getDnForSsa(jti));
        }
        catch (EntryPersistenceException e) {
            return null;
        }
    }

    public List<Ssa> getSsaList(String jti, String orgId, SsaState status, String clientId, String[] scopes) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.hasDeveloperScope(Arrays.asList(scopes))) {
            filters.add(Filter.createEqualityFilter((String)"creatorId", (Object)clientId));
        }
        if (jti != null) {
            filters.add(Filter.createEqualityFilter((String)"inum", (Object)jti));
        }
        if (orgId != null) {
            filters.add(Filter.createEqualityFilter((String)"o", (Object)orgId));
        }
        if (status != null) {
            filters.add(Filter.createEqualityFilter((String)"jansState", (Object)status));
        }
        Filter filter = null;
        if (!filters.isEmpty()) {
            filter = Filter.createANDFilter(filters);
            this.log.trace("Filter with AND created: " + filters);
        }
        return this.persistenceEntryManager.findEntries(this.getDnForSsa(null), Ssa.class, filter);
    }

    public Jwt generateJwt(Ssa ssa, ExecutionContext executionContext) throws Exception {
        Jwt jwt = this.generateJwt(ssa);
        if (executionContext.getPostProcessor() != null) {
            executionContext.getPostProcessor().apply((JsonWebResponse)jwt);
        }
        return jwt;
    }

    public Jwt generateJwt(Ssa ssa) throws CryptoProviderException, InvalidJwtException {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getSsaConfiguration().getSsaSigningAlg());
        if (signatureAlgorithm == null) {
            this.log.error("Invalid signature algorithm, not found: {}", (Object)this.appConfiguration.getSsaConfiguration().getSsaSigningAlg());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)SsaErrorResponseType.INVALID_SIGNATURE, "Invalid signature error");
        }
        String keyId = this.cryptoProvider.getKeyId((JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm.getAlg(), Use.SIGNATURE, KeyOpsType.SSA);
        if (keyId == null) {
            this.log.error("Invalid keyId, not found: {}", (Object)this.appConfiguration.getSsaConfiguration().getSsaSigningAlg());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)SsaErrorResponseType.INVALID_SIGNATURE, "Invalid signature error");
        }
        Jwt jwt = new Jwt();
        jwt.getHeader().setType(JwtType.JWT);
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        jwt.getHeader().setKeyId(keyId);
        this.fillPayload(jwt.getClaims(), ssa);
        String signature = this.cryptoProvider.sign(jwt.getSigningInput(), jwt.getHeader().getKeyId(), null, signatureAlgorithm);
        jwt.setEncodedSignature(signature);
        return jwt;
    }

    public void fillPayload(JwtClaims claims, Ssa ssa) {
        claims.setJwtId(ssa.getId());
        claims.setIssuedAt(ssa.getCreationDate());
        claims.setExpirationTime(ssa.getExpirationDate());
        claims.setIssuer(this.appConfiguration.getIssuer());
        claims.setClaim(SsaRequestParam.SOFTWARE_ID.getName(), ssa.getAttributes().getSoftwareId());
        claims.setClaim(SsaRequestParam.ORG_ID.getName(), ssa.getOrgId());
        claims.setClaim(SsaRequestParam.SOFTWARE_ROLES.getName(), ssa.getAttributes().getSoftwareRoles());
        claims.setClaim(SsaRequestParam.GRANT_TYPES.getName(), ssa.getAttributes().getGrantTypes());
        claims.setClaim(SsaRequestParam.LIFETIME.getName(), ssa.getAttributes().getLifetime());
        if (CollectionUtils.isNotEmpty((Collection)ssa.getAttributes().getScopes())) {
            claims.setClaim(SsaRequestParam.SCOPE.getName(), StringUtils.implode((Collection)ssa.getAttributes().getScopes(), (String)" "));
        }
        if (!ssa.getAttributes().getCustomAttributes().isEmpty()) {
            ssa.getAttributes().getCustomAttributes().forEach((key, value) -> claims.setClaim(key, value));
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Claims: {}", (Object)claims.toJsonString());
            }
        }
        catch (InvalidJwtException invalidJwtException) {
            // empty catch block
        }
    }

    public Response.ResponseBuilder createUnprocessableEntityResponse() {
        return Response.status((int)422).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public Response.ResponseBuilder createNotAcceptableResponse() {
        return Response.status((int)406).type(MediaType.APPLICATION_JSON_TYPE);
    }

    private boolean hasDeveloperScope(List<String> scopes) {
        Iterator<String> scopesIterator = scopes.iterator();
        boolean result = false;
        while (scopesIterator.hasNext()) {
            String scope = scopesIterator.next();
            if (scope.equals(SsaScopeType.SSA_ADMIN.getValue()) || scope.equals(SsaScopeType.SSA_PORTAL.getValue())) {
                return false;
            }
            if (!scope.equals(SsaScopeType.SSA_DEVELOPER.getValue())) continue;
            result = true;
        }
        return result;
    }

    private String getDnForSsa(String ssaId) {
        String baseDn = this.staticConfiguration.getBaseDn().getSsa();
        if (StringHelper.isEmpty((String)ssaId)) {
            return baseDn;
        }
        return String.format("inum=%s,%s", ssaId, baseDn);
    }
}

