/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs.action;

import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.common.model.ssa.SsaState;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.server.ssa.ws.rs.SsaRestWebServiceValidator;
import io.jans.as.server.ssa.ws.rs.SsaService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Stateless
@Named
public class SsaValidateAction {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SsaService ssaService;
    @Inject
    private SsaRestWebServiceValidator ssaRestWebServiceValidator;

    public Response validate(String jti) throws WebApplicationException {
        this.log.debug("Attempting to validate ssa jti: '{}'", (Object)jti);
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.SSA);
        Response.ResponseBuilder builder = Response.ok();
        try {
            Ssa ssa = this.ssaRestWebServiceValidator.getValidSsaByJti(jti);
            if (ssa.getAttributes().getOneTimeUse().booleanValue()) {
                ssa.setState(SsaState.USED);
                this.ssaService.merge(ssa);
                this.log.info("Ssa jti: '{}', updated with status: {}", (Object)ssa.getId(), (Object)ssa.getState());
            }
        }
        catch (WebApplicationException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)SsaErrorResponseType.UNKNOWN_ERROR, "Unknown error");
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        return builder.build();
    }
}

