/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.token.ws.rs;

import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.common.ExchangeTokenType;
import io.jans.as.model.common.SubjectTokenType;
import io.jans.as.model.common.TokenType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJweException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweEncrypterImpl;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.Base64Util;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.TokenExchangeGrant;
import io.jans.as.server.model.common.TxToken;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ServerCryptoProvider;
import io.jans.as.server.token.ws.rs.TxTokenValidator;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.token.TokenEntity;
import io.jans.util.security.StringEncrypter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class TxTokenService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private TxTokenValidator txTokenValidator;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ClientService clientService;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private AuthorizationGrantList authorizationGrantList;

    public Response processTxToken(ExecutionContext executionContext) throws Exception {
        JSONObject responseJson = this.process(executionContext);
        String entity = responseJson.toString();
        this.log.trace("Created TxToken: {}", (Object)entity);
        return this.response(Response.ok().entity((Object)entity), executionContext.getAuditLog());
    }

    private JSONObject process(ExecutionContext executionContext) throws Exception {
        String requestedTokenType = executionContext.getHttpRequest().getParameter("requested_token_type");
        String subjectToken = executionContext.getHttpRequest().getParameter("subject_token");
        String subjectTokenType = executionContext.getHttpRequest().getParameter("subject_token_type");
        this.txTokenValidator.validateRequestedTokenType(requestedTokenType, executionContext.getAuditLog());
        SubjectTokenType subjectTokenTypeEnum = this.txTokenValidator.validateSubjectTokenType(subjectTokenType, executionContext.getAuditLog());
        AuthorizationGrant subjectGrant = this.txTokenValidator.validateSubjectToken(subjectToken, subjectTokenTypeEnum, executionContext.getAuditLog());
        TxToken txToken = this.createTxToken(executionContext, subjectGrant);
        return TxTokenService.createResponse(txToken.getCode());
    }

    public static JSONObject createResponse(String txToken) {
        JSONObject responseJson = new JSONObject();
        responseJson.put("issued_token_type", (Object)ExchangeTokenType.TX_TOKEN.getName());
        responseJson.put("token_type", (Object)TokenType.N_A.getName());
        responseJson.put("access_token", (Object)txToken);
        return responseJson;
    }

    private TxToken createTxToken(ExecutionContext executionContext, AuthorizationGrant subjectGrant) throws Exception {
        String audience = executionContext.getHttpRequest().getParameter("audience");
        String requestContext = executionContext.getHttpRequest().getParameter("request_context");
        String requestDetails = executionContext.getHttpRequest().getParameter("request_details");
        String scope = executionContext.getHttpRequest().getParameter("scope");
        Client client = executionContext.getClient();
        TokenExchangeGrant txTokenGrant = this.authorizationGrantList.createTokenExchangeGrant(new User(), client);
        txTokenGrant.checkScopesPolicy(scope);
        executionContext.setGrant(txTokenGrant);
        JsonWebResponse jwr = this.createTxTokenJwr(audience, requestContext, requestDetails, executionContext, subjectGrant);
        String jwrString = jwr.toString();
        int txTokenLifetime = this.getTxTokenLifetime(client);
        TxToken txToken = new TxToken(txTokenLifetime);
        txToken.setCode(jwrString);
        TokenEntity tokenEntity = txTokenGrant.asToken(txToken);
        txTokenGrant.persist(tokenEntity);
        return txToken;
    }

    private void fillPayload(JsonWebResponse jwr, String audience, String requestContext, String requestDetails, ExecutionContext executionContext, AuthorizationGrant authorizationGrant) {
        JSONObject azd;
        JSONObject requestContextObj;
        Client client = executionContext.getClient();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, this.getTxTokenLifetime(client));
        Date expiration = calendar.getTime();
        jwr.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwr.getClaims().setExpirationTime(expiration);
        jwr.getClaims().setIat(issuedAt);
        jwr.getClaims().setNbf(issuedAt);
        jwr.setClaim("txn", UUID.randomUUID().toString());
        jwr.setClaim("sub", UUID.randomUUID().toString());
        jwr.setClaim("purp", JwtType.TX_TOKEN.toString());
        Audience.setAudience((JwtClaims)jwr.getClaims(), (Client)client);
        if (StringUtils.isNotBlank((CharSequence)audience)) {
            jwr.getClaims().addAudience(audience);
        }
        if ((requestContextObj = TxTokenService.decodeJson(requestContext)) != null) {
            jwr.getClaims().setClaim("rctx", requestContextObj);
        }
        if (authorizationGrant != null) {
            jwr.setClaim("sub", authorizationGrant.getSub());
        }
        if ((azd = TxTokenService.decodeJson(requestDetails)) == null) {
            azd = new JSONObject();
        }
        azd.put("client_id", (Object)client.getClientId());
        jwr.getClaims().setClaim("azd", azd);
    }

    private static JSONObject decodeJson(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException e) {
            String decoded = Base64Util.base64urldecodeToString((String)jsonString);
            return new JSONObject(decoded);
        }
    }

    private int getTxTokenLifetime(Client client) {
        if (client.getAttributes().getTxTokenLifetime() != null && client.getAttributes().getTxTokenLifetime() > 0) {
            this.log.trace("Override TxToken lifetime with value {} from client: {}", (Object)client.getAttributes().getTxTokenLifetime(), (Object)client.getClientId());
            return client.getAttributes().getTxTokenLifetime();
        }
        return this.appConfiguration.getTxTokenLifetime();
    }

    private Jwt signJwt(Jwt jwt, Client client) throws Exception {
        JwtSigner jwtSigner = this.newJwtSigner(client);
        jwtSigner.setJwt(jwt);
        jwtSigner.sign();
        return jwt;
    }

    private JwtSigner newJwtSigner(Client client) throws StringEncrypter.EncryptionException {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAttributes().getTxTokenSignedResponseAlg() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAttributes().getTxTokenSignedResponseAlg());
        }
        return new JwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    public boolean isTxTokenFlow(HttpServletRequest httpRequest) {
        return TxTokenService.isTxTokenFlow(httpRequest.getParameter("requested_token_type"));
    }

    public static boolean isTxTokenFlow(String requestedTokenType) {
        ExchangeTokenType exchangeTokenType = ExchangeTokenType.fromString((String)requestedTokenType);
        return exchangeTokenType == ExchangeTokenType.TX_TOKEN;
    }

    public Response.ResponseBuilder error(int status, TokenErrorResponseType type, String reason) {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)type, reason));
    }

    private JsonWebResponse createTxTokenJwr(String audience, String requestContext, String requestDetails, ExecutionContext executionContext, AuthorizationGrant authorizationGrant) throws Exception {
        Client client = executionContext.getClient();
        KeyEncryptionAlgorithm keyAlgorithm = KeyEncryptionAlgorithm.fromName((String)client.getAttributes().getTxTokenEncryptedResponseAlg());
        BlockEncryptionAlgorithm blockAlgorithm = BlockEncryptionAlgorithm.fromName((String)client.getAttributes().getTxTokenEncryptedResponseEnc());
        if (keyAlgorithm != null && blockAlgorithm != null) {
            this.log.trace("Preparing encrypted TxToken with keyEncryptionAlgorithm {}, blockEncryptionAlgorithm: {}", (Object)keyAlgorithm, (Object)blockAlgorithm);
            Jwe jwe = new Jwe();
            jwe.getHeader().setType(JwtType.TX_TOKEN);
            jwe.getHeader().setAlgorithm(keyAlgorithm);
            jwe.getHeader().setEncryptionMethod(blockAlgorithm);
            this.fillPayload((JsonWebResponse)jwe, audience, requestContext, requestDetails, executionContext, authorizationGrant);
            JwtSigner jwtSigner = this.newJwtSigner(client);
            Jwt jwt = jwtSigner.newJwt();
            jwt.setClaims(jwe.getClaims());
            jwe.setSignedJWTPayload(this.signJwt(jwt, client));
            if (keyAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
                JSONObject jsonWebKeys = CommonUtils.getJwks((Client)client);
                String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyAlgorithm.getName()), Use.ENCRYPTION, KeyOpsType.CONNECT);
                PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys, null);
                jwe.getHeader().setKeyId(keyId);
                if (publicKey == null) {
                    throw new InvalidJweException("The public key is not valid");
                }
                JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyAlgorithm, blockAlgorithm, publicKey);
                return jweEncrypter.encrypt(jwe);
            }
            if (keyAlgorithm == KeyEncryptionAlgorithm.A128KW || keyAlgorithm == KeyEncryptionAlgorithm.A256KW) {
                byte[] sharedSymmetricKey = this.clientService.decryptSecret(client.getClientSecret()).getBytes(StandardCharsets.UTF_8);
                JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyAlgorithm, blockAlgorithm, sharedSymmetricKey);
                return jweEncrypter.encrypt(jwe);
            }
        }
        this.log.trace("Preparing signed TxToken, client {}", (Object)client.getClientId());
        JwtSigner jwtSigner = this.newJwtSigner(client);
        Jwt jwt = jwtSigner.newJwt();
        jwt.getHeader().setType(JwtType.TX_TOKEN);
        this.fillPayload((JsonWebResponse)jwt, audience, requestContext, requestDetails, executionContext, authorizationGrant);
        return jwtSigner.sign();
    }
}

