/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.authorization;

import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataEntry
@ObjectClass(value="jansUmaPCT")
public class UmaPCT
extends AbstractToken {
    private static final Logger log = LoggerFactory.getLogger(UmaPCT.class);
    @DN
    private String dn;
    @AttributeName(name="clnId")
    private String clientId;
    @AttributeName(name="jansClaimValues")
    private String claimValuesAsJson;

    public UmaPCT() {
        super(2592000);
    }

    public UmaPCT(int lifeTime) {
        super(lifeTime);
    }

    protected UmaPCT(String code, Date creationDate, Date expirationDate) {
        super(code, creationDate, expirationDate);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClaimValuesAsJson() {
        return this.claimValuesAsJson;
    }

    public void setClaimValuesAsJson(String claimValuesAsJson) {
        this.claimValuesAsJson = claimValuesAsJson;
    }

    public JwtClaims getClaims() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.claimValuesAsJson) ? new JwtClaims(new JSONObject(this.claimValuesAsJson)) : new JwtClaims();
        }
        catch (Exception e) {
            log.error("Failed to parse PCT claims. " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setClaims(JwtClaims claims) throws InvalidJwtException {
        this.claimValuesAsJson = claims != null ? claims.toJsonString() : null;
    }
}

