/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import com.google.common.collect.Lists;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.JsonLogic;
import io.jans.as.model.uma.JsonLogicNode;
import io.jans.as.model.uma.JsonLogicNodeParser;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.persistence.UmaPermission;
import io.jans.as.model.uma.persistence.UmaResource;
import io.jans.as.model.util.Util;
import io.jans.as.server.service.external.ExternalUmaRptPolicyService;
import io.jans.as.server.uma.authorization.UmaAuthorizationContext;
import io.jans.as.server.uma.authorization.UmaScriptByScope;
import io.jans.as.server.uma.service.UmaPermissionService;
import io.jans.as.server.uma.service.UmaResourceService;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaExpressionService {
    @Inject
    private Logger log;
    @Inject
    private ExternalUmaRptPolicyService policyService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private UmaPermissionService permissionService;

    private static Map<String, String> scopeIdToDnMap(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, List<String> scriptDNs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            if (!scriptDNs.contains(entry.getKey().getScope().getDn())) continue;
            result.put(entry.getKey().getScope().getId(), entry.getKey().getScope().getDn());
        }
        return result;
    }

    private static Map<UmaScriptByScope, UmaAuthorizationContext> filterByScopeDns(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, List<String> scopeDNs) {
        HashMap<UmaScriptByScope, UmaAuthorizationContext> result = new HashMap<UmaScriptByScope, UmaAuthorizationContext>();
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            if (!scopeDNs.contains(entry.getKey().getScope().getDn())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean isExpressionValid(String expression) {
        return JsonLogicNodeParser.isNodeValid((String)expression);
    }

    public void evaluate(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, List<UmaPermission> permissions) {
        for (UmaPermission permission : permissions) {
            UmaResource resource = this.resourceService.getResourceById(permission.getResourceId());
            if (StringHelper.isNotEmpty((String)resource.getScopeExpression())) {
                this.evaluateScopeExpression(scriptMap, permission, resource);
                continue;
            }
            if (this.evaluateByScopes(UmaExpressionService.filterByScopeDns(scriptMap, permission.getScopeDns()))) continue;
            this.log.trace("Regular evaluation returns false, access FORBIDDEN.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Regular evaluation returns false, access FORBIDDEN.");
        }
    }

    private boolean evaluateByScopes(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap) {
        for (Map.Entry<UmaScriptByScope, UmaAuthorizationContext> entry : scriptMap.entrySet()) {
            boolean result = this.policyService.authorize(entry.getKey().getScript(), entry.getValue());
            this.log.trace("Policy script inum: '{}' result: '{}'", (Object)entry.getKey().getScript().getInum(), (Object)result);
            if (result) continue;
            this.log.trace("Stop authorization scriptMap execution, current script returns false, script inum: {}, scope: {}", (Object)entry.getKey().getScript().getInum(), (Object)entry.getKey().getScope());
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void evaluateScopeExpression(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, UmaPermission permission, UmaResource resource) {
        String scopeExpression = resource.getScopeExpression();
        JsonLogicNode node = JsonLogicNodeParser.parseNode((String)scopeExpression);
        if (node != null) {
            this.log.trace("Evaluating scope expression ...");
            List dataScopes = node.getDataCopy();
            Map<String, String> scopeIdToDnMap = UmaExpressionService.scopeIdToDnMap(scriptMap, permission.getScopeDns());
            if (dataScopes.size() == scopeIdToDnMap.size()) {
                if (!this.evaluateScopeExpressionInternal(scriptMap, permission, resource, scopeExpression, node, dataScopes, scopeIdToDnMap)) throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Unknown");
                return;
            }
            this.log.error("Scope size in JsonLogic object 'data' and in permission differs which is forbidden. Node data: {}, permissionDns: {}, result scopeIds: {}", new Object[]{node, permission.getScopeDns(), scopeIdToDnMap});
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Scope size in JsonLogic object 'data' and in permission differs which is forbidden.");
        }
        this.log.error("Failed to parse JsonLogic object, invalid expression: {}", (Object)scopeExpression);
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Failed to parse JsonLogic object, invalid expression: " + scopeExpression);
    }

    private boolean evaluateScopeExpressionInternal(Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap, UmaPermission permission, UmaResource resource, String scopeExpression, JsonLogicNode node, List<String> dataScopes, Map<String, String> scopeIdToDnMap) {
        try {
            ArrayList<Boolean> evaluatedResults = new ArrayList<Boolean>();
            for (String scopeId : dataScopes) {
                this.log.trace("Evaluating scope result for scope: {}...", (Object)scopeId);
                boolean b = this.evaluateByScopes(UmaExpressionService.filterByScopeDns(scriptMap, Lists.newArrayList((Object[])new String[]{scopeIdToDnMap.get(scopeId)})));
                this.log.trace("Evaluated scope result: {}, scope: {}", (Object)b, (Object)scopeId);
                evaluatedResults.add(b);
            }
            String rule = node.getRule().toString();
            boolean result = evaluatedResults.isEmpty() ? JsonLogic.apply((String)rule) : JsonLogic.apply((String)rule, (String)Util.asJsonSilently(evaluatedResults));
            if (this.log.isTraceEnabled()) {
                this.log.trace("JsonLogic evaluation result: {}, rule: {}, data: {}", new Object[]{result, rule, Util.asJsonSilently(evaluatedResults)});
            }
            if (result) {
                this.removeFalseScopesFromPermission(permission, dataScopes, scopeIdToDnMap, evaluatedResults);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to evaluate jsonlogic expression. Expression: " + scopeExpression + ", resourceDn: " + resource.getDn(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Failed to evaluate jsonlogic expression.");
        }
        return false;
    }

    private void removeFalseScopesFromPermission(UmaPermission permission, List<String> dataScopes, Map<String, String> scopeIdToDnMap, List<Boolean> evaluatedResults) {
        if (!evaluatedResults.isEmpty() && permission.getScopeDns() != null) {
            ArrayList newPermissionScopes = new ArrayList(permission.getScopeDns());
            for (int i = 0; i < evaluatedResults.size(); ++i) {
                if (!BooleanUtils.isFalse((Boolean)evaluatedResults.get(i))) continue;
                String dnToRemove = scopeIdToDnMap.get(dataScopes.get(i));
                newPermissionScopes.remove(dnToRemove);
            }
            if (newPermissionScopes.size() < permission.getScopeDns().size()) {
                permission.setScopeDns(newPermissionScopes);
                this.permissionService.mergeSilently(permission);
            }
        }
    }
}

