/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.uma.persistence.UmaPermission;
import io.jans.as.server.i18n.LanguageBean;
import io.jans.as.server.service.external.ExternalUmaClaimsGatheringService;
import io.jans.as.server.uma.authorization.UmaGatherContext;
import io.jans.as.server.uma.service.UmaPctService;
import io.jans.as.server.uma.service.UmaPermissionService;
import io.jans.as.server.uma.service.UmaSessionService;
import io.jans.jsf2.service.FacesService;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@RequestScoped
@Named(value="gatherer")
public class UmaGatherer {
    private final Map<String, String> pageClaims = new HashMap<String, String>();
    @Inject
    private Logger log;
    @Inject
    private ExternalUmaClaimsGatheringService external;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private UmaSessionService umaSessionService;
    @Inject
    private UmaPermissionService umaPermissionService;
    @Inject
    private UmaPctService umaPctService;
    @Inject
    private UserService userService;

    public static String addQueryParameters(String url, String parameters) {
        if (StringUtils.isNotBlank((CharSequence)parameters)) {
            url = ((String)url).contains("?") ? (String)url + "&" + parameters : (String)url + "?" + parameters;
        }
        return url;
    }

    public static String addQueryParameter(String url, String paramName, String paramValue) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            url = ((String)url).contains("?") ? (String)url + "&" + paramName + "=" + paramValue : (String)url + "?" + paramName + "=" + paramValue;
        }
        return url;
    }

    public boolean gather() {
        try {
            int stepsCount;
            HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
            HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
            SessionId session = this.umaSessionService.getSession(httpRequest, httpResponse);
            CustomScriptConfiguration script = this.getScript(session);
            UmaGatherContext context = new UmaGatherContext(script.getConfigurationAttributes(), httpRequest, session, this.umaSessionService, this.umaPermissionService, this.umaPctService, this.pageClaims, this.appConfiguration);
            int step = this.umaSessionService.getStep(session);
            if (!this.umaSessionService.isPassedPreviousSteps(session, step)) {
                this.log.error("There are claims-gathering steps not marked as passed. scriptName: '{}', step: '{}'", (Object)script.getName(), (Object)step);
                return false;
            }
            boolean gatheredResult = this.external.gather(script, step, context);
            this.log.debug("Claims-gathering result for script '{}', step: '{}', gatheredResult: '{}'", new Object[]{script.getName(), step, gatheredResult});
            int overridenNextStep = this.external.getNextStep(script, step, context);
            if (!gatheredResult && overridenNextStep == -1) {
                return false;
            }
            if (overridenNextStep != -1) {
                this.umaSessionService.resetToStep(session, overridenNextStep, step);
                step = overridenNextStep;
            }
            if (step < (stepsCount = this.external.getStepsCount(script, context)) || overridenNextStep != -1) {
                int nextStep;
                if (overridenNextStep != -1) {
                    nextStep = overridenNextStep;
                } else {
                    nextStep = step + 1;
                    this.umaSessionService.markStep(session, step, true);
                }
                this.umaSessionService.setStep(nextStep, session);
                context.persist();
                String page = this.external.getPageForStep(script, nextStep, context);
                this.log.trace("Redirecting to page: '{}'", (Object)page);
                this.facesService.redirect(page);
                return true;
            }
            if (step == stepsCount) {
                context.persist();
                this.onSuccess(session, context);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Exception during gather() method call.", (Throwable)e);
        }
        this.log.error("Failed to perform gather() method successfully.");
        return false;
    }

    private void onSuccess(SessionId session, UmaGatherContext context) {
        List<UmaPermission> permissions = context.getPermissions();
        String newTicket = this.umaPermissionService.changeTicket(permissions, permissions.get(0).getAttributes());
        String url = this.constructRedirectUri(session, context, newTicket);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.facesService.redirectToExternalURL(url);
        } else {
            this.log.debug("Redirect to claims_redirect_uri is skipped because it was not provided during request.");
        }
    }

    private String constructRedirectUri(SessionId session, UmaGatherContext context, String newTicket) {
        String claimsRedirectUri = this.umaSessionService.getClaimsRedirectUri(session);
        if (StringUtils.isBlank((CharSequence)claimsRedirectUri)) {
            this.log.debug("claims_redirect_uri is blank, session: {}", (Object)session);
            return "";
        }
        claimsRedirectUri = UmaGatherer.addQueryParameters(claimsRedirectUri, context.getRedirectUserParameters().buildQueryString().trim());
        claimsRedirectUri = UmaGatherer.addQueryParameter(claimsRedirectUri, "state", this.umaSessionService.getState(session));
        claimsRedirectUri = UmaGatherer.addQueryParameter(claimsRedirectUri, "ticket", newTicket);
        return claimsRedirectUri;
    }

    public String prepareForStep() {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
            HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
            SessionId session = this.umaSessionService.getSession(httpRequest, httpResponse);
            if (session == null || session.getSessionAttributes().isEmpty()) {
                this.log.error("Invalid session.");
                return this.result("expired");
            }
            CustomScriptConfiguration script = this.getScript(session);
            if (script == null) {
                this.log.error("Failed to load script, session: '{}'", (Object)session.getId());
                return this.result("failure");
            }
            UmaGatherContext context = new UmaGatherContext(script.getConfigurationAttributes(), httpRequest, session, this.umaSessionService, this.umaPermissionService, this.umaPctService, this.pageClaims, this.appConfiguration);
            int step = this.umaSessionService.getStep(session);
            if (step < 1) {
                this.log.error("Invalid step: {}", (Object)step);
                return this.result("invalid_step");
            }
            if (!this.umaSessionService.isPassedPreviousSteps(session, step)) {
                this.log.error("There are claims-gathering steps not marked as passed. scriptName: '{}', step: '{}'", (Object)script.getName(), (Object)step);
                return this.result("failure");
            }
            boolean result = this.external.prepareForStep(script, step, context);
            if (result) {
                context.persist();
                return this.result("success");
            }
            String redirectToExternalUrl = context.getRedirectToExternalUrl();
            if (StringUtils.isNotBlank((CharSequence)redirectToExternalUrl)) {
                this.log.debug("Redirect to : {}", (Object)redirectToExternalUrl);
                this.facesService.redirectToExternalURL(redirectToExternalUrl);
                return redirectToExternalUrl;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to prepareForStep()", (Throwable)e);
        }
        return this.result("failure");
    }

    public String result(String resultCode) {
        if ("failure".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "uma2.gather.failed");
        } else if ("invalid_step".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "uma2.invalid.step");
        } else if ("expired".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "uma2.invalid.session");
        }
        return resultCode;
    }

    public void addMessage(FacesMessage.Severity severity, String summary) {
        String msg = this.languageBean.getMessage(summary);
        FacesMessage message = new FacesMessage(severity, msg, null);
        this.facesContext.addMessage(null, message);
    }

    public Map<String, String> getPageClaims() {
        return this.pageClaims;
    }

    protected CustomScriptConfiguration getScript(SessionId session) {
        String scriptName = this.umaSessionService.getScriptName(session);
        return this.external.getCustomScriptConfigurationByName(scriptName);
    }
}

