/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.uma.UmaNeedInfoResponse;
import io.jans.as.model.uma.persistence.UmaPermission;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.service.external.ExternalUmaRptPolicyService;
import io.jans.as.server.uma.authorization.Claims;
import io.jans.as.server.uma.authorization.UmaAuthorizationContext;
import io.jans.as.server.uma.authorization.UmaAuthorizationContextBuilder;
import io.jans.as.server.uma.authorization.UmaPCT;
import io.jans.as.server.uma.authorization.UmaScriptByScope;
import io.jans.as.server.uma.service.UmaPermissionService;
import io.jans.as.server.uma.service.UmaResourceService;
import io.jans.as.server.uma.service.UmaSessionService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.uma.ClaimDefinition;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaNeedsInfoService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private ExternalUmaRptPolicyService policyService;
    @Inject
    private UmaSessionService sessionService;

    public static Set<String> getScriptDNs(List<Scope> scopes) {
        HashSet<String> result = new HashSet<String>();
        for (Scope scope : scopes) {
            List authorizationPolicies = scope.getUmaAuthorizationPolicies();
            if (authorizationPolicies == null) continue;
            result.addAll(authorizationPolicies);
        }
        return result;
    }

    public Map<UmaScriptByScope, UmaAuthorizationContext> checkNeedsInfo(Claims claims, Map<Scope, Boolean> requestedScopes, List<UmaPermission> permissions, UmaPCT pct, HttpServletRequest httpRequest, Client client) {
        HashMap<UmaScriptByScope, UmaAuthorizationContext> scriptMap = new HashMap<UmaScriptByScope, UmaAuthorizationContext>();
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        ArrayList<ClaimDefinition> missedClaims = new ArrayList<ClaimDefinition>();
        UmaAuthorizationContextBuilder contextBuilder = new UmaAuthorizationContextBuilder(this.appConfiguration, this.resourceService, permissions, requestedScopes, claims, httpRequest, this.sessionService, this.permissionService, client);
        for (Scope scope : requestedScopes.keySet()) {
            List authorizationPolicies = scope.getUmaAuthorizationPolicies();
            if (authorizationPolicies != null && !authorizationPolicies.isEmpty()) {
                for (String scriptDN : authorizationPolicies) {
                    CustomScriptConfiguration script = this.policyService.getScriptByDn(scriptDN);
                    if (script != null) {
                        String claimsGatheringScriptName;
                        UmaAuthorizationContext context = contextBuilder.build(script);
                        scriptMap.put(new UmaScriptByScope(scope, script), context);
                        List<ClaimDefinition> requiredClaims = this.policyService.getRequiredClaims(script, context);
                        if (requiredClaims != null && !requiredClaims.isEmpty()) {
                            for (ClaimDefinition definition : requiredClaims) {
                                if (claims.has(definition.getName())) continue;
                                missedClaims.add(definition);
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)(claimsGatheringScriptName = this.policyService.getClaimsGatheringScriptName(script, context)))) {
                            ticketAttributes.put("gathering_id", this.constructGatheringScriptNameValue((String)ticketAttributes.get("gathering_id"), claimsGatheringScriptName));
                            continue;
                        }
                        this.log.debug("External 'getClaimsGatheringScriptName' script method return null or blank value, script: {}", (Object)script.getName());
                        continue;
                    }
                    this.log.error("Unable to load UMA script dn: '{}'", (Object)scriptDN);
                }
                continue;
            }
            this.log.trace("No policies defined for scope: {}, scopeDn: {}", (Object)scope.getId(), (Object)scope.getDn());
        }
        if (!missedClaims.isEmpty()) {
            ticketAttributes.put("pct", pct.getCode());
            String newTicket = this.permissionService.changeTicket(permissions, ticketAttributes);
            UmaNeedInfoResponse needInfoResponse = new UmaNeedInfoResponse();
            needInfoResponse.setTicket(newTicket);
            needInfoResponse.setError("need_info");
            needInfoResponse.setRedirectUser(this.buildClaimsGatheringRedirectUri(scriptMap.values(), client, newTicket));
            needInfoResponse.setRequiredClaims(missedClaims);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ServerUtil.asJsonSilently(needInfoResponse)).build());
        }
        return scriptMap;
    }

    private String constructGatheringScriptNameValue(String existingValue, String claimsGatheringScriptName) {
        if (StringUtils.isBlank((CharSequence)existingValue)) {
            return claimsGatheringScriptName;
        }
        return existingValue + " " + claimsGatheringScriptName;
    }

    private String buildClaimsGatheringRedirectUri(Collection<UmaAuthorizationContext> contexts, Client client, String newTicket) {
        StringBuilder queryParametersBuilder = new StringBuilder();
        for (UmaAuthorizationContext context : contexts) {
            queryParametersBuilder.append(context.getRedirectUserParameters().buildQueryString()).append("&");
        }
        String queryParameters = queryParametersBuilder.toString();
        queryParameters = StringUtils.removeEnd((String)queryParameters, (String)"&");
        String result = this.appConfiguration.getBaseEndpoint() + "/uma/gather_claims";
        if (StringUtils.isNotBlank((CharSequence)queryParameters)) {
            result = result + "?" + queryParameters;
        }
        result = result + "&client_id=" + client.getClientId() + "&ticket=" + newTicket;
        return result;
    }
}

