/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.persistence.UmaResource;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.service.CacheService;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaResourceService {
    private static final int RESOURCE_CACHE_EXPIRATION_IN_SECONDS = 120;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private CacheService cacheService;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("resources");
        branch.setDn(this.getDnForResource(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addResource(UmaResource resource) {
        this.validate(resource);
        this.ldapEntryManager.persist((Object)resource);
    }

    public void validate(UmaResource resource) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)resource.getName()), (Object)"Name is required for resource.");
        Preconditions.checkArgument((resource.getScopes() != null && !resource.getScopes().isEmpty() || StringUtils.isNotBlank((CharSequence)resource.getScopeExpression()) ? 1 : 0) != 0, (Object)"Scope must be specified for resource.");
        Preconditions.checkState((!resource.isExpired() ? 1 : 0) != 0, (Object)"UMA Resource expired. It must not be expired.");
        this.prepareBranch();
    }

    public void updateResource(UmaResource resource) {
        this.updateResource(resource, false);
    }

    public void updateResource(UmaResource resource, boolean skipValidation) {
        if (!skipValidation) {
            this.validate(resource);
        }
        this.cacheService.put(resource.getDn(), (Object)resource);
        resource.resetTtlFromExpirationDate();
        this.ldapEntryManager.merge((Object)resource);
    }

    public void remove(UmaResource resource) {
        this.ldapEntryManager.remove((Object)resource);
    }

    public void remove(String rsid) {
        this.ldapEntryManager.remove((Object)this.getResourceById(rsid));
    }

    public void remove(List<UmaResource> resources) {
        for (UmaResource resource : resources) {
            this.remove(resource);
        }
    }

    public List<UmaResource> getResourcesByAssociatedClient(String associatedClientDn) {
        try {
            this.prepareBranch();
            if (StringUtils.isNotBlank((CharSequence)associatedClientDn)) {
                Filter filter = Filter.createEqualityFilter((String)"jansAssociatedClnt", (Object)associatedClientDn);
                return this.ldapEntryManager.findEntries(this.getBaseDnForResource(), UmaResource.class, filter);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public Set<UmaResource> getResources(Set<String> ids) {
        HashSet<UmaResource> result = new HashSet<UmaResource>();
        if (ids != null) {
            for (String id : ids) {
                UmaResource resource = this.getResourceById(id);
                if (resource != null) {
                    result.add(resource);
                    continue;
                }
                this.log.error("Failed to find resource by id: {}", (Object)id);
            }
        }
        return result;
    }

    public UmaResource getResourceById(String id) {
        this.prepareBranch();
        try {
            String key = this.getDnForResource(id);
            UmaResource resource = (UmaResource)this.cacheService.getWithPut(key, () -> (UmaResource)this.ldapEntryManager.find(UmaResource.class, (Object)key), 120);
            if (resource != null) {
                return resource;
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to find resource set with id: %s", id), (Throwable)e);
        }
        this.log.error("Failed to find resource set with id: {}", (Object)id);
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.NOT_FOUND, (IErrorType)UmaErrorResponseType.NOT_FOUND, "Failed to find resource set with id: " + id);
    }

    public Set<String> getResourceScopes(Set<String> resourceIds) {
        HashSet result = Sets.newHashSet();
        for (String resourceId : resourceIds) {
            result.addAll(this.getResourceById(resourceId).getScopes());
        }
        return result;
    }

    private void prepareBranch() {
        if (!this.ldapEntryManager.hasBranchesSupport(this.getDnForResource(null))) {
            return;
        }
        if (!this.ldapEntryManager.contains(this.getDnForResource(null), SimpleBranch.class)) {
            this.addBranch();
        }
    }

    public String getDnForResource(String jsId) {
        if (StringHelper.isEmpty((String)jsId)) {
            return this.getBaseDnForResource();
        }
        return String.format("jansId=%s,%s", jsId, this.getBaseDnForResource());
    }

    public String getBaseDnForResource() {
        String umaBaseDn = this.staticConfiguration.getBaseDn().getUmaBase();
        return String.format("ou=resources,%s", umaBaseDn);
    }
}

