/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.uma.persistence.UmaPermission;
import io.jans.as.model.util.Util;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.SessionIdService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaSessionService {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ClientService clientService;
    @Inject
    private CookieService cookieService;

    public SessionId getConnectSession(HttpServletRequest httpRequest) {
        String cookieId = this.cookieService.getSessionIdFromCookie(httpRequest);
        this.log.trace("Cookie - session_id: {}", (Object)cookieId);
        if (StringUtils.isNotBlank((CharSequence)cookieId)) {
            return this.sessionIdService.getSessionId(cookieId);
        }
        return null;
    }

    public SessionId getSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String cookieId = this.cookieService.getUmaSessionIdFromCookie(httpRequest);
        this.log.trace("Cookie - uma_session_id: {}", (Object)cookieId);
        if (StringUtils.isNotBlank((CharSequence)cookieId)) {
            SessionId sessionId = this.sessionIdService.getSessionId(cookieId);
            if (sessionId != null) {
                this.log.trace("Loaded uma_session_id from cookie, session: {}", (Object)sessionId);
                return sessionId;
            }
            this.log.error("Failed to load uma_session_id from cookie: {}", (Object)cookieId);
        } else {
            this.log.error("uma_session_id cookie is not set.");
        }
        this.log.trace("Generating new uma_session_id ...");
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("uma", "true");
        SessionId session = this.sessionIdService.generateAuthenticatedSessionId(httpRequest, "", sessionIdAttributes);
        this.cookieService.createSessionIdCookie(session, httpRequest, httpResponse, true);
        this.log.trace("uma_session_id cookie created.");
        return session;
    }

    public boolean persist(SessionId session) {
        try {
            if (this.sessionIdService.updateSessionId(session, true, true, true)) {
                this.log.trace("Session persisted successfully. Session: {}", (Object)session);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to persist session, id: " + session.getId(), (Throwable)e);
        }
        return false;
    }

    public int getStep(SessionId session) {
        String stepString = (String)session.getSessionAttributes().get("step");
        int step = Util.parseIntSilently((String)stepString);
        if (step == -1) {
            step = 1;
            this.setStep(step, session);
        }
        return step;
    }

    public void setStep(int step, SessionId session) {
        session.getSessionAttributes().put("step", Integer.toString(step));
    }

    public void configure(SessionId session, String scriptName, List<UmaPermission> permissions, String clientId, String claimRedirectUri, String state) {
        this.setStep(1, session);
        this.setState(session, state);
        this.setClaimsRedirectUri(session, claimRedirectUri);
        this.setTicket(session, permissions.get(0).getTicket());
        this.setScriptName(session, scriptName);
        String pct = (String)permissions.get(0).getAttributes().get("pct");
        if (StringUtils.isBlank((CharSequence)pct)) {
            this.log.error("PCT code is null or blank in permission object.");
            throw new RuntimeException("PCT code is null or blank in permission object.");
        }
        this.setPct(session, pct);
        this.setClientId(session, clientId);
        this.persist(session);
    }

    public boolean isStepPassed(SessionId session, Integer step) {
        return Boolean.parseBoolean((String)session.getSessionAttributes().get(String.format("uma_step_passed_%d", step)));
    }

    public boolean isPassedPreviousSteps(SessionId session, Integer step) {
        for (int i = 1; i < step; ++i) {
            if (this.isStepPassed(session, i)) continue;
            return false;
        }
        return true;
    }

    public void markStep(SessionId session, Integer step, boolean value) {
        String key = String.format("uma_step_passed_%d", step);
        if (value) {
            session.getSessionAttributes().put(key, Boolean.TRUE.toString());
        } else {
            session.getSessionAttributes().remove(key);
        }
    }

    public String getScriptName(SessionId session) {
        return (String)session.getSessionAttributes().get("gather_script_name");
    }

    public void setScriptName(SessionId session, String scriptName) {
        session.getSessionAttributes().put("gather_script_name", scriptName);
    }

    public String getPct(SessionId session) {
        return (String)session.getSessionAttributes().get("pct");
    }

    public void setPct(SessionId session, String pct) {
        session.getSessionAttributes().put("pct", pct);
    }

    public String getClientId(SessionId session) {
        return (String)session.getSessionAttributes().get("client_id");
    }

    public void setClientId(SessionId session, String clientId) {
        session.getSessionAttributes().put("client_id", clientId);
    }

    public String getClaimsRedirectUri(SessionId session) {
        return (String)session.getSessionAttributes().get("claims_redirect_uri");
    }

    public void setClaimsRedirectUri(SessionId session, String claimsRedirectUri) {
        session.getSessionAttributes().put("claims_redirect_uri", claimsRedirectUri);
    }

    public String getState(SessionId session) {
        return (String)session.getSessionAttributes().get("state");
    }

    public void setState(SessionId session, String state) {
        session.getSessionAttributes().put("state", state);
    }

    public String getTicket(SessionId session) {
        return (String)session.getSessionAttributes().get("ticket");
    }

    public void setTicket(SessionId session, String ticket) {
        session.getSessionAttributes().put("ticket", ticket);
    }

    public void resetToStep(SessionId session, int overridenNextStep, int step) {
        for (int i = overridenNextStep; i <= step; ++i) {
            this.markStep(session, i, false);
        }
        this.setStep(overridenNextStep, session);
    }

    public User getUser(HttpServletRequest httpRequest) {
        return this.sessionIdService.getUser(this.getConnectSession(httpRequest));
    }

    public String getUserDn(HttpServletRequest httpRequest) {
        SessionId connectSession = this.getConnectSession(httpRequest);
        if (connectSession != null) {
            return connectSession.getUserDn();
        }
        this.log.trace("No logged in user.");
        return null;
    }

    public Client getClient(SessionId session) {
        String clientId = this.getClientId(session);
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            return this.clientService.getClient(clientId);
        }
        this.log.trace("client_id is not in session.");
        return null;
    }
}

