/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.UmaTokenResponse;
import io.jans.as.model.uma.persistence.UmaPermission;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.security.Identity;
import io.jans.as.server.uma.authorization.Claims;
import io.jans.as.server.uma.authorization.UmaAuthorizationContext;
import io.jans.as.server.uma.authorization.UmaPCT;
import io.jans.as.server.uma.authorization.UmaRPT;
import io.jans.as.server.uma.authorization.UmaScriptByScope;
import io.jans.as.server.uma.service.UmaExpressionService;
import io.jans.as.server.uma.service.UmaNeedsInfoService;
import io.jans.as.server.uma.service.UmaPctService;
import io.jans.as.server.uma.service.UmaPermissionService;
import io.jans.as.server.uma.service.UmaRptService;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.as.server.uma.service.UmaValidationService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

@Named
@Stateless
public class UmaTokenService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaRptService rptService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaNeedsInfoService umaNeedsInfoService;
    @Inject
    private UmaExpressionService expressionService;

    public Response requestRpt(String grantType, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, String scope, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            this.log.trace("requestRpt grant_type: {}, ticket: {}, claim_token: {}, claim_token_format: {}, pct: {}, rpt: {}, scope: {}", new Object[]{grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope});
            this.umaValidationService.validateGrantType(grantType);
            List<UmaPermission> permissions = this.umaValidationService.validateTicket(ticket);
            Jwt idToken = this.umaValidationService.validateClaimToken(claimToken, claimTokenFormat);
            UmaPCT pct = this.umaValidationService.validatePct(pctCode);
            UmaRPT rpt = this.umaValidationService.validateRPT(rptCode);
            Client client = this.umaValidationService.validate(this.identity.getSessionClient().getClient());
            Map<Scope, Boolean> scopes = this.umaValidationService.validateScopes(scope, permissions, client);
            pct = this.pctService.updateClaims(pct, idToken, client.getClientId(), permissions);
            Claims claims = new Claims(idToken, pct, claimToken);
            Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap = this.umaNeedsInfoService.checkNeedsInfo(claims, scopes, permissions, pct, httpRequest, client);
            if (!scriptMap.isEmpty()) {
                this.expressionService.evaluate(scriptMap, permissions);
            } else {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("There are no any policies that protects scopes. Scopes: {}. Configuration property umaGrantAccessIfNoPolicies: {}", (Object)UmaScopeService.asString(scopes.keySet()), (Object)this.appConfiguration.getUmaGrantAccessIfNoPolicies());
                }
                if (this.appConfiguration.getUmaGrantAccessIfNoPolicies() != null && this.appConfiguration.getUmaGrantAccessIfNoPolicies().booleanValue()) {
                    this.log.warn("Access granted because there are no any protection. Make sure it is intentional behavior.");
                } else {
                    this.log.warn("Access denied because there are no any protection. Make sure it is intentional behavior.");
                    throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Access denied because there are no any protection. Make sure it is intentional behavior.");
                }
            }
            this.log.trace("Access granted.");
            this.updatePermissionsWithClientRequestedScope(permissions, scopes);
            this.addPctToPermissions(permissions, pct);
            boolean upgraded = false;
            if (rpt == null) {
                ExecutionContext executionContext = new ExecutionContext(httpRequest, httpResponse);
                executionContext.setClient(client);
                rpt = this.rptService.createRPTAndPersist(executionContext, permissions);
                rptCode = rpt.getNotHashedCode();
            } else if (this.rptService.addPermissionToRPT(rpt, permissions)) {
                upgraded = true;
            }
            UmaTokenResponse response = new UmaTokenResponse();
            response.setAccessToken(rptCode);
            response.setUpgraded(Boolean.valueOf(upgraded));
            response.setTokenType("Bearer");
            response.setPct(pct.getCode());
            return Response.ok((Object)ServerUtil.asJson(response)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error("Failed to handle request to UMA Token Endpoint.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Failed to handle request to UMA Token Endpoint.");
        }
    }

    private void addPctToPermissions(List<UmaPermission> permissions, UmaPCT pct) {
        for (UmaPermission p : permissions) {
            p.getAttributes().put("pct", pct.getCode());
            this.permissionService.mergeSilently(p);
        }
    }

    private void updatePermissionsWithClientRequestedScope(List<UmaPermission> permissions, Map<Scope, Boolean> scopes) {
        this.log.trace("Updating permissions with requested scopes ...");
        for (UmaPermission permission : permissions) {
            HashSet<String> scopeDns = new HashSet<String>(permission.getScopeDns());
            for (Map.Entry<Scope, Boolean> entry : scopes.entrySet()) {
                this.log.trace("Updating permissions with scope: {}, isRequestedScope: {}, permisson: {}", new Object[]{entry.getKey().getId(), entry.getValue(), permission.getDn()});
                scopeDns.add(entry.getKey().getDn());
            }
            permission.setScopeDns(new ArrayList(scopeDns));
        }
    }
}

