/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.ws.rs;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.persistence.UmaPermission;
import io.jans.as.model.util.Util;
import io.jans.as.server.service.external.ExternalUmaClaimsGatheringService;
import io.jans.as.server.uma.authorization.UmaGatherContext;
import io.jans.as.server.uma.authorization.UmaWebException;
import io.jans.as.server.uma.service.UmaPctService;
import io.jans.as.server.uma.service.UmaPermissionService;
import io.jans.as.server.uma.service.UmaSessionService;
import io.jans.as.server.uma.service.UmaValidationService;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/uma/gather_claims")
public class UmaGatheringWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaValidationService validationService;
    @Inject
    private ExternalUmaClaimsGatheringService external;
    @Inject
    private UmaSessionService sessionService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UserService userService;

    private static String getScriptNames(List<UmaPermission> permissions) {
        return (String)permissions.get(0).getAttributes().get("gathering_id");
    }

    public Response gatherClaims(String clientId, String ticket, String claimRedirectUri, String state, Boolean authenticationRedirect, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        block9: {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("gatherClaims client_id: {}, ticket: {}, claims_redirect_uri: {}, state: {}, authenticationRedirect: {}, queryString: {}", new Object[]{Util.escapeLog((Object)clientId), Util.escapeLog((Object)ticket), Util.escapeLog((Object)claimRedirectUri), Util.escapeLog((Object)state), Util.escapeLog((Object)authenticationRedirect), httpRequest.getQueryString()});
                }
                this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
                SessionId session = this.sessionService.getSession(httpRequest, httpResponse);
                if (authenticationRedirect != null && authenticationRedirect.booleanValue()) {
                    this.log.debug("Authentication redirect, restoring parameters from session ...");
                    if (session == null) {
                        this.log.error("Session is null however authentication=true. Wrong workflow! Please correct custom Glaims-Gathering Script.");
                        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SESSION, "Session is null however authentication=true. Wrong workflow! Please correct custom Glaims-Gathering Script.");
                    }
                    clientId = this.sessionService.getClientId(session);
                    ticket = this.sessionService.getTicket(session);
                    claimRedirectUri = this.sessionService.getClaimsRedirectUri(session);
                    state = this.sessionService.getState(session);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Restored parameters from session, clientId: {}, ticket: {}, claims_redirect_uri: {}, state: {}", new Object[]{Util.escapeLog((Object)clientId), Util.escapeLog((Object)ticket), Util.escapeLog((Object)claimRedirectUri), Util.escapeLog((Object)state)});
                    }
                }
                this.validationService.validateClientAndClaimsRedirectUri(clientId, claimRedirectUri, state);
                List<UmaPermission> permissions = this.validationService.validateTicketWithRedirect(ticket, claimRedirectUri, state);
                Object[] scriptNames = this.validationService.validatesGatheringScriptNames(UmaGatheringWS.getScriptNames(permissions), claimRedirectUri, state);
                CustomScriptConfiguration script = this.external.determineScript((String[])scriptNames);
                if (script == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("Failed to determine claims-gathering script for names: {}", (Object)Arrays.toString(scriptNames));
                    }
                    throw new UmaWebException(claimRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_GATHERING_SCRIPT_NAME, state);
                }
                this.sessionService.configure(session, script.getName(), permissions, clientId, claimRedirectUri, state);
                UmaGatherContext context = new UmaGatherContext(script.getConfigurationAttributes(), httpRequest, session, this.sessionService, this.permissionService, this.pctService, new HashMap<String, String>(), this.appConfiguration);
                int step = this.sessionService.getStep(session);
                int stepsCount = this.external.getStepsCount(script, context);
                if (step < stepsCount) {
                    String page = this.external.getPageForStep(script, step, context);
                    context.persist();
                    String baseEndpoint = StringUtils.removeEnd((String)this.appConfiguration.getBaseEndpoint(), (String)"/");
                    baseEndpoint = StringUtils.removeEnd((String)baseEndpoint, (String)"restv1");
                    baseEndpoint = StringUtils.removeEnd((String)baseEndpoint, (String)"/");
                    String fullUri = baseEndpoint + page;
                    fullUri = StringUtils.removeEnd((String)fullUri, (String)".xhtml") + ".htm";
                    this.log.trace("Redirecting to page: '{}', fullUri: {}", (Object)page, (Object)fullUri);
                    return Response.status((Response.Status)Response.Status.FOUND).location(new URI(fullUri)).build();
                }
                this.log.error("Step '{}' is more or equal to stepCount: '{}'", (Object)step, (Object)stepsCount);
            }
            catch (Exception ex) {
                this.log.error("Exception happened", (Throwable)ex);
                if (!(ex instanceof WebApplicationException)) break block9;
                throw (WebApplicationException)((Object)ex);
            }
        }
        this.log.error("Failed to handle call to UMA Claims Gathering Endpoint.");
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Failed to handle call to UMA Claims Gathering Endpoint.");
    }

    @GET
    @Produces(value={"application/json"})
    public Response getGatherClaims(@QueryParam(value="client_id") String clientId, @QueryParam(value="ticket") String ticket, @QueryParam(value="claims_redirect_uri") String claimRedirectUri, @QueryParam(value="state") String state, @QueryParam(value="reset") Boolean reset, @QueryParam(value="authentication") Boolean authenticationRedirect, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.gatherClaims(clientId, ticket, claimRedirectUri, state, authenticationRedirect, httpRequest, httpResponse);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postGatherClaims(@FormParam(value="client_id") String clientId, @FormParam(value="ticket") String ticket, @FormParam(value="claims_redirect_uri") String claimRedirectUri, @FormParam(value="state") String state, @FormParam(value="reset") Boolean reset, @FormParam(value="authentication") Boolean authenticationRedirect, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.gatherClaims(clientId, ticket, claimRedirectUri, state, authenticationRedirect, httpRequest, httpResponse);
    }
}

