/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.ws.rs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.PermissionTicket;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.UmaPermission;
import io.jans.as.model.uma.UmaPermissionList;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.uma.service.UmaPermissionService;
import io.jans.as.server.uma.service.UmaValidationService;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/host/rsrc_pr")
public class UmaPermissionRegistrationWS {
    @Inject
    private Logger log;
    @Inject
    private TokenService tokenService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaValidationService umaValidationService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerPermission(@Context HttpServletRequest request, @HeaderParam(value="Authorization") String authorization, String requestAsString) {
        try {
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            UmaPermissionList permissionList = this.parseRequest(requestAsString);
            this.umaValidationService.validatePermissions(permissionList, authorizationGrant.getClient());
            String ticket = this.permissionService.addPermission(permissionList, this.tokenService.getClientDn(authorization));
            return Response.status((Response.Status)Response.Status.CREATED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new PermissionTicket(ticket)).build();
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error("Exception happened", (Throwable)ex);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }

    private UmaPermissionList parseRequest(String requestAsString) {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        try {
            UmaPermission permission = (UmaPermission)mapper.readValue(requestAsString, UmaPermission.class);
            return new UmaPermissionList().addPermission(permission);
        }
        catch (IOException permission) {
            try {
                UmaPermissionList permissions = (UmaPermissionList)mapper.readValue(requestAsString, UmaPermissionList.class);
                if (!permissions.isEmpty()) {
                    return permissions;
                }
                this.log.error("Permission list is empty.");
            }
            catch (IOException e) {
                this.log.error("Failed to parse uma permission request" + requestAsString, (Throwable)e);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_PERMISSION_REQUEST, "Failed to parse uma permission request.");
        }
    }
}

