/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.util;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.authorize.ws.rs.ConsentGatheringSessionService;
import io.jans.as.server.service.AuthorizeService;
import io.jans.as.server.service.SessionIdService;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ApplicationScoped
public class AgamaConsentUtil {
    @Inject
    private ConsentGatheringSessionService cgss;
    @Inject
    private AuthorizeService as;
    @Inject
    private SessionIdService sis;

    public Map<String, String> getSessionAttributes() {
        return this.getSessionId().getSessionAttributes();
    }

    public Client getClient() {
        return this.cgss.getClient(this.getSessionId());
    }

    public List<Scope> getScopes() {
        String scope = this.getSessionAttributes().get("scope");
        return Optional.ofNullable(scope).map(this.as::getScopes).orElse(Collections.emptyList());
    }

    public User getUser() {
        return this.sis.getUser(this.getSessionId());
    }

    private SessionId getSessionId() {
        return this.sis.getSessionId(this.getServletRequest());
    }

    private HttpServletRequest getServletRequest() {
        return (HttpServletRequest)CdiUtil.bean(HttpServletRequest.class);
    }
}

