/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.util;

import io.jans.as.server.i18n.LanguageBean;
import io.jans.model.attribute.AttributeValidation;
import io.jans.service.AttributeService;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import jakarta.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ApplicationScoped
@FacesValidator(value="gluuPasswordValidator", managed=true)
public class PasswordValidator
implements Validator {
    private static final String USER_PASSWORD = "userPassword";
    private String newPassword;
    private Pattern pattern;
    private Matcher matcher;
    private boolean hasValidation = false;
    @Inject
    private AttributeService attributeService;
    @Inject
    private LanguageBean languageBean;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String regexp;
        AttributeValidation validation;
        if (this.attributeService == null) {
            this.attributeService = (AttributeService)CdiUtil.bean(AttributeService.class);
        }
        if (this.languageBean == null) {
            this.languageBean = (LanguageBean)CdiUtil.bean(LanguageBean.class);
        }
        if ((validation = this.attributeService.getAttributeByName(USER_PASSWORD).getAttributeValidation()) != null && (regexp = validation.getRegexp()) != null && !regexp.isEmpty()) {
            this.pattern = Pattern.compile(regexp);
            this.matcher = this.pattern.matcher(value.toString());
            this.hasValidation = true;
        }
        if (this.hasValidation && !this.matcher.matches()) {
            String message = this.languageBean.getMessage("password.validation.invalid");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
            context.validationFailed();
            ((UIInput)component).setValid(false);
        }
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }
}

