/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.util;

import io.jans.as.client.TokenResponse;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.ClientCredentialsGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.service.cdi.util.CdiUtil;

public class TokenServiceUtil {
    private TokenServiceUtil() {
    }

    public static TokenResponse createClientCredentialsAccessTokenWithoutScript(Client client, String scope, ExecutionContext inputContext) {
        inputContext.setSkipModifyAccessTokenScript(true);
        return TokenServiceUtil.createClientCredentialsAccessToken(client, scope, inputContext);
    }

    public static TokenResponse createClientCredentialsAccessToken(Client client, String scope, ExecutionContext inputContext) {
        ExecutionContext executionContext = inputContext.copy();
        executionContext.setClient(client);
        AuthorizationGrantList authorizationGrantList = (AuthorizationGrantList)CdiUtil.bean(AuthorizationGrantList.class);
        ClientCredentialsGrant clientCredentialsGrant = authorizationGrantList.createClientCredentialsGrant(new User(), client);
        scope = clientCredentialsGrant.checkScopesPolicy(scope);
        executionContext.setGrant(clientCredentialsGrant);
        AccessToken accessToken = clientCredentialsGrant.createAccessToken(executionContext);
        TokenResponse tokenResponse = new TokenResponse();
        tokenResponse.setAccessToken(accessToken.getCode());
        tokenResponse.setTokenType(accessToken.getTokenType());
        tokenResponse.setExpiresIn(Integer.valueOf(accessToken.getExpiresIn()));
        tokenResponse.setScope(scope);
        return tokenResponse;
    }
}

