/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ws.rs.stat;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.service.stat.StatResponseService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.as.server.ws.rs.stat.FlatStatResponse;
import io.jans.as.server.ws.rs.stat.Months;
import io.jans.as.server.ws.rs.stat.StatResponse;
import io.jans.as.server.ws.rs.stat.StatResponseItem;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/internal/stat")
public class StatWS {
    @Inject
    private Logger log;
    @Inject
    private StatResponseService statResponseService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private TokenService tokenService;

    public static String createOpenMetricsResponse(StatResponse statResponse) throws IOException {
        StringWriter writer = new StringWriter();
        CollectorRegistry registry = new CollectorRegistry();
        Counter usersCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("monthly_active_users")).labelNames(new String[]{"month"})).help("Monthly active users")).register(registry);
        Counter accessTokenCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("access_token")).labelNames(new String[]{"month", "grantType"})).help("Access Token")).register(registry);
        Counter logoutStatusJwtCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("logout_status_jwt")).labelNames(new String[]{"month", "grantType"})).help("Logout Status JWT")).register(registry);
        Counter idTokenCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("id_token")).labelNames(new String[]{"month", "grantType"})).help("Id Token")).register(registry);
        Counter refreshTokenCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("refresh_token")).labelNames(new String[]{"month", "grantType"})).help("Refresh Token")).register(registry);
        Counter umaTokenCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("uma_token")).labelNames(new String[]{"month", "grantType"})).help("UMA Token")).register(registry);
        for (Map.Entry<String, StatResponseItem> entry : statResponse.getResponse().entrySet()) {
            String month = entry.getKey();
            StatResponseItem item = entry.getValue();
            ((Counter.Child)usersCounter.labels(new String[]{month})).inc((double)item.getMonthlyActiveUsers());
            for (Map.Entry<String, Map<String, Long>> tokenEntry : item.getTokenCountPerGrantType().entrySet()) {
                String grantType = tokenEntry.getKey();
                Map<String, Long> tokenMap = tokenEntry.getValue();
                ((Counter.Child)accessTokenCounter.labels(new String[]{month, grantType})).inc((double)StatWS.getToken(tokenMap, "access_token"));
                ((Counter.Child)idTokenCounter.labels(new String[]{month, grantType})).inc((double)StatWS.getToken(tokenMap, "id_token"));
                ((Counter.Child)refreshTokenCounter.labels(new String[]{month, grantType})).inc((double)StatWS.getToken(tokenMap, "refresh_token"));
                ((Counter.Child)umaTokenCounter.labels(new String[]{month, grantType})).inc((double)StatWS.getToken(tokenMap, "uma_token"));
                ((Counter.Child)logoutStatusJwtCounter.labels(new String[]{month, grantType})).inc((double)StatWS.getToken(tokenMap, "logout_status_jwt"));
            }
        }
        TextFormat.write004((Writer)writer, (Enumeration)registry.metricFamilySamples());
        return ((Object)writer).toString();
    }

    private static long getToken(Map<String, Long> map, String key) {
        Long v = map.get(key);
        return v != null ? v : 0L;
    }

    @GET
    @Produces(value={"application/json"})
    public Response statGet(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="month") String months, @QueryParam(value="start-month") String startMonth, @QueryParam(value="end-month") String endMonth, @QueryParam(value="format") String format) {
        return this.stat(authorization, months, startMonth, endMonth, format);
    }

    @POST
    @Produces(value={"application/json"})
    public Response statPost(@HeaderParam(value="Authorization") String authorization, @FormParam(value="month") String months, @FormParam(value="start-month") String startMonth, @FormParam(value="end-month") String endMonth, @FormParam(value="format") String format) {
        return this.stat(authorization, months, startMonth, endMonth, format);
    }

    public Response stat(String authorization, String monthsParam, String startMonth, String endMonth, String format) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to request stat, month: {}, startMonth: {}, endMonth: {}, format: {}", new Object[]{Util.escapeLog((Object)monthsParam), Util.escapeLog((Object)startMonth), Util.escapeLog((Object)endMonth), Util.escapeLog((Object)format)});
        }
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.STAT);
        this.validateAuthorization(authorization);
        Set<String> months = this.validateMonths(monthsParam, startMonth, endMonth);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Recognized months: {}", (Object)Util.escapeLog(months));
            }
            StatResponse statResponse = this.statResponseService.buildResponse(months);
            String responseAsStr = "openmetrics".equalsIgnoreCase(format) ? StatWS.createOpenMetricsResponse(statResponse) : ("jsonmonth".equalsIgnoreCase(format) ? ServerUtil.asJson(statResponse) : ServerUtil.asJson(new FlatStatResponse(new ArrayList<StatResponseItem>(statResponse.getResponse().values()))));
            if (this.log.isTraceEnabled()) {
                this.log.trace("Stat: {}", (Object)responseAsStr);
            }
            return Response.ok().entity((Object)responseAsStr).build();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    private void validateAuthorization(String authorization) {
        this.log.trace("Validating authorization: {}", (Object)authorization);
        AuthorizationGrant grant = this.tokenService.getAuthorizationGrant(authorization);
        if (grant == null) {
            this.log.trace("Unable to find token by authorization: {}", (Object)authorization);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.ACCESS_DENIED, "Can't find grant for authorization.");
        }
        AbstractToken accessToken = grant.getAccessToken(this.tokenService.getToken(authorization));
        if (accessToken == null) {
            this.log.trace("Unable to find token by authorization: {}", (Object)authorization);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.ACCESS_DENIED, "Can't find access token.");
        }
        if (accessToken.isExpired()) {
            this.log.trace("Access Token is expired: {}", (Object)accessToken.getCode());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.ACCESS_DENIED, "Token expired.");
        }
        if (!grant.getScopesAsString().contains(this.appConfiguration.getStatAuthorizationScope())) {
            this.log.trace("Access Token does NOT have '{}' scope which is required to call Statistic Endpoint.", (Object)this.appConfiguration.getStatAuthorizationScope());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.ACCESS_DENIED, this.appConfiguration.getStatAuthorizationScope() + " scope is required for token.");
        }
    }

    private Set<String> validateMonths(String months, String startMonth, String endMonth) {
        if (!Months.isValid(months, startMonth, endMonth)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)TokenErrorResponseType.INVALID_REQUEST, "`month` or `start-month`/`end-month` parameter(s) can't be blank and should be in format yyyyMM (e.g. 202012)");
        }
        Set<String> monthList = Months.getMonths(months = ServerUtil.urlDecode(months), startMonth, endMonth);
        if (monthList.isEmpty()) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)TokenErrorResponseType.INVALID_REQUEST, "Unable to identify months. Check `month` or `start-month`/`end-month` parameter(s). It can't be blank and should be in format yyyyMM (e.g. 202012). start-month must be before end-month");
        }
        return monthList;
    }
}

