/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.audit.debug.wrapper;

import io.jans.as.server.audit.debug.wrapper.ResponseWrapper;
import io.jans.as.server.audit.debug.wrapper.ServletOutputStreamCopier;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class LogResponseWrapper
extends ResponseWrapper {
    private ServletOutputStream outputStream;
    private PrintWriter writer;
    private ServletOutputStreamCopier copier;
    private HttpServletResponse res;
    private static final Logger LOG = Logger.getLogger(LogResponseWrapper.class);

    public LogResponseWrapper(HttpServletResponse response) {
        super(response);
        this.res = response;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response");
        }
        if (this.outputStream == null) {
            this.outputStream = this.getResponse().getOutputStream();
            this.copier = new ServletOutputStreamCopier((OutputStream)this.outputStream);
        }
        return this.copier;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response");
        }
        if (this.writer == null) {
            this.copier = new ServletOutputStreamCopier((OutputStream)this.getResponse().getOutputStream());
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copier), this.getResponse().getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.copier.flush();
        }
    }

    public byte[] getCopy() {
        if (this.copier != null) {
            return this.copier.getCopy();
        }
        return new byte[0];
    }

    public String getBodyCopy() {
        String responseBody = "";
        try {
            this.flushBuffer();
            byte[] copy = this.getCopy();
            responseBody = new String(copy, this.res.getCharacterEncoding());
            return responseBody;
        }
        catch (IOException ie) {
            LOG.error((Object)"Error reading response body content IOException LogResponseWrapper, configuration (httpLoggingResponseBodyContent) is enabled ", (Throwable)ie);
        }
        finally {
            return responseBody;
        }
    }
}

