/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.auth;

import com.google.common.collect.Maps;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.ErrorHandlerService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.UserService;
import io.jans.as.server.service.external.ExternalCreateUserService;
import io.jans.jsf2.service.FacesService;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.ExternalContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@RequestScoped
@Named
public class CreateUserAction {
    private static final String FORM_ID = "createForm";
    private static final String CREATE_BUTTON_REF = "createForm:createButton";
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String responseMode;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String authReqId;
    private String bindingMessage;
    private String sessionId;
    private String allowedScope;
    private String displayName;
    private String email;
    private String uid;
    private String password;
    @Inject
    private Logger log;
    @Inject
    private ExternalCreateUserService externalCreateUserService;
    @Inject
    private ErrorHandlerService errorHandlerService;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private UserService userService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private CookieService cookieService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private AppConfiguration appConfiguration;

    @PostConstruct
    public void prepare() {
        this.log.trace("Preparing CreateUserAction");
        ExecutionContext executionContext = ExecutionContext.of(this.externalContext);
        boolean isOk = this.externalCreateUserService.externalPrepare(executionContext);
        if (!isOk) {
            this.errorHandlerService.handleError("createUser.forbiddenByScript", (IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Forbidden by createUser script.");
        }
    }

    public void createUser() {
        try {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDisablePromptCreate())) {
                this.log.debug("Skipped user creation. config disablePromptCreate=true");
                return;
            }
            this.log.debug("Creating user ...");
            ExecutionContext executionContext = ExecutionContext.of(this.externalContext);
            User user = this.prepareUserObject(executionContext);
            boolean isOk = this.externalCreateUserService.externalCreate(executionContext);
            if (!isOk) {
                this.log.debug("createUser is forbidded by create() method of external script.");
                return;
            }
            user = this.userService.addUser(user, true);
            this.log.debug("User {} is created successfully.", (Object)user.getUserId());
            String uri = this.buildAuthorizationUrl();
            this.log.trace("RedirectTo: {}", (Object)uri);
            this.facesService.redirectToExternalURL(uri);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private User prepareUserObject(ExecutionContext executionContext) {
        User user = new User();
        executionContext.setUser(user);
        User fetchedUser = this.userService.getUser(this.uid, new String[0]);
        if (fetchedUser != null) {
            this.log.debug("User with uid {} already exists.", (Object)this.uid);
            user = fetchedUser;
        }
        user.setAttribute("displayName", (Object)this.displayName, Boolean.valueOf(false));
        user.setAttribute("mail", (Object)this.email, Boolean.valueOf(false));
        user.setAttribute("uid", (Object)this.uid, Boolean.valueOf(false));
        user.setAttribute("userPassword", (Object)this.password, Boolean.valueOf(false));
        this.log.debug("Prepared user - uid: {}, email: {}, displayName: {}", new Object[]{this.uid, this.email, this.displayName});
        return user;
    }

    private String buildAuthorizationUrl() throws UnsupportedEncodingException {
        ExecutionContext executionContext = ExecutionContext.of(this.externalContext);
        String url = this.externalCreateUserService.externalBuildPostAuthorizeUrl(executionContext);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.log.debug("Authorization Url is returned from external script, url: {}", (Object)url);
            return url;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
        Map<String, String> filteredParameters = this.getFilteredParameters();
        filteredParameters.remove("password");
        filteredParameters.remove("email");
        this.log.debug("client_id {}, response_type {}, scope {}, acr_values {}", new Object[]{this.clientId, this.responseType, this.scope, this.acrValues});
        filteredParameters.putIfAbsent("client_id", this.clientId);
        filteredParameters.putIfAbsent("response_type", this.responseType);
        filteredParameters.putIfAbsent("response_mode", this.responseMode);
        filteredParameters.putIfAbsent("scope", this.scope);
        filteredParameters.putIfAbsent("redirect_uri", this.redirectUri);
        filteredParameters.putIfAbsent("nonce", this.nonce);
        filteredParameters.putIfAbsent("acr_values", this.acrValues);
        filteredParameters.putIfAbsent("state", this.state);
        filteredParameters.putIfAbsent("request", this.request);
        filteredParameters.putIfAbsent("request_uri", this.requestUri);
        filteredParameters.putIfAbsent("display", this.display);
        filteredParameters.putIfAbsent("max_age", this.maxAge != null ? this.maxAge.toString() : null);
        filteredParameters.putIfAbsent("ui_locales", this.uiLocales);
        filteredParameters.putIfAbsent("id_token_hint", this.idTokenHint);
        filteredParameters.putIfAbsent("login_hint", this.loginHint);
        filteredParameters.putIfAbsent("amr_values", this.amrValues);
        filteredParameters.putIfAbsent("code_challenge", this.codeChallenge);
        filteredParameters.putIfAbsent("code_challenge_method", this.codeChallengeMethod);
        filteredParameters.putIfAbsent("claims", this.claims);
        filteredParameters.putIfAbsent("auth_req_id", this.authReqId);
        filteredParameters.putIfAbsent("binding_message", this.bindingMessage);
        filteredParameters.putIfAbsent("session_id", this.sessionId);
        filteredParameters.putIfAbsent("allowed_scope", this.allowedScope);
        return httpRequest.getContextPath() + "/restv1/authorize?" + this.requestParameterService.parametersAsString(filteredParameters);
    }

    public SessionId getSession() {
        return this.getSession(null);
    }

    public SessionId getSession(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId) && StringUtils.isBlank((CharSequence)(sessionId = this.cookieService.getSessionIdFromCookie()))) {
            return null;
        }
        SessionId dbSessionId = this.sessionIdService.getSessionId(sessionId);
        this.log.debug("Found session {}, dbSession: {}", (Object)sessionId, (Object)dbSessionId);
        return dbSessionId;
    }

    private Map<String, String> getFilteredParameters() {
        Map parameterMap = this.externalContext.getRequestParameterMap();
        HashMap filtered = Maps.newHashMap();
        String formIdWithColon = "createForm:";
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("jakarta.faces.ViewState") || key.equals(FORM_ID) || key.contains(CREATE_BUTTON_REF)) continue;
            if (key.startsWith("createForm:")) {
                filtered.put(StringUtils.removeStart((String)key, (String)"createForm:"), (String)entry.getValue());
                continue;
            }
            filtered.put(StringUtils.removeStart((String)key, (String)"createForm:"), (String)entry.getValue());
        }
        return filtered;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public void setBindingMessage(String bindingMessage) {
        this.bindingMessage = bindingMessage;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAllowedScope() {
        return this.allowedScope;
    }

    public void setAllowedScope(String allowedScope) {
        this.allowedScope = allowedScope;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

