/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.auth;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.CertUtils;
import io.jans.as.model.util.HashUtil;
import io.jans.as.server.auth.Authenticator;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalDynamicClientRegistrationService;
import io.jans.as.server.service.external.context.DynamicClientRegistrationContext;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class MTLSService {
    @Inject
    private Logger log;
    @Inject
    private Authenticator authenticator;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;

    public boolean processMTLS(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain, Client client) throws Exception {
        this.log.debug("Trying to authenticate client {} via {} ...", (Object)client.getClientId(), (Object)client.getAllAuthenticationMethods());
        String clientCertAsPem = httpRequest.getHeader("X-ClientCert");
        if (StringUtils.isBlank((CharSequence)clientCertAsPem)) {
            this.log.debug("Client certificate is missed in `X-ClientCert` header, client_id: {}.", (Object)client.getClientId());
            return false;
        }
        X509Certificate cert = CertUtils.x509CertificateFromPem((String)clientCertAsPem);
        if (cert == null) {
            this.log.debug("Failed to parse client certificate, client_id: {}.", (Object)client.getClientId());
            return false;
        }
        String cn = CertUtils.getCN((X509Certificate)cert);
        String hashedCn = HashUtil.getHash((String)cn, (SignatureAlgorithm)SignatureAlgorithm.HS512);
        if (StringUtils.isBlank((CharSequence)cn) || StringUtils.isBlank((CharSequence)hashedCn) || !cn.equals(client.getClientId()) && !hashedCn.equals(HashUtil.getHash((String)client.getClientId(), (SignatureAlgorithm)SignatureAlgorithm.HS512))) {
            DynamicClientRegistrationContext context;
            boolean result;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Client certificate CN does not match clientId. Invoke registration script's isCertValidForClient, CN: {}, clientId: {}, hashedCn: {}", new Object[]{cn, client.getClientId(), hashedCn});
            }
            if (!(result = this.externalDynamicClientRegistrationService.isCertValidForClient(cert, context = new DynamicClientRegistrationContext(httpRequest, new JSONObject(), null, client)))) {
                this.log.error("Reject request. isCertValidForClient returned false.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)TokenErrorResponseType.INVALID_CLIENT, httpRequest.getParameter("state"), "")).build());
            }
        }
        if (client.hasAuthenticationMethod(AuthenticationMethod.TLS_CLIENT_AUTH)) {
            this.log.debug("Authenticating with tls_client_auth ...");
            String subjectDn = client.getAttributes().getTlsClientAuthSubjectDn();
            if (StringUtils.isBlank((CharSequence)subjectDn)) {
                this.log.debug("SubjectDN is not set for client {} which is required to authenticate it via `tls_client_auth`.", (Object)client.getClientId());
                return false;
            }
            if (CertUtils.equalsRdn((String)subjectDn, (String)cert.getSubjectDN().getName())) {
                this.log.debug("Client {} authenticated via `tls_client_auth`.", (Object)client.getClientId());
                this.authenticatedSuccessfully(client, httpRequest);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return true;
            }
            this.log.debug("Client's subject dn: {}, cert subject dn: {}", (Object)subjectDn, (Object)cert.getSubjectDN().getName());
        }
        if (client.hasAuthenticationMethod(AuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH)) {
            this.log.debug("Authenticating with self_signed_tls_client_auth ...");
            PublicKey publicKey = cert.getPublicKey();
            byte[] encodedKey = publicKey.getEncoded();
            JSONObject jsonWebKeys = CommonUtils.getJwks((Client)client);
            if (jsonWebKeys == null) {
                this.log.debug("Unable to load json web keys for client: {}, jwks_uri: {}, jks: {}", new Object[]{client.getClientId(), client.getJwksUri(), client.getJwks()});
                return false;
            }
            JSONWebKeySet keySet = JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys);
            for (JSONWebKey key : keySet.getKeys()) {
                if (!ArrayUtils.isEquals((Object)encodedKey, (Object)this.cryptoProvider.getPublicKey(key.getKid(), jsonWebKeys, null).getEncoded())) continue;
                this.log.debug("Client {} authenticated via `self_signed_tls_client_auth`, matched kid: {}.", (Object)client.getClientId(), (Object)key.getKid());
                this.authenticatedSuccessfully(client, httpRequest);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return true;
            }
        }
        this.log.debug("MTLS authentication failed.");
        return false;
    }

    private void authenticatedSuccessfully(Client client, HttpServletRequest httpRequest) {
        this.authenticator.configureSessionClient(client);
        List prompts = Prompt.fromString((String)httpRequest.getParameter("prompt"), (String)" ");
        if (prompts.contains(Prompt.LOGIN)) {
            return;
        }
        SessionId sessionIdObject = this.sessionIdService.getSessionId(httpRequest);
        if (sessionIdObject == null || sessionIdObject.getState() != SessionIdState.AUTHENTICATED) {
            return;
        }
        this.authenticator.authenticateBySessionId(sessionIdObject);
    }

    public boolean processRegisterMTLS(HttpServletRequest httpRequest) {
        this.log.debug("Trying to authenticate client registration request via MTLS");
        String tlsClientAuthSubjectDn = null;
        try {
            String request = IOUtils.toString((Reader)httpRequest.getReader());
            JSONObject jsonObject = new JSONObject(request);
            tlsClientAuthSubjectDn = jsonObject.optString(RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString());
        }
        catch (Exception exception) {
            this.log.error("Error getting TLS_CLIENT_AUTH_SUBJECT_DN field from request registration body", (Throwable)exception);
        }
        String clientCertAsPem = httpRequest.getHeader("X-ClientCert");
        if (StringUtils.isBlank((CharSequence)clientCertAsPem)) {
            this.log.debug("Client certificate is missed in `X-ClientCert` header");
            return false;
        }
        X509Certificate cert = CertUtils.x509CertificateFromPem((String)clientCertAsPem);
        if (cert == null) {
            this.log.debug("Failed to parse client certificate");
            return false;
        }
        this.log.debug("MTLS client authentication tlsClientAuthSubjectDn = {}", (Object)tlsClientAuthSubjectDn);
        return CertUtils.equalsRdn((String)tlsClientAuthSubjectDn, (String)cert.getSubjectDN().getName());
    }
}

