/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import com.google.common.collect.Maps;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.AuthorizationChallengeSession;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.authorize.AuthorizationChallengeResponse;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.binding.TokenBindingMessage;
import io.jans.as.model.crypto.binding.TokenBindingParseException;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.authorize.ws.rs.AuthorizationChallengeSessionService;
import io.jans.as.server.authorize.ws.rs.AuthorizationChallengeValidator;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceImpl;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.authorize.ws.rs.AuthzRequestService;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.common.AuthorizationCodeGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.LogoutStatusJwt;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalAuthorizationChallengeService;
import io.jans.as.server.util.ServerUtil;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@RequestScoped
@Named
public class AuthorizationChallengeService {
    @Inject
    private Logger log;
    @Inject
    private AuthzRequestService authzRequestService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private AuthorizationChallengeValidator authorizationChallengeValidator;
    @Inject
    private ExternalAuthorizationChallengeService externalAuthorizationChallengeService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationChallengeSessionService authorizationChallengeSessionService;
    @Inject
    private Identity identity;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private CookieService cookieService;

    public Response requestAuthorization(AuthzRequest authzRequest) {
        this.log.debug("Attempting to request authz challenge: {}", (Object)authzRequest);
        this.authzRequestService.createOauth2AuditLog(authzRequest);
        try {
            Response response = this.authorize(authzRequest);
            return response;
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.applicationAuditLogger.sendMessage(authzRequest.getAuditLog());
        }
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).build();
    }

    public void prepareAuthzRequest(AuthzRequest authzRequest) {
        authzRequest.setScope(ServerUtil.urlDecode(authzRequest.getScope()));
        this.log.trace("prepareAuthzRequest - authorization challenge session {}", (Object)authzRequest.getAuthorizationChallengeSession());
        if (StringUtils.isNotBlank((CharSequence)authzRequest.getAuthorizationChallengeSession())) {
            AuthorizationChallengeSession session = this.authorizationChallengeSessionService.getAuthorizationChallengeSession(authzRequest.getAuthorizationChallengeSession());
            this.authorizationChallengeValidator.validateDpopJkt(session, authzRequest.getDpop());
            authzRequest.setAuthorizationChallengeSessionObject(session);
            if (session != null) {
                String scope;
                String acrValues;
                this.log.trace("prepareAuthzRequest - sessionAttributes {}, id {}", (Object)session.getAttributes().getAttributes(), (Object)session.getId());
                Map attributes = session.getAttributes().getAttributes();
                String clientId = (String)attributes.get("client_id");
                if (StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isBlank((CharSequence)authzRequest.getClientId())) {
                    authzRequest.setClientId(clientId);
                    this.log.trace("prepareAuthzRequest - Set client_id {} from session", (Object)clientId);
                }
                if (StringUtils.isBlank((CharSequence)(acrValues = session.getAttributes().getAcrValues()))) {
                    acrValues = (String)attributes.get("acr_values");
                }
                if (StringUtils.isNotBlank((CharSequence)acrValues) && StringUtils.isBlank((CharSequence)authzRequest.getAcrValues())) {
                    authzRequest.setAcrValues(acrValues);
                    this.log.trace("prepareAuthzRequest - Set acr_values {} from session", (Object)acrValues);
                }
                if (StringUtils.isNotBlank((CharSequence)(scope = (String)attributes.get("scope"))) && StringUtils.isBlank((CharSequence)authzRequest.getScope())) {
                    authzRequest.setScope(scope);
                    this.log.trace("prepareAuthzRequest - Set scope {} from session", (Object)scope);
                }
            } else {
                this.log.debug("Unable to find authorization challenge session by id {}", (Object)authzRequest.getAuthorizationChallengeSession());
            }
        }
        this.externalAuthorizationChallengeService.externalPrepareAuthzRequest(authzRequest);
    }

    public Response authorize(AuthzRequest authzRequest) throws IOException, TokenBindingParseException {
        String state = authzRequest.getState();
        String tokenBindingHeader = authzRequest.getHttpRequest().getHeader("Sec-Token-Binding");
        this.prepareAuthzRequest(authzRequest);
        SessionId sessionUser = this.identity.getSessionId();
        User user = this.sessionIdService.getUser(sessionUser);
        Client client = this.authorizeRestWebServiceValidator.validateClient(authzRequest, false);
        this.authorizationChallengeValidator.validateGrantType(client, state);
        this.authorizationChallengeValidator.validateAccess(client);
        Set<String> scopes = this.scopeChecker.checkScopesPolicy(client, authzRequest.getScope());
        this.authorizeRestWebServiceValidator.validateAuthorizationDetails(authzRequest, client);
        ExecutionContext executionContext = ExecutionContext.of(authzRequest);
        executionContext.setSessionId(sessionUser);
        if (user == null) {
            this.log.trace("Executing external authentication challenge ... (requestedScopes: {})", scopes);
            boolean ok = this.externalAuthorizationChallengeService.externalAuthorize(executionContext);
            if (!ok) {
                this.log.debug("Not allowed by authorization challenge script, client_id {}.", (Object)client.getClientId());
                throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, state, "Not allowed by authorization challenge script.")).build());
            }
            User user2 = user = executionContext.getUser() != null ? executionContext.getUser() : new User();
            if (sessionUser == null || executionContext.getAuthorizationChallengeSessionId() != null) {
                sessionUser = this.generateAuthenticateSessionWithCookieIfNeeded(authzRequest, user, executionContext.getAuthorizationChallengeSessionId());
            }
        }
        String grantAcr = executionContext.getScript() != null ? executionContext.getScript().getName() : authzRequest.getAcrValues();
        this.log.trace("Creating authorization code grant with: scope {}, acr {}", scopes, (Object)grantAcr);
        AuthorizationCodeGrant authorizationGrant = this.authorizationGrantList.createAuthorizationCodeGrant(user, client, new Date());
        authorizationGrant.setNonce(authzRequest.getNonce());
        authorizationGrant.setJwtAuthorizationRequest(authzRequest.getJwtRequest());
        authorizationGrant.setTokenBindingHash(TokenBindingMessage.getTokenBindingIdHashFromTokenBindingMessage((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()));
        authorizationGrant.setScopes(scopes);
        authorizationGrant.setAuthzDetails(authzRequest.getAuthzDetails());
        authorizationGrant.setCodeChallenge(authzRequest.getCodeChallenge());
        authorizationGrant.setCodeChallengeMethod(authzRequest.getCodeChallengeMethod());
        authorizationGrant.setClaims(authzRequest.getClaims());
        authorizationGrant.setSessionDn(sessionUser != null ? sessionUser.getDn() : "no_session_for_authorization_challenge");
        authorizationGrant.setAcrValues(grantAcr);
        authorizationGrant.setAuthorizationChallenge(true);
        authorizationGrant.save();
        return this.createSuccessfulResponse(authorizationGrant, authzRequest);
    }

    private SessionId generateAuthenticateSessionWithCookieIfNeeded(AuthzRequest authzRequest, User user, SessionId scriptGeneratedSession) {
        if (user == null) {
            this.log.trace("Skip session_id generation because user is null");
            return null;
        }
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getAuthorizationChallengeShouldGenerateSession())) {
            this.log.trace("Skip session_id generation because it's not allowed by AS configuration ('authorizationChallengeShouldGenerateSession=false')");
            return null;
        }
        if (scriptGeneratedSession != null) {
            this.log.trace("Authorization Challenge script generated session: {}.", (Object)scriptGeneratedSession.getId());
            this.cookieService.createSessionIdCookie(scriptGeneratedSession, authzRequest.getHttpRequest(), authzRequest.getHttpResponse(), false);
            this.log.trace("Created cookie for authorization Challenge script generated session: {}.", (Object)scriptGeneratedSession.getId());
            return scriptGeneratedSession;
        }
        Map<String, String> genericRequestMap = AuthorizeRestWebServiceImpl.getGenericRequestMap(authzRequest.getHttpRequest());
        HashMap parameterMap = Maps.newHashMap(genericRequestMap);
        Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
        SessionId sessionUser = this.sessionIdService.generateAuthenticatedSessionId(authzRequest.getHttpRequest(), user.getDn(), authzRequest.getPrompt());
        Set sessionAttributesKeySet = sessionUser.getSessionAttributes().keySet();
        requestParameterMap.forEach((key, value) -> {
            if (!sessionAttributesKeySet.contains(key)) {
                sessionUser.getSessionAttributes().put(key, value);
            }
        });
        this.cookieService.createSessionIdCookie(sessionUser, authzRequest.getHttpRequest(), authzRequest.getHttpResponse(), false);
        this.sessionIdService.updateAttributesWithUserClaims(sessionUser.getSessionAttributes(), user);
        this.sessionIdService.updateSessionId(sessionUser);
        this.log.trace("Session updated with {}", (Object)sessionUser);
        return sessionUser;
    }

    public Response createSuccessfulResponse(AuthorizationCodeGrant authorizationGrant, AuthzRequest authzRequest) throws IOException {
        String authorizationCode = authorizationGrant.getAuthorizationCode().getCode();
        AuthorizationChallengeResponse response = new AuthorizationChallengeResponse();
        response.setAuthorizationCode(authorizationCode);
        if (authzRequest.getShouldReturnLogoutStatusJwt()) {
            this.log.debug("Creating logout_status_jwt ...");
            ExecutionContext executionContext = ExecutionContext.of(authzRequest);
            LogoutStatusJwt logoutStatusJwt = authorizationGrant.createLogoutStatusJwt(executionContext);
            response.setLogoutStatusJwt(logoutStatusJwt.getCode());
            this.log.debug("Created logout_status_jwt.");
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ServerUtil.asJson(response)).cacheControl(ServerUtil.cacheControl(true)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

