/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import com.google.common.collect.Maps;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.binding.TokenBindingMessage;
import io.jans.as.model.crypto.binding.TokenBindingParseException;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.util.QueryStringDecoder;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.ClientAuthorization;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.auth.DpopService;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebService;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.authorize.ws.rs.AuthzRequestService;
import io.jans.as.server.ciba.CIBAPingCallbackService;
import io.jans.as.server.ciba.CIBAPushTokenDeliveryService;
import io.jans.as.server.model.authorize.AuthorizeParamsValidator;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.CIBAGrant;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.CibaRequestStatus;
import io.jans.as.server.model.common.DefaultScope;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.DeviceAuthorizationStatus;
import io.jans.as.server.model.common.DeviceCodeGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.LogoutStatusJwt;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.config.ConfigurationFactory;
import io.jans.as.server.model.exception.AcrChangedException;
import io.jans.as.server.model.exception.InvalidRedirectUrlException;
import io.jans.as.server.model.exception.InvalidSessionStateException;
import io.jans.as.server.model.token.JwrService;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.AcrService;
import io.jans.as.server.service.AttributeService;
import io.jans.as.server.service.AuthenticationFilterService;
import io.jans.as.server.service.ClientAuthorizationsService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.DeviceAuthorizationService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.UserService;
import io.jans.as.server.service.ciba.CibaRequestService;
import io.jans.as.server.service.external.ExternalConsentGatheringService;
import io.jans.as.server.service.external.ExternalCreateUserService;
import io.jans.as.server.service.external.ExternalPostAuthnService;
import io.jans.as.server.service.external.ExternalResourceOwnerPasswordCredentialsService;
import io.jans.as.server.service.external.ExternalSelectAccountService;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.ExternalPostAuthnContext;
import io.jans.as.server.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.service.external.session.SessionEvent;
import io.jans.as.server.service.external.session.SessionEventType;
import io.jans.as.server.util.RedirectUtil;
import io.jans.as.server.util.ServerUtil;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.util.Pair;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.spi.NoLogWebApplicationException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Path(value="/")
public class AuthorizeRestWebServiceImpl
implements AuthorizeRestWebService {
    private static final String SUCCESSFUL_RP_REDIRECT_COUNT = "successful_rp_redirect_count";
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private UserService userService;
    @Inject
    private Identity identity;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private AcrService acrService;
    @Inject
    private CIBAPushTokenDeliveryService cibaPushTokenDeliveryService;
    @Inject
    private CIBAPingCallbackService cibaPingCallbackService;
    @Inject
    private ExternalPostAuthnService externalPostAuthnService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    private AuthzRequestService authzRequestService;
    @Inject
    private ExternalSelectAccountService externalSelectAccountService;
    @Inject
    private ExternalCreateUserService externalCreateUserService;
    @Inject
    private ExternalResourceOwnerPasswordCredentialsService externalResourceOwnerPasswordCredentialsService;
    @Inject
    private ExternalConsentGatheringService externalConsentGatheringService;
    @Inject
    private DpopService dpopService;
    @Context
    private HttpServletRequest servletRequest;

    @Override
    public Response requestAuthorizationGet(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String sessionId, String originHeaders, String codeChallenge, String codeChallengeMethod, String customResponseHeaders, String claims, String authReqId, String dpopJkt, String shouldReturnLogoutStatusJwt, String authorizationDetails, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        AuthzRequest authzRequest = new AuthzRequest();
        authzRequest.setHttpMethod("GET");
        authzRequest.setScope(scope);
        authzRequest.setResponseType(responseType);
        authzRequest.setClientId(clientId);
        authzRequest.setRedirectUri(redirectUri);
        authzRequest.setState(state);
        authzRequest.setResponseMode(responseMode);
        authzRequest.setNonce(nonce);
        authzRequest.setDisplay(display);
        authzRequest.setPrompt(prompt);
        authzRequest.setMaxAge(maxAge);
        authzRequest.setUiLocales(uiLocales);
        authzRequest.setIdTokenHint(idTokenHint);
        authzRequest.setLoginHint(loginHint);
        authzRequest.setAcrValues(acrValues);
        authzRequest.setAmrValues(amrValues);
        authzRequest.setDpopJkt(dpopJkt);
        authzRequest.setShouldReturnLogoutStatusJwt(Boolean.parseBoolean(shouldReturnLogoutStatusJwt));
        authzRequest.setAuthzDetailsString(authorizationDetails);
        authzRequest.setRequest(request);
        authzRequest.setRequestUri(requestUri);
        authzRequest.setSessionId(sessionId);
        authzRequest.setOriginHeaders(originHeaders);
        authzRequest.setCodeChallenge(codeChallenge);
        authzRequest.setCodeChallengeMethod(codeChallengeMethod);
        authzRequest.setCustomResponseHeaders(customResponseHeaders);
        authzRequest.setClaims(claims);
        authzRequest.setAuthReqId(authReqId);
        authzRequest.setHttpRequest(httpRequest);
        authzRequest.setHttpResponse(httpResponse);
        authzRequest.setSecurityContext(securityContext);
        return this.requestAuthorization(authzRequest);
    }

    @Override
    public Response requestAuthorizationPost(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String sessionId, String originHeaders, String codeChallenge, String codeChallengeMethod, String customResponseHeaders, String claims, String authReqId, String dpopJkt, String shouldReturnLogoutStatusJwt, String authorizationDetails, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        AuthzRequest authzRequest = new AuthzRequest();
        authzRequest.setHttpMethod("POST");
        authzRequest.setScope(scope);
        authzRequest.setResponseType(responseType);
        authzRequest.setClientId(clientId);
        authzRequest.setRedirectUri(redirectUri);
        authzRequest.setState(state);
        authzRequest.setResponseMode(responseMode);
        authzRequest.setNonce(nonce);
        authzRequest.setDisplay(display);
        authzRequest.setPrompt(prompt);
        authzRequest.setMaxAge(maxAge);
        authzRequest.setUiLocales(uiLocales);
        authzRequest.setIdTokenHint(idTokenHint);
        authzRequest.setLoginHint(loginHint);
        authzRequest.setAcrValues(acrValues);
        authzRequest.setAmrValues(amrValues);
        authzRequest.setRequest(request);
        authzRequest.setRequestUri(requestUri);
        authzRequest.setDpopJkt(dpopJkt);
        authzRequest.setShouldReturnLogoutStatusJwt(Boolean.parseBoolean(shouldReturnLogoutStatusJwt));
        authzRequest.setAuthzDetailsString(authorizationDetails);
        authzRequest.setSessionId(sessionId);
        authzRequest.setOriginHeaders(originHeaders);
        authzRequest.setCodeChallenge(codeChallenge);
        authzRequest.setCodeChallengeMethod(codeChallengeMethod);
        authzRequest.setCustomResponseHeaders(customResponseHeaders);
        authzRequest.setClaims(claims);
        authzRequest.setAuthReqId(authReqId);
        authzRequest.setHttpRequest(httpRequest);
        authzRequest.setHttpResponse(httpResponse);
        authzRequest.setSecurityContext(securityContext);
        return this.requestAuthorization(authzRequest);
    }

    private Response requestAuthorization(AuthzRequest authzRequest) {
        Response.ResponseBuilder builder;
        this.authorizeRestWebServiceValidator.validateNotWebView(authzRequest.getHttpRequest());
        authzRequest.setScope(ServerUtil.urlDecode(authzRequest.getScope()));
        this.authzRequestService.createOauth2AuditLog(authzRequest);
        this.log.debug("Attempting to request authorization: {}", (Object)authzRequest);
        this.authzRequestService.setCustomParameters(authzRequest);
        try {
            builder = this.authorize(authzRequest);
        }
        catch (WebApplicationException e) {
            this.applicationAuditLogger.sendMessage(authzRequest.getAuditLog());
            if (this.log.isTraceEnabled() && AuthzRequestService.canLogWebApplicationException(e)) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (AcrChangedException e) {
            this.log.debug("ACR is changed, please provide a supported and enabled acr value");
            this.log.debug(e.getMessage(), (Throwable)e);
            RedirectUri redirectUriResponse = new RedirectUri(authzRequest.getRedirectUri(), authzRequest.getResponseTypeList(), authzRequest.getResponseModeEnum());
            redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.SESSION_SELECTION_REQUIRED, authzRequest.getState()));
            redirectUriResponse.addResponseParameter("hint", "Use prompt=login in order to alter existing session.");
            this.applicationAuditLogger.sendMessage(authzRequest.getAuditLog());
            return RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, authzRequest.getHttpRequest()).build();
        }
        catch (EntryPersistenceException e) {
            builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, authzRequest.getState(), "")).type(MediaType.APPLICATION_JSON_TYPE);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidRedirectUrlException e) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, authzRequest.getState(), "")).type(MediaType.APPLICATION_JSON_TYPE);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidSessionStateException ex) {
            throw ex;
        }
        catch (Exception e) {
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.applicationAuditLogger.sendMessage(authzRequest.getAuditLog());
        return builder.build();
    }

    private Response.ResponseBuilder authorize(AuthzRequest authzRequest) throws AcrChangedException, SearchException, TokenBindingParseException {
        String tokenBindingHeader = authzRequest.getHttpRequest().getHeader("Sec-Token-Binding");
        boolean isPar = this.authzRequestService.processPar(authzRequest);
        List<ResponseType> responseTypes = authzRequest.getResponseTypeList();
        SessionId sessionUser = this.identity.getSessionId();
        User user = this.sessionIdService.getUser(sessionUser);
        this.updateSessionForROPC(authzRequest.getHttpRequest(), sessionUser);
        Client client = this.authorizeRestWebServiceValidator.validateClient(authzRequest, isPar);
        String deviceAuthzUserCode = this.deviceAuthorizationService.getUserCodeFromSession(authzRequest.getHttpRequest());
        authzRequest.setRedirectUri(this.authorizeRestWebServiceValidator.validateRedirectUri(client, authzRequest.getRedirectUri(), authzRequest.getState(), deviceAuthzUserCode, authzRequest.getHttpRequest()));
        this.authzRequestService.createRedirectUriResponse(authzRequest);
        this.acrService.validateAcrs(authzRequest, client);
        this.authorizeRestWebServiceValidator.validateAuthorizationDetails(authzRequest, client);
        this.authorizeRestWebServiceValidator.validateRequestParameterSupported(authzRequest);
        this.authorizeRestWebServiceValidator.validateRequestUriParameterSupported(authzRequest);
        Set<String> scopes = this.scopeChecker.checkScopesPolicy(client, authzRequest.getScope());
        this.authorizeRestWebServiceValidator.checkSignedRequestRequired(authzRequest);
        this.authzRequestService.processRequestObject(authzRequest, client, scopes, user);
        this.validateRequestJwt(authzRequest, isPar, client);
        this.authorizeRestWebServiceValidator.validate(authzRequest, responseTypes, client);
        this.authorizeRestWebServiceValidator.validatePkce(authzRequest.getCodeChallenge(), authzRequest.getRedirectUriResponse(), client);
        this.dpopService.validateDpopThumprintIsPresent(authzRequest.getDpopJkt(), authzRequest.getState());
        this.authzRequestService.setAcrsIfNeeded(authzRequest);
        this.checkOfflineAccessScopes(responseTypes, authzRequest.getPromptList(), client, scopes);
        this.checkResponseType(authzRequest, responseTypes, client);
        User ropcUser = this.executeRopcIfRequired(user, new ExecutionContext(authzRequest.getHttpRequest(), authzRequest.getHttpResponse()));
        if (ropcUser != null) {
            user = ropcUser;
            sessionUser = this.generatedAuthenticatedSessionForRopc(authzRequest, sessionUser, user);
        }
        this.checkPromptCreate(authzRequest);
        AuthorizationGrant authorizationGrant = null;
        if (user == null) {
            Pair<User, SessionId> pair = this.ifUserIsNull(authzRequest);
            user = (User)pair.getFirst();
            sessionUser = (SessionId)pair.getSecond();
        }
        this.validateMaxAge(authzRequest, sessionUser, client);
        authzRequest.getAuditLog().setUsername(user.getUserId());
        ExternalPostAuthnContext postAuthnContext = new ExternalPostAuthnContext(client, sessionUser, authzRequest, authzRequest.getPromptList());
        this.checkForceReAuthentication(authzRequest, client, postAuthnContext);
        this.checkForceAuthorization(authzRequest, client, postAuthnContext);
        ClientAuthorization clientAuthorization = null;
        boolean clientAuthorizationFetched = false;
        if (!scopes.isEmpty()) {
            Pair<ClientAuthorization, Boolean> pair = this.grantAccessOrFetchClientAuthorization(authzRequest, client, sessionUser, user, scopes);
            clientAuthorization = (ClientAuthorization)pair.getFirst();
            clientAuthorizationFetched = (Boolean)pair.getSecond();
        }
        this.addPromptLoginIfNeeded(authzRequest, client);
        this.checkPromptLogin(authzRequest);
        this.checkPromptConsent(authzRequest, sessionUser, user, clientAuthorization, clientAuthorizationFetched);
        this.checkPromptSelectAccount(authzRequest);
        AuthorizationCode authorizationCode = null;
        if (responseTypes.contains(ResponseType.CODE)) {
            authorizationGrant = this.authorizationGrantList.createAuthorizationCodeGrant(user, client, sessionUser.getAuthenticationTime());
            authorizationGrant.setNonce(authzRequest.getNonce());
            authorizationGrant.setJwtAuthorizationRequest(authzRequest.getJwtRequest());
            authorizationGrant.setTokenBindingHash(TokenBindingMessage.getTokenBindingIdHashFromTokenBindingMessage((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()));
            authorizationGrant.setScopes(scopes);
            authorizationGrant.setAuthzDetails(authzRequest.getAuthzDetails());
            authorizationGrant.setCodeChallenge(authzRequest.getCodeChallenge());
            authorizationGrant.setCodeChallengeMethod(authzRequest.getCodeChallengeMethod());
            authorizationGrant.setClaims(authzRequest.getClaims());
            authorizationGrant.setDpopJkt(authzRequest.getDpopJkt());
            authorizationGrant.setAcrValues(this.getAcrForGrant(authzRequest.getAcrValues(), sessionUser));
            authorizationGrant.setSessionDn(sessionUser.getDn());
            authorizationGrant.save();
            authorizationCode = authorizationGrant.getAuthorizationCode();
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("code", authorizationCode.getCode());
        }
        AccessToken newAccessToken = null;
        if (responseTypes.contains(ResponseType.TOKEN)) {
            if (authorizationGrant == null) {
                authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, sessionUser.getAuthenticationTime());
                authorizationGrant.setNonce(authzRequest.getNonce());
                authorizationGrant.setJwtAuthorizationRequest(authzRequest.getJwtRequest());
                authorizationGrant.setScopes(scopes);
                authorizationGrant.setAuthzDetails(authzRequest.getAuthzDetails());
                authorizationGrant.setClaims(authzRequest.getClaims());
                authorizationGrant.setAcrValues(this.getAcrForGrant(authzRequest.getAcrValues(), sessionUser));
                authorizationGrant.setSessionDn(sessionUser.getDn());
                authorizationGrant.save();
            }
            ExecutionContext executionContext = new ExecutionContext(authzRequest.getHttpRequest(), authzRequest.getHttpResponse());
            executionContext.setCertAsPem(authzRequest.getHttpRequest().getHeader("X-ClientCert"));
            newAccessToken = authorizationGrant.createAccessToken(executionContext);
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("access_token", newAccessToken.getCode());
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("token_type", newAccessToken.getTokenType().toString());
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("expires_in", "" + newAccessToken.getExpiresIn());
        }
        if (responseTypes.contains(ResponseType.ID_TOKEN)) {
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            if (authorizationGrant == null) {
                includeIdTokenClaims = true;
                authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, sessionUser.getAuthenticationTime());
                authorizationGrant.setNonce(authzRequest.getNonce());
                authorizationGrant.setJwtAuthorizationRequest(authzRequest.getJwtRequest());
                authorizationGrant.setScopes(scopes);
                authorizationGrant.setAuthzDetails(authzRequest.getAuthzDetails());
                authorizationGrant.setClaims(authzRequest.getClaims());
                authorizationGrant.setAcrValues(this.getAcrForGrant(authzRequest.getAcrValues(), sessionUser));
                authorizationGrant.setSessionDn(sessionUser.getDn());
                authorizationGrant.save();
            }
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(authzRequest.getHttpRequest(), authorizationGrant, client, this.appConfiguration, this.attributeService);
            Function<JsonWebResponse, Void> preProcessor = JwrService.wrapWithSidFunction((Function<JsonWebResponse, Void>)TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()), sessionUser.getOutsideSid());
            Function<JsonWebResponse, Void> postProcessor = this.externalUpdateTokenService.buildModifyIdTokenProcessor(context);
            ExecutionContext executionContext = context.toExecutionContext();
            executionContext.setPreProcessing(preProcessor);
            executionContext.setPostProcessor(postProcessor);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setGrant(authorizationGrant);
            IdToken idToken = authorizationGrant.createIdToken(authzRequest.getNonce(), authorizationCode, newAccessToken, null, authzRequest.getState(), executionContext);
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("id_token", idToken.getCode());
        }
        this.addResponseParameterAcrValues(authzRequest, authorizationGrant);
        this.addResponseParameterCustomParameters(authzRequest);
        if (sessionUser.getId() == null) {
            SessionId newSessionUser = this.sessionIdService.generateAuthenticatedSessionId(authzRequest.getHttpRequest(), sessionUser.getUserDn(), authzRequest.getPrompt());
            String newSessionId = newSessionUser.getId();
            sessionUser.setId(newSessionId);
            this.log.trace("newSessionId = {}", (Object)newSessionId);
        }
        this.addResponseParameterSessionId(authzRequest, sessionUser);
        this.addResponseParameterSid(authzRequest, sessionUser);
        this.addResponseParameterLogoutStatusJwt(authzRequest, sessionUser, client, authorizationGrant);
        authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("session_state", this.sessionIdService.computeSessionState(sessionUser, authzRequest.getClientId(), authzRequest.getRedirectUri()));
        authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("state", authzRequest.getState());
        this.addResponseParameterScope(authzRequest, authorizationGrant);
        this.clientService.updateAccessTime(client, false);
        authzRequest.getAuditLog().setSuccess(true);
        Response.ResponseBuilder builder = RedirectUtil.getRedirectResponseBuilder(authzRequest.getRedirectUriResponse().getRedirectUri(), authzRequest.getHttpRequest());
        this.addCustomHeaders(builder, authzRequest);
        this.updateSession(authzRequest, sessionUser, user);
        this.runCiba(authzRequest, client);
        this.processDeviceAuthorization(deviceAuthzUserCode, user);
        return builder;
    }

    @NotNull
    private SessionId generatedAuthenticatedSessionForRopc(AuthzRequest authzRequest, SessionId sessionUser, User user) {
        if (sessionUser == null) {
            this.log.trace("Generating authenticated session.");
            Map<String, String> genericRequestMap = AuthorizeRestWebServiceImpl.getGenericRequestMap(authzRequest.getHttpRequest());
            HashMap parameterMap = Maps.newHashMap(genericRequestMap);
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            sessionUser = this.sessionIdService.generateAuthenticatedSessionId(authzRequest.getHttpRequest(), user.getDn(), authzRequest.getPrompt());
            sessionUser.setSessionAttributes(requestParameterMap);
            this.cookieService.createSessionIdCookie(sessionUser, authzRequest.getHttpRequest(), authzRequest.getHttpResponse(), false);
            this.sessionIdService.updateAttributesWithUserClaims(sessionUser.getSessionAttributes(), user);
            this.sessionIdService.updateSessionId(sessionUser);
        }
        return sessionUser;
    }

    private void addCustomHeaders(Response.ResponseBuilder builder, AuthzRequest authzRequest) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getCustomHeadersWithAuthorizationResponse())) {
            Map customResponseHeaders = Util.jsonObjectArrayStringAsMap((String)authzRequest.getCustomResponseHeaders());
            for (Map.Entry entry : customResponseHeaders.entrySet()) {
                builder.header((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addResponseParameterScope(AuthzRequest authzRequest, AuthorizationGrant authorizationGrant) {
        if (authorizationGrant != null && !this.appConfiguration.isFapi()) {
            authzRequest.setScope(authorizationGrant.checkScopesPolicy(authzRequest.getScope()));
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameterIfNotBlank("scope", authzRequest.getScope());
        }
    }

    private void addResponseParameterSid(AuthzRequest authzRequest, SessionId sessionUser) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getIncludeSidInResponse())) {
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("sid", sessionUser.getOutsideSid());
        }
    }

    private void addResponseParameterSessionId(AuthzRequest authzRequest, SessionId sessionUser) {
        if (!this.appConfiguration.isFapi() && BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdRequestParameterEnabled())) {
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("session_id", sessionUser.getId());
        }
    }

    private void addResponseParameterLogoutStatusJwt(AuthzRequest authzRequest, SessionId sessionUser, Client client, AuthorizationGrant authorizationGrant) {
        if (!authzRequest.getShouldReturnLogoutStatusJwt()) {
            return;
        }
        if (!this.appConfiguration.isFeatureEnabled(FeatureFlagType.LOGOUT_STATUS_JWT)) {
            this.log.debug("Unable to return Logout Status JWT because 'logout_status_jwt' feature flag is not present in AS configuration");
            return;
        }
        if (authorizationGrant == null) {
            this.log.debug("Unable to create Logout Status JWT because grant is null");
            return;
        }
        ExecutionContext executionContext = new ExecutionContext(authzRequest.getHttpRequest(), authzRequest.getHttpResponse());
        executionContext.setCertAsPem(authzRequest.getHttpRequest().getHeader("X-ClientCert"));
        LogoutStatusJwt logoutStatusJwt = authorizationGrant.createLogoutStatusJwt(executionContext);
        if (logoutStatusJwt != null) {
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("logout_status_jwt", logoutStatusJwt.getCode());
        }
    }

    private void addResponseParameterCustomParameters(AuthzRequest authzRequest) {
        for (Map.Entry<String, String> customParam : this.requestParameterService.getCustomParameters(authzRequest.getCustomParameters(), true).entrySet()) {
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter(customParam.getKey(), customParam.getValue());
        }
    }

    private void addResponseParameterAcrValues(AuthzRequest authzRequest, AuthorizationGrant authorizationGrant) {
        if (authorizationGrant != null && !this.appConfiguration.isFapi()) {
            authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameterIfNotBlank("acr_values", authzRequest.getAcrValues());
        }
    }

    private void checkPromptSelectAccount(AuthzRequest authzRequest) {
        if (authzRequest.getPromptList().contains(Prompt.SELECT_ACCOUNT)) {
            this.log.debug("Redirecting to Select Account");
            throw new NoLogWebApplicationException(this.redirectToSelectAccountPage(authzRequest));
        }
    }

    public void checkPromptCreate(AuthzRequest authzRequest) {
        if (authzRequest.getPromptList().contains(Prompt.CREATE)) {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDisablePromptCreate())) {
                this.log.debug("Skipped prompt=create handling. config disablePromptConsent=true.");
                return;
            }
            this.log.debug("Redirecting to Create User, prompt=create");
            throw new NoLogWebApplicationException(this.redirectToCreateUserPage(authzRequest));
        }
    }

    private void checkPromptConsent(AuthzRequest authzRequest, SessionId sessionUser, User user, ClientAuthorization clientAuthorization, boolean clientAuthorizationFetched) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDisablePromptConsent())) {
            this.log.trace("Disabled prompt=consent (because disablePromptConsent=true).");
            authzRequest.removePrompt(Prompt.CONSENT);
            return;
        }
        if (authzRequest.getPromptList().contains(Prompt.CONSENT) || !BooleanUtils.isTrue((Boolean)sessionUser.isPermissionGrantedForClient(authzRequest.getClientId())) || this.externalConsentGatheringService.isEnabled()) {
            if (!authzRequest.getPromptList().contains(Prompt.CONSENT) && BooleanUtils.isTrue((Boolean)sessionUser.isPermissionGrantedForClient(authzRequest.getClientId()))) {
                return;
            }
            if (!clientAuthorizationFetched) {
                clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), authzRequest.getClient().getClientId());
            }
            this.clientAuthorizationsService.clearAuthorizations(clientAuthorization, authzRequest.getClient().getPersistClientAuthorizations());
            authzRequest.removePrompt(Prompt.CONSENT);
            this.log.debug("prompt=consent, redirect to authorization page on prompt=consent, request {}", (Object)authzRequest);
            throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
        }
    }

    public void checkPromptLogin(AuthzRequest authzRequest) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDisablePromptLogin())) {
            this.log.trace("Disabled prompt=login (because disablePromptLogin=true).");
            authzRequest.removePrompt(Prompt.LOGIN);
            return;
        }
        if (authzRequest.getPromptList().contains(Prompt.LOGIN)) {
            if (this.identity.getSessionId().getState() == SessionIdState.AUTHENTICATED) {
                this.unauthenticateSession(authzRequest.getSessionId(), authzRequest.getHttpRequest(), authzRequest.isPromptFromJwt());
            }
            authzRequest.setSessionId(null);
            authzRequest.removePrompt(Prompt.LOGIN);
            this.log.debug("prompt=login, redirect to authorization page, request {}", (Object)authzRequest);
            throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
        }
    }

    private void addPromptLoginIfNeeded(AuthzRequest authzRequest, Client client) {
        if (this.identity != null && this.identity.getSessionId() != null && this.identity.getSessionId().getState() == SessionIdState.AUTHENTICATED && Boolean.TRUE.equals(client.getAttributes().getDefaultPromptLogin()) && this.isSessionAuthnTimeOldForPromptLogin(this.identity.getSessionId())) {
            authzRequest.addPrompt(Prompt.LOGIN);
        }
    }

    public boolean isSessionAuthnTimeOldForPromptLogin(SessionId sessionId) {
        if (this.appConfiguration.getSkipSessionAuthnTimeCheckDuringPromptLogin().booleanValue() || sessionId.getAuthenticationTime() == null) {
            return false;
        }
        return new Date().getTime() - sessionId.getAuthenticationTime().getTime() > (long)this.appConfiguration.getSessionAuthnTimeCheckDuringPromptLoginThresholdMs().intValue();
    }

    private Pair<ClientAuthorization, Boolean> grantAccessOrFetchClientAuthorization(AuthzRequest authzRequest, Client client, SessionId sessionUser, User user, Set<String> scopes) {
        ClientAuthorization clientAuthorization = null;
        boolean clientAuthorizationFetched = false;
        List<Prompt> prompts = authzRequest.getPromptList();
        if (prompts.contains(Prompt.CONSENT)) {
            this.log.debug("prompt=consent - redirect to authorization page, request {}", (Object)authzRequest);
            throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
        }
        AuthzDetails authzDetails = authzRequest.getAuthzDetails();
        if (authzDetails != null && authzDetails.getDetails() != null && !authzDetails.getDetails().isEmpty()) {
            return new Pair(clientAuthorization, (Object)clientAuthorizationFetched);
        }
        boolean clientHasAllScopes = this.sessionIdService.hasClientAllScopes(sessionUser, client.getClientId(), scopes);
        boolean permissionGrantedForClient = BooleanUtils.isTrue((Boolean)sessionUser.isPermissionGrantedForClient(client.getClientId()));
        boolean pairwiseWithOnlyOpenIdScope = this.isPairwiseWithOnlyOpenIdScope(client, authzRequest, scopes);
        if (client.getTrustedClient() || clientHasAllScopes && permissionGrantedForClient || pairwiseWithOnlyOpenIdScope) {
            this.log.trace("Granting access to session {}, clientTrusted: {}, clientHasAllScopes: {}, permissionGrantedForClient: {}, pairwiseWithOnlyOpenIdScope: {}", new Object[]{sessionUser.getId(), client.getTrustedClient(), clientHasAllScopes, permissionGrantedForClient, pairwiseWithOnlyOpenIdScope});
            sessionUser.addPermission(authzRequest.getClientId(), Boolean.valueOf(true));
            this.sessionIdService.updateSessionId(sessionUser);
        } else {
            clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), client.getClientId());
            clientAuthorizationFetched = true;
            if (clientAuthorization == null || clientAuthorization.getScopes() == null || clientAuthorization.getScopes().length == 0) {
                this.log.trace("no client authorizations - redirect to authorization page, no appropriate clientAuthorization, clientId: {}", (Object)client.getClientId());
                throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Found clientAuthorization - scope: {}, dn: {}, requestedScope: {}", new Object[]{authzRequest.getScope(), clientAuthorization.getDn(), scopes});
            }
            if (Arrays.asList(clientAuthorization.getScopes()).containsAll(scopes)) {
                this.log.trace("Granting access to session {}, clientAuthorization has all scopes {}", (Object)sessionUser.getId(), (Object)clientAuthorization.getScopes());
                sessionUser.addPermission(authzRequest.getClientId(), Boolean.valueOf(true));
                this.sessionIdService.updateSessionId(sessionUser);
            } else {
                this.log.debug("no required scopes in client authz - redirect to authorization page, request {}", (Object)authzRequest);
                throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
            }
        }
        return new Pair((Object)clientAuthorization, (Object)clientAuthorizationFetched);
    }

    private boolean isPairwiseWithOnlyOpenIdScope(Client client, AuthzRequest authzRequest, Set<String> scopes) {
        return client.getSubjectType() == SubjectType.PAIRWISE && scopes.size() == 1 && scopes.contains(DefaultScope.OPEN_ID.toString()) && authzRequest.getClaims() == null && (authzRequest.getJwtRequest() == null || authzRequest.getJwtRequest().getUserInfoMember() == null && authzRequest.getJwtRequest().getIdTokenMember() == null);
    }

    private void validateRequestJwt(AuthzRequest authzRequest, boolean isPar, Client client) {
        if (!this.cibaRequestService.hasCibaCompatibility(client) && !isPar) {
            if (this.appConfiguration.isFapi() && authzRequest.getJwtRequest() == null) {
                throw authzRequest.getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST);
            }
            this.authorizeRestWebServiceValidator.validateRequestJwt(authzRequest.getRequest(), authzRequest.getRequestUri(), authzRequest.getRedirectUriResponse());
        }
    }

    private void checkResponseType(AuthzRequest authzRequest, List<ResponseType> responseTypes, Client client) {
        boolean isResponseTypeValid;
        boolean bl = isResponseTypeValid = AuthorizeParamsValidator.validateResponseTypes(responseTypes, client) && AuthorizeParamsValidator.validateGrantType(responseTypes, client.getGrantTypes(), this.appConfiguration);
        if (!isResponseTypeValid) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNSUPPORTED_RESPONSE_TYPE, authzRequest.getState(), "")).build());
        }
    }

    private void checkForceAuthorization(AuthzRequest authzRequest, Client client, ExternalPostAuthnContext postAuthnContext) {
        boolean forceAuthorization = this.externalPostAuthnService.externalForceAuthorization(client, postAuthnContext);
        if (forceAuthorization) {
            this.log.debug("Force authz - redirect to authorization page, request {}", (Object)authzRequest);
            throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
        }
    }

    private void checkForceReAuthentication(AuthzRequest authzRequest, Client client, ExternalPostAuthnContext postAuthnContext) {
        boolean forceReAuthentication = this.externalPostAuthnService.externalForceReAuthentication(client, postAuthnContext);
        if (forceReAuthentication) {
            this.unauthenticateSession(authzRequest.getSessionId(), authzRequest.getHttpRequest());
            authzRequest.setSessionId(null);
            this.log.debug("forceReAuthentication - redirect to authorization page, request {}", (Object)authzRequest);
            throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
        }
    }

    private void validateMaxAge(AuthzRequest authzRequest, SessionId sessionUser, Client client) {
        boolean validAuthenticationMaxAge = this.authorizeRestWebServiceValidator.isAuthnMaxAgeValid(authzRequest.getMaxAge(), sessionUser, client);
        if (!validAuthenticationMaxAge) {
            this.unauthenticateSession(authzRequest.getSessionId(), authzRequest.getHttpRequest());
            authzRequest.setSessionId(null);
            this.log.debug("validateMaxAge - redirect to authorization page, request {}", (Object)authzRequest);
            throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
        }
    }

    public void checkOfflineAccessScopes(List<ResponseType> responseTypes, List<Prompt> prompts, Client client, Set<String> scopes) {
        if (!scopes.contains("offline_access") || client.getTrustedClient()) {
            return;
        }
        if (!responseTypes.contains(ResponseType.CODE)) {
            this.log.trace("Removed (ignored) offline_scope. Can't find `code` in response_type which is required.");
            scopes.remove("offline_access");
        }
        if (scopes.contains("offline_access") && !prompts.contains(Prompt.CONSENT) && !BooleanUtils.toBoolean((Boolean)client.getAttributes().getAllowOfflineAccessWithoutConsent())) {
            this.log.error("Removed offline_access. Can't find prompt=consent. Consent is required for offline_access.");
            scopes.remove("offline_access");
        }
    }

    private Pair<User, SessionId> ifUserIsNull(AuthzRequest authzRequest) throws SearchException {
        this.identity.logout();
        if (authzRequest.getPromptList().contains(Prompt.NONE)) {
            if (this.authenticationFilterService.isEnabled()) {
                Map params = authzRequest.getHttpMethod().equals("GET") ? QueryStringDecoder.decode((String)authzRequest.getHttpRequest().getQueryString()) : AuthorizeRestWebServiceImpl.getGenericRequestMap(authzRequest.getHttpRequest());
                String userDn = this.authenticationFilterService.processAuthenticationFilters(params);
                if (userDn != null) {
                    Map<String, String> genericRequestMap = AuthorizeRestWebServiceImpl.getGenericRequestMap(authzRequest.getHttpRequest());
                    HashMap parameterMap = Maps.newHashMap(genericRequestMap);
                    Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
                    SessionId sessionUser = this.sessionIdService.generateAuthenticatedSessionId(authzRequest.getHttpRequest(), userDn, authzRequest.getPrompt());
                    User user = this.userService.getUserByDnSilently(sessionUser.getUserDn(), new String[0]);
                    sessionUser.setSessionAttributes(requestParameterMap);
                    this.cookieService.createSessionIdCookie(sessionUser, authzRequest.getHttpRequest(), authzRequest.getHttpResponse(), false);
                    this.sessionIdService.updateAttributesWithUserClaims(sessionUser.getSessionAttributes(), user);
                    this.sessionIdService.updateSessionId(sessionUser);
                    return new Pair((Object)user, (Object)sessionUser);
                }
                this.applicationAuditLogger.sendMessage(authzRequest.getAuditLog());
                throw new WebApplicationException(authzRequest.getRedirectUriResponse().createErrorBuilder((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED).build());
            }
            throw new WebApplicationException(authzRequest.getRedirectUriResponse().createErrorBuilder((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED).build());
        }
        if (authzRequest.getPromptList().contains(Prompt.LOGIN)) {
            this.unauthenticateSession(authzRequest.getSessionId(), authzRequest.getHttpRequest(), authzRequest.isPromptFromJwt());
            authzRequest.setSessionId(null);
            authzRequest.removePrompt(Prompt.LOGIN);
        }
        this.log.debug("prompt=login, redirect to authorization page, request {}", (Object)authzRequest);
        throw new NoLogWebApplicationException(this.redirectToAuthorizationPage(authzRequest));
    }

    private String getAcrForGrant(String acrValuesStr, SessionId sessionUser) {
        String acr = this.sessionIdService.getAcr(sessionUser);
        return StringUtils.isNotBlank((CharSequence)acr) ? acr : acrValuesStr;
    }

    private void runCiba(AuthzRequest authzRequest, Client client) {
        String authReqId = authzRequest.getAuthReqId();
        if (StringUtils.isBlank((CharSequence)authReqId)) {
            return;
        }
        CibaRequestCacheControl cibaRequest = this.cibaRequestService.getCibaRequest(authReqId);
        if (cibaRequest == null || cibaRequest.getStatus() == CibaRequestStatus.EXPIRED) {
            this.log.trace("User responded too late and the grant {} has expired, {}", (Object)authReqId, (Object)cibaRequest);
            return;
        }
        this.cibaRequestService.removeCibaRequest(authReqId);
        CIBAGrant cibaGrant = this.authorizationGrantList.createCIBAGrant(cibaRequest);
        ExecutionContext executionContext = new ExecutionContext(authzRequest.getHttpRequest(), authzRequest.getHttpResponse());
        executionContext.setAppConfiguration(this.appConfiguration);
        executionContext.setAttributeService(this.attributeService);
        executionContext.setGrant(cibaGrant);
        executionContext.setClient(client);
        executionContext.setCertAsPem(authzRequest.getHttpRequest().getHeader("X-ClientCert"));
        executionContext.setScopes((Set<String>)(StringUtils.isNotBlank((CharSequence)authzRequest.getScope()) ? new HashSet<String>(Arrays.asList(authzRequest.getScope().split(" "))) : new HashSet()));
        executionContext.setAuthzRequest(authzRequest);
        executionContext.setAuthzDetails(authzRequest.getAuthzDetails());
        AccessToken accessToken = cibaGrant.createAccessToken(executionContext);
        this.log.debug("Issuing access token: {}", (Object)accessToken.getCode());
        ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(authzRequest.getHttpRequest(), cibaGrant, client, this.appConfiguration, this.attributeService);
        int refreshTokenLifetimeInSeconds = this.externalUpdateTokenService.getRefreshTokenLifetimeInSeconds(context);
        RefreshToken refreshToken = refreshTokenLifetimeInSeconds > 0 ? cibaGrant.createRefreshToken(executionContext, refreshTokenLifetimeInSeconds) : cibaGrant.createRefreshToken(executionContext);
        this.log.debug("Issuing refresh token: {}", (Object)(refreshToken != null ? refreshToken.getCode() : ""));
        executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
        executionContext.setGrant(cibaGrant);
        executionContext.setIncludeIdTokenClaims(Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims()));
        IdToken idToken = cibaGrant.createIdToken(null, null, accessToken, refreshToken, null, executionContext);
        cibaGrant.setTokensDelivered(true);
        cibaGrant.save();
        if (cibaRequest.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH) {
            this.cibaPushTokenDeliveryService.pushTokenDelivery(cibaGrant.getAuthReqId(), cibaGrant.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken(), accessToken.getCode(), refreshToken != null ? refreshToken.getCode() : null, idToken.getCode(), accessToken.getExpiresIn());
        } else if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING) {
            cibaGrant.setTokensDelivered(false);
            cibaGrant.save();
            this.cibaPingCallbackService.pingCallback(cibaGrant.getAuthReqId(), cibaGrant.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken());
        } else if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.POLL) {
            cibaGrant.setTokensDelivered(false);
            cibaGrant.save();
        }
    }

    private void updateSessionForROPC(HttpServletRequest httpRequest, SessionId sessionUser) {
        if (sessionUser == null) {
            return;
        }
        Map sessionAttributes = sessionUser.getSessionAttributes();
        String authorizedGrant = (String)sessionUser.getSessionAttributes().get("authorized_grant");
        if (StringHelper.isNotEmpty((String)authorizedGrant) && GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS == GrantType.fromString((String)authorizedGrant)) {
            sessionAttributes.remove("authorized_grant");
            Map<String, String> parameterMap = AuthorizeRestWebServiceImpl.getGenericRequestMap(httpRequest);
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            sessionAttributes.putAll(requestParameterMap);
            this.sessionIdService.updateSessionId(sessionUser, true, true, true);
        }
    }

    public static Map<String, String> getGenericRequestMap(HttpServletRequest httpRequest) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : httpRequest.getParameterMap().entrySet()) {
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return result;
    }

    private Response redirectToAuthorizationPage(AuthzRequest authzRequest) {
        return this.redirectTo("/authorize", authzRequest);
    }

    private Response redirectToSelectAccountPage(AuthzRequest authzRequest) {
        ExecutionContext executionContext = ExecutionContext.of(authzRequest);
        executionContext.setAppConfiguration(this.appConfiguration);
        executionContext.setAttributeService(this.attributeService);
        String page = "/selectAccount";
        String selectAccountPageFromScript = this.externalSelectAccountService.externalGetSelectAccountPage(executionContext);
        if (StringUtils.isNotBlank((CharSequence)selectAccountPageFromScript)) {
            if (selectAccountPageFromScript.endsWith(".xhtml")) {
                selectAccountPageFromScript = StringUtils.removeEnd((String)selectAccountPageFromScript, (String)".xhtml");
            }
            page = selectAccountPageFromScript;
        }
        return this.redirectTo(page, authzRequest);
    }

    private Response redirectToCreateUserPage(AuthzRequest authzRequest) {
        ExecutionContext executionContext = ExecutionContext.of(authzRequest);
        executionContext.setAppConfiguration(this.appConfiguration);
        executionContext.setAttributeService(this.attributeService);
        String page = "/createUser";
        String pageFromScript = this.externalCreateUserService.externalGetCreateUserPage(executionContext);
        if (StringUtils.isNotBlank((CharSequence)pageFromScript)) {
            if (pageFromScript.endsWith(".xhtml")) {
                pageFromScript = StringUtils.removeEnd((String)pageFromScript, (String)".xhtml");
            }
            page = pageFromScript;
        }
        authzRequest.setPrompt("");
        return this.redirectTo(page, authzRequest);
    }

    private Response redirectTo(String pathToRedirect, AuthzRequest authzRequest) {
        URI contextUri = URI.create(this.appConfiguration.getIssuer()).resolve(this.servletRequest.getContextPath() + pathToRedirect + this.configurationFactory.getFacesMapping());
        this.log.debug("Redirecting to {}", (Object)contextUri);
        RedirectUri redirect = authzRequest.getRedirectUriResponse().getRedirectUri();
        redirect.setBaseRedirectUri(contextUri.toString());
        redirect.setResponseMode(ResponseMode.QUERY);
        redirect.addResponseParameterIfNotBlank("response_type", authzRequest.getResponseType());
        redirect.addResponseParameterIfNotBlank("scope", authzRequest.getScope());
        redirect.addResponseParameterIfNotBlank("client_id", authzRequest.getClientId());
        redirect.addResponseParameterIfNotBlank("redirect_uri", authzRequest.getRedirectUri());
        redirect.addResponseParameterIfNotBlank("state", authzRequest.getState());
        redirect.addResponseParameterIfNotBlank("response_mode", authzRequest.getResponseMode());
        redirect.addResponseParameterIfNotBlank("nonce", authzRequest.getNonce());
        redirect.addResponseParameterIfNotBlank("display", authzRequest.getDisplay());
        redirect.addResponseParameterIfNotBlank("prompt", authzRequest.getPrompt());
        redirect.addResponseParameterIfNotBlank("max_age", authzRequest.getMaxAge() != null ? authzRequest.getMaxAge().toString() : null);
        redirect.addResponseParameterIfNotBlank("ui_locales", authzRequest.getUiLocales());
        redirect.addResponseParameterIfNotBlank("id_token_hint", authzRequest.getIdTokenHint());
        redirect.addResponseParameterIfNotBlank("login_hint", authzRequest.getLoginHint());
        redirect.addResponseParameterIfNotBlank("acr_values", authzRequest.getAcrValues());
        redirect.addResponseParameterIfNotBlank("amr_values", authzRequest.getAmrValues());
        redirect.addResponseParameterIfNotBlank("request", authzRequest.getRequest());
        redirect.addResponseParameterIfNotBlank("request_uri", authzRequest.getRequestUri());
        redirect.addResponseParameterIfNotBlank("code_challenge", authzRequest.getCodeChallenge());
        redirect.addResponseParameterIfNotBlank("code_challenge_method", authzRequest.getCodeChallengeMethod());
        redirect.addResponseParameterIfNotBlank("session_id", authzRequest.getSessionId());
        redirect.addResponseParameterIfNotBlank("claims", authzRequest.getClaims());
        redirect.addResponseParameterIfNotBlank("authorization_details", authzRequest.getAuthzDetailsString());
        redirect.addResponseParameterIfNotBlank("logout_status_jwt", Boolean.toString(authzRequest.getShouldReturnLogoutStatusJwt()));
        redirect.addResponseParameterIfNotBlank("auth_req_id", authzRequest.getAuthReqId());
        redirect.addResponseParameterIfNotBlank("origin_headers", authzRequest.getOriginHeaders());
        Map<String, String> customParameters = authzRequest.getCustomParameters();
        if (customParameters != null && customParameters.size() > 0) {
            for (Map.Entry<String, String> entry : customParameters.entrySet()) {
                redirect.addResponseParameter(entry.getKey(), entry.getValue());
            }
        }
        Response.ResponseBuilder builder = RedirectUtil.getRedirectResponseBuilder(redirect, authzRequest.getHttpRequest());
        if (authzRequest.getAuditLog() != null) {
            this.applicationAuditLogger.sendMessage(authzRequest.getAuditLog());
        }
        return builder.build();
    }

    private void updateSession(AuthzRequest authzRequest, SessionId sessionUser, User user) {
        this.authzRequestService.addDeviceSecretToSession(authzRequest, sessionUser);
        int rpRedirectCount = Util.parseIntSilently((String)((String)sessionUser.getSessionAttributes().get(SUCCESSFUL_RP_REDIRECT_COUNT)), (int)0);
        sessionUser.getSessionAttributes().put(SUCCESSFUL_RP_REDIRECT_COUNT, Integer.toString(++rpRedirectCount));
        this.sessionIdService.updateAttributesWithUserClaims(sessionUser.getSessionAttributes(), user);
        this.sessionIdService.updateSessionId(sessionUser);
    }

    private boolean unauthenticateSession(String sessionId, HttpServletRequest httpRequest) {
        return this.unauthenticateSession(sessionId, httpRequest, false);
    }

    private boolean unauthenticateSession(String sessionId, HttpServletRequest httpRequest, boolean isPromptFromJwt) {
        SessionId persistenceSessionId;
        SessionId sessionUser = this.identity.getSessionId();
        if (isPromptFromJwt && sessionUser != null && !sessionUser.getSessionAttributes().containsKey(SUCCESSFUL_RP_REDIRECT_COUNT)) {
            return false;
        }
        if (sessionUser != null) {
            sessionUser.setUserDn(null);
            sessionUser.setUser(null);
            sessionUser.setAuthenticationTime(null);
        }
        this.identity.logout();
        if (StringHelper.isEmpty((String)sessionId)) {
            sessionId = this.cookieService.getSessionIdFromCookie(httpRequest);
        }
        if ((persistenceSessionId = this.sessionIdService.getSessionId(sessionId)) == null) {
            this.log.error("Failed to load session from LDAP by session_id: '{}'", (Object)sessionId);
            return true;
        }
        persistenceSessionId.setState(SessionIdState.UNAUTHENTICATED);
        persistenceSessionId.setUserDn(null);
        persistenceSessionId.setUser(null);
        persistenceSessionId.setAuthenticationTime(null);
        boolean result = this.sessionIdService.updateSessionId(persistenceSessionId);
        this.sessionIdService.externalEvent(new SessionEvent(SessionEventType.UNAUTHENTICATED, persistenceSessionId).setHttpRequest(httpRequest));
        if (!result) {
            this.log.error("Failed to update session_id '{}'", (Object)sessionId);
        }
        return result;
    }

    private void processDeviceAuthorization(String userCode, User user) {
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return;
        }
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByUserCode(userCode);
        if (cacheData == null || cacheData.getStatus() == DeviceAuthorizationStatus.EXPIRED) {
            this.log.trace("User responded too late and the authorization {} has expired, {}", (Object)userCode, (Object)cacheData);
            return;
        }
        this.deviceAuthorizationService.removeDeviceAuthRequestInCache(userCode, cacheData.getDeviceCode());
        DeviceCodeGrant deviceCodeGrant = this.authorizationGrantList.createDeviceGrant(cacheData, user);
        this.log.info("Granted device authorization request, user_code: {}, device_code: {}, grant_id: {}", new Object[]{userCode, cacheData.getDeviceCode(), deviceCodeGrant.getGrantId()});
    }

    private User executeRopcIfRequired(User user, ExecutionContext executionContext) {
        if (!this.appConfiguration.getForceRopcInAuthorizationEndpoint().booleanValue()) {
            return null;
        }
        this.log.trace("Triggering ROPC at Authorization Endpoint (forced by 'forceRopcInAuthorizationEndpoint' configuration property)");
        if (!this.externalResourceOwnerPasswordCredentialsService.isEnabled()) {
            this.log.trace("Skip ROPC because no ROPC script found.");
            return null;
        }
        ExternalResourceOwnerPasswordCredentialsContext context = new ExternalResourceOwnerPasswordCredentialsContext(executionContext);
        context.setUser(user);
        if (this.externalResourceOwnerPasswordCredentialsService.executeExternalAuthenticate(context)) {
            user = context.getUser();
            if (user != null) {
                this.log.trace("ROPC - User {} is authenticated successfully by external script.", (Object)user.getUserId());
                return user;
            }
            this.log.trace("ROPC returned True but user is not set (set valid user in context.setUser(<user>))");
        } else {
            this.log.trace("ROPC script returned False.");
        }
        return null;
    }
}

