/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authzen.ws.rs;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.server.authzen.ws.rs.AccessEvaluationService;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.authzen.AccessEvaluationRequest;
import io.jans.model.authzen.AccessEvaluationResponse;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/access/v1")
public class AccessEvaluationRestWebServiceImplV1 {
    public static final String X_REQUEST_ID = "X-Request-ID";
    @Inject
    private Logger log;
    @Inject
    private AccessEvaluationService accessEvaluationService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    @POST
    @Path(value="/evaluation")
    @Produces(value={"application/json"})
    public Response evaluation(String requestParams, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        this.log.trace("/evaluation - request params: {}", (Object)requestParams);
        try {
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION);
            String requestId = httpRequest.getHeader(X_REQUEST_ID);
            String authorization = httpRequest.getHeader("Authorization");
            this.accessEvaluationService.validateAuthorization(authorization);
            AccessEvaluationRequest request = this.readRequest(requestParams);
            ExecutionContext executionContext = ExecutionContext.of(httpRequest, httpResponse).setRequestId(requestId);
            AccessEvaluationResponse response = this.accessEvaluationService.evaluation(request, executionContext);
            String responseAsString = ServerUtil.asJson(response);
            this.log.trace("/evaluation - response entity: {}", (Object)responseAsString);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseAsString).type(MediaType.APPLICATION_JSON_TYPE).header(X_REQUEST_ID, (Object)requestId).build();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    protected AccessEvaluationRequest readRequest(String requestParams) {
        try {
            return (AccessEvaluationRequest)ServerUtil.createJsonMapper().readValue(requestParams, AccessEvaluationRequest.class);
        }
        catch (JsonProcessingException e) {
            String msg = String.format("Failed to parse request json: %s", requestParams);
            this.log.error(msg, (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

