/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authzen.ws.rs;

import io.jans.model.authzen.AccessEvaluationRequest;
import io.jans.model.authzen.Action;
import io.jans.model.authzen.Resource;
import io.jans.model.authzen.Subject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AccessEvaluationValidator {
    @Inject
    private Logger log;

    public void validateAccessEvaluationRequest(AccessEvaluationRequest request) {
        this.validateSubject(request.getSubject());
        this.validateResource(request.getResource());
        this.validateAction(request.getAction());
    }

    public void validateSubject(Subject subject) {
        if (subject == null) {
            String msg = "Invalid subject. Subject is not set";
            this.log.trace("Invalid subject. Subject is not set");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid subject. Subject is not set").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (StringUtils.isBlank((CharSequence)subject.getId())) {
            String msg = "Invalid subject. Subject id can't be blank";
            this.log.trace("Invalid subject. Subject id can't be blank");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid subject. Subject id can't be blank").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (StringUtils.isBlank((CharSequence)subject.getType())) {
            String msg = "Invalid subject. Subject type can't be blank";
            this.log.trace("Invalid subject. Subject type can't be blank");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid subject. Subject type can't be blank").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public void validateAction(Action action) {
        if (action == null) {
            String msg = "Invalid action. Action is not set";
            this.log.trace("Invalid action. Action is not set");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid action. Action is not set").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (StringUtils.isBlank((CharSequence)action.getName())) {
            String msg = "Invalid action. Action id can't be blank";
            this.log.trace("Invalid action. Action id can't be blank");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid action. Action id can't be blank").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public void validateResource(Resource resource) {
        if (resource == null) {
            String msg = "Invalid resource. Resource is not set";
            this.log.trace("Invalid resource. Resource is not set");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid resource. Resource is not set").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (StringUtils.isBlank((CharSequence)resource.getId())) {
            String msg = "Invalid resource. Resource id can't be blank";
            this.log.trace("Invalid resource. Resource id can't be blank");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid resource. Resource id can't be blank").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (StringUtils.isBlank((CharSequence)resource.getType())) {
            String msg = "Invalid resource. Resource type can't be blank";
            this.log.trace("Invalid resource. Resource type can't be blank");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid resource. Resource type can't be blank").type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

