/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.bcauthorize.ws.rs;

import io.jans.as.common.model.common.User;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import io.jans.as.model.ciba.BackchannelDeviceRegistrationErrorResponseType;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.DefaultErrorResponse;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.bcauthorize.ws.rs.BackchannelDeviceRegistrationRestWebService;
import io.jans.as.server.ciba.CIBADeviceRegistrationValidatorService;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.slf4j.Logger;

@Path(value="/")
public class BackchannelDeviceRegistrationRestWebServiceImpl
implements BackchannelDeviceRegistrationRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UserService userService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private CIBADeviceRegistrationValidatorService cibaDeviceRegistrationValidatorService;

    @Override
    public Response requestBackchannelDeviceRegistrationPost(String idTokenHint, String deviceRegistrationToken, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.BACKCHANNEL_DEVICE_REGISTRATION);
        this.log.debug("Attempting to request backchannel device registration: idTokenHint = {}, deviceRegistrationToken = {}, isSecure = {}", new Object[]{idTokenHint, deviceRegistrationToken, securityContext.isSecure()});
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.CIBA);
        Response.ResponseBuilder builder = Response.ok();
        DefaultErrorResponse cibaDeviceRegistrationValidation = this.cibaDeviceRegistrationValidatorService.validateParams(idTokenHint, deviceRegistrationToken);
        if (cibaDeviceRegistrationValidation != null) {
            builder = Response.status((int)cibaDeviceRegistrationValidation.getStatus());
            builder.entity((Object)this.errorResponseFactory.errorAsJson(cibaDeviceRegistrationValidation.getType(), cibaDeviceRegistrationValidation.getReason()));
            return builder.build();
        }
        User user = null;
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
            return builder.build();
        }
        user = authorizationGrant.getUser();
        if (user == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelDeviceRegistrationErrorResponseType.UNKNOWN_USER_ID));
            return builder.build();
        }
        this.userService.setCustomAttribute(user, "jansBackchannelDeviceRegistrationTkn", deviceRegistrationToken);
        this.userService.updateUser(user);
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }
}

