/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.client.BaseRequest;
import io.jans.as.client.ciba.fcm.FirebaseCloudMessagingClient;
import io.jans.as.client.ciba.fcm.FirebaseCloudMessagingRequest;
import io.jans.as.client.ciba.fcm.FirebaseCloudMessagingResponse;
import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.ciba.CibaEncryptionService;
import io.jans.as.server.service.external.ExternalCibaEndUserNotificationService;
import io.jans.as.server.service.external.context.ExternalCibaEndUserNotificationContext;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAEndUserNotificationService {
    private static final Logger log = LoggerFactory.getLogger(CIBAEndUserNotificationService.class);
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CibaEncryptionService cibaEncryptionService;
    @Inject
    private ExternalCibaEndUserNotificationService externalCibaEndUserNotificationService;

    public void notifyEndUser(String scope, String acrValues, String authReqId, String deviceRegistrationToken) {
        try {
            if (this.externalCibaEndUserNotificationService.isEnabled()) {
                log.debug("CIBA: Authorization request sending to the end user with custom interception scripts");
                ExternalCibaEndUserNotificationContext context = new ExternalCibaEndUserNotificationContext(scope, acrValues, authReqId, deviceRegistrationToken, this.appConfiguration, this.cibaEncryptionService);
                log.info("CIBA: Notification sent to the end user, result {}", (Object)this.externalCibaEndUserNotificationService.executeExternalNotifyEndUser(context));
            } else {
                this.notifyEndUserUsingFCM(scope, acrValues, authReqId, deviceRegistrationToken);
            }
        }
        catch (Exception e) {
            log.info("Error when it was sending the notification to the end user to validate the Ciba authorization", (Throwable)e);
        }
    }

    private void notifyEndUserUsingFCM(String scope, String acrValues, String authReqId, String deviceRegistrationToken) {
        String clientId = this.appConfiguration.getBackchannelClientId();
        String redirectUri = this.appConfiguration.getBackchannelRedirectUri();
        String url = this.appConfiguration.getCibaEndUserNotificationConfig().getNotificationUrl();
        String key = this.cibaEncryptionService.decrypt(this.appConfiguration.getCibaEndUserNotificationConfig().getNotificationKey(), true);
        String title = "Jans Auth Authentication Request";
        String body = "Client Initiated Backchannel Authentication (CIBA)";
        RedirectUri authorizationRequestUri = new RedirectUri(this.appConfiguration.getAuthorizationEndpoint());
        authorizationRequestUri.addResponseParameter("client_id", clientId);
        authorizationRequestUri.addResponseParameter("response_type", "id_token");
        authorizationRequestUri.addResponseParameter("scope", scope);
        authorizationRequestUri.addResponseParameter("acr_values", acrValues);
        authorizationRequestUri.addResponseParameter("redirect_uri", redirectUri);
        authorizationRequestUri.addResponseParameter("state", UUID.randomUUID().toString());
        authorizationRequestUri.addResponseParameter("nonce", UUID.randomUUID().toString());
        authorizationRequestUri.addResponseParameter("prompt", "consent");
        authorizationRequestUri.addResponseParameter("auth_req_id", authReqId);
        String clickAction = authorizationRequestUri.toString();
        FirebaseCloudMessagingRequest firebaseCloudMessagingRequest = new FirebaseCloudMessagingRequest(key, deviceRegistrationToken, title, body, clickAction);
        FirebaseCloudMessagingClient firebaseCloudMessagingClient = new FirebaseCloudMessagingClient(url);
        firebaseCloudMessagingClient.setRequest((BaseRequest)firebaseCloudMessagingRequest);
        FirebaseCloudMessagingResponse firebaseCloudMessagingResponse = firebaseCloudMessagingClient.exec();
        log.debug("CIBA: firebase cloud messaging result status {}", (Object)firebaseCloudMessagingResponse.getStatus());
    }
}

