/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.client.BaseRequest;
import io.jans.as.client.ciba.push.PushErrorClient;
import io.jans.as.client.ciba.push.PushErrorRequest;
import io.jans.as.client.ciba.push.PushErrorResponse;
import io.jans.as.model.ciba.PushErrorResponseType;
import jakarta.ejb.Stateless;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAPushErrorService {
    private static final Logger log = LoggerFactory.getLogger(CIBAPushErrorService.class);

    public void pushError(String authReqId, String clientNotificationEndpoint, String clientNotificationToken, PushErrorResponseType error, String errorDescription) {
        PushErrorRequest pushErrorRequest = new PushErrorRequest();
        pushErrorRequest.setClientNotificationToken(clientNotificationToken);
        pushErrorRequest.setAuthReqId(authReqId);
        pushErrorRequest.setErrorType(error);
        pushErrorRequest.setErrorDescription(errorDescription);
        PushErrorClient pushErrorClient = new PushErrorClient(clientNotificationEndpoint);
        pushErrorClient.setRequest((BaseRequest)pushErrorRequest);
        PushErrorResponse pushErrorResponse = pushErrorClient.exec();
        log.debug("CIBA: push error result status " + pushErrorResponse.getStatus());
    }
}

